/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI64StoreNode
extends LLVMStoreNode {
    public abstract void executeWithTarget(LLVMPointer var1, long var2);

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    protected void doOp(LLVMNativePointer address, long value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putI64((Node)this, address, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected static void doOpDerefHandleI64(LLVMNativePointer addr, long value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMI64StoreNode.doOpManagedI64(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"}, replaces={"doOpDerefHandleI64"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, Object value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMI64StoreNode.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(guards={"!isAutoDerefHandle(language, address)"})
    protected void doOpNative(LLVMNativePointer address, LLVMNativePointer value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putI64((Node)this, address, value.asNative());
    }

    @Specialization(replaces={"doOpNative"}, guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toAddress, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putI64((Node)this, addr, toAddress.executeWithTarget(value).asNative());
    }

    @Specialization(limit="3")
    protected static void doOpManagedI64(LLVMManagedPointer address, long value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI64(address.getObject(), address.getOffset(), value);
    }

    @Specialization(limit="3", replaces={"doOpManagedI64"})
    protected static void doOpManaged(LLVMManagedPointer address, Object value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeGenericI64(address.getObject(), address.getOffset(), value);
    }

    public static LLVMI64StoreNode create() {
        return LLVMI64StoreNodeGen.create(null, null);
    }

    @GenerateUncached
    public static abstract class LLVMI64OffsetStoreNode
    extends LLVMOffsetStoreNode {
        public static LLVMI64OffsetStoreNode create() {
            return LLVMI64StoreNodeGen.LLVMI64OffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMI64OffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMI64StoreNodeGen.LLVMI64OffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, long var4);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, long value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI64((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected static void doOpDerefHandleI64(LLVMNativePointer addr, long offset, long value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMI64OffsetStoreNode.doOpManagedI64(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"}, replaces={"doOpDerefHandleI64"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, Object value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMI64OffsetStoreNode.doOpManaged(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected void doOpNative(LLVMNativePointer addr, long offset, LLVMNativePointer value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI64((Node)this, addr.asNative() + offset, value.asNative());
        }

        @Specialization(replaces={"doOpNative"}, guards={"!isAutoDerefHandle(language, addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toAddress, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI64((Node)this, addr.asNative() + offset, toAddress.executeWithTarget(value).asNative());
        }

        @Specialization(limit="3")
        protected static void doOpManagedI64(LLVMManagedPointer address, long offset, long value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writeI64(address.getObject(), address.getOffset() + offset, value);
        }

        @Specialization(limit="3", replaces={"doOpManagedI64"})
        protected static void doOpManaged(LLVMManagedPointer address, long offset, Object value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writeGenericI64(address.getObject(), address.getOffset() + offset, value);
        }
    }
}

