/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMPointerLoadNode
extends LLVMLoadNode {
    public static LLVMPointerLoadNode create() {
        return LLVMPointerLoadNodeGen.create(null);
    }

    public abstract LLVMPointer executeWithTarget(LLVMPointer var1);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected LLVMNativePointer doNativePointer(LLVMNativePointer addr, @CachedLanguage LLVMLanguage language) {
        return language.getLLVMMemory().getPointer((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected LLVMPointer doDerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doIndirectedForeign(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected LLVMPointer doIndirectedForeign(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readPointer(addr.getObject(), addr.getOffset());
    }

    @GenerateUncached
    public static abstract class LLVMPointerOffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMPointerOffsetLoadNode create() {
            return LLVMPointerLoadNodeGen.LLVMPointerOffsetLoadNodeGen.create();
        }

        public abstract LLVMPointer executeWithTarget(LLVMPointer var1, long var2);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected LLVMNativePointer doNativePointer(LLVMNativePointer addr, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getPointer((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected LLVMPointer doDerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLanguage LLVMLanguage language, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doIndirectedForeign(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3")
        protected LLVMPointer doIndirectedForeign(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readPointer(addr.getObject(), addr.getOffset() + offset);
        }
    }
}

