/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMove;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativeProfiledMemMove.class)
public final class NativeProfiledMemMoveNodeGen
extends NativeProfiledMemMove {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
    @Node.Child
    private ManagedNonAliasingData managedNonAliasing_cache;
    @Node.Child
    private ManagedAliasingData managedAliasing_cache;
    @Node.Child
    private ManagedNativeData managedNative_cache;
    @Node.Child
    private NativeManagedData nativeManaged_cache;
    @Node.Child
    private LLVMToNativeNode inJava_convertTarget_;
    @Node.Child
    private LLVMToNativeNode inJava_convertSource_;
    @Node.Child
    private LLVMToNativeNode native_convertTarget_;
    @Node.Child
    private LLVMToNativeNode native_convertSource_;

    private NativeProfiledMemMoveNodeGen() {
    }

    @Override
    @ExplodeLoop
    public void executeWithTarget(Object arg0Value, Object arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            LLVMPointer arg1Value_;
            LLVMPointer arg0Value_;
            if ((state_0 & 7) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if ((state_0 & 3) != 0 && LLVMTypes.isManagedPointer(arg1Value)) {
                    arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                    if ((state_0 & 1) != 0) {
                        ManagedNonAliasingData s1_ = this.managedNonAliasing_cache;
                        while (s1_ != null) {
                            if (s1_.helper_.guard(arg0Value_, arg1Value_) && arg0Value_.getObject() != arg1Value_.getObject()) {
                                this.doManagedNonAliasing((LLVMManagedPointer)arg0Value_, (LLVMManagedPointer)arg1Value_, arg2Value, s1_.helper_, s1_.unitSizeNode_);
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        ManagedAliasingData s2_ = this.managedAliasing_cache;
                        while (s2_ != null) {
                            if (s2_.helper_.guard(arg0Value_, arg1Value_) && arg0Value_.getObject() == arg1Value_.getObject()) {
                                this.doManagedAliasing((LLVMManagedPointer)arg0Value_, (LLVMManagedPointer)arg1Value_, arg2Value, s2_.helper_, s2_.unitSizeNode_, s2_.canCopyForward_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isNativePointer(arg1Value)) {
                    arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                    ManagedNativeData s3_ = this.managedNative_cache;
                    while (s3_ != null) {
                        if (s3_.helper_.guard(arg0Value_, arg1Value_)) {
                            this.doManagedNative((LLVMManagedPointer)arg0Value_, (LLVMNativePointer)arg1Value_, arg2Value, s3_.helper_, s3_.unitSizeNode_);
                            return;
                        }
                        s3_ = s3_.next_;
                    }
                }
            }
            if ((state_0 & 8) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if (LLVMTypes.isManagedPointer(arg1Value)) {
                    arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                    NativeManagedData s4_ = this.nativeManaged_cache;
                    while (s4_ != null) {
                        if (s4_.helper_.guard(arg0Value_, arg1Value_)) {
                            this.doNativeManaged((LLVMNativePointer)arg0Value_, (LLVMManagedPointer)arg1Value_, arg2Value, s4_.helper_, s4_.unitSizeNode_);
                            return;
                        }
                        s4_ = s4_.next_;
                    }
                }
            }
            if ((state_0 & 0x10) != 0 && LLVMTypes.isPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if (LLVMTypes.isPointer(arg1Value)) {
                    arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    if (NativeProfiledMemMove.isManaged(arg0Value_) || NativeProfiledMemMove.isManaged(arg1Value_)) {
                        this.doManagedSlowPath(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
            }
            if ((state_0 & 0x60) != 0) {
                if ((state_0 & 0x20) != 0 && arg2Value <= 256L) {
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    LLVMLanguage inJava_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                    this.doInJava(arg0Value, arg1Value, arg2Value, inJava_language__, this.inJava_convertTarget_, this.inJava_convertSource_);
                    return;
                }
                if ((state_0 & 0x40) != 0) {
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                    LLVMLanguage native_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                    this.doNative(arg0Value, arg1Value, arg2Value, native_language__, this.native_convertTarget_, this.native_convertSource_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(Object arg0Value, Object arg1Value, long arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            LLVMPointer arg1Value_;
            LLVMPointer arg0Value_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (LLVMTypes.isManagedPointer(arg1Value)) {
                    arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                    if ((exclude & 1) == 0) {
                        ManagedMemMoveHelperNode helper__;
                        int count1_ = 0;
                        ManagedNonAliasingData s1_ = this.managedNonAliasing_cache;
                        if ((state_0 & 1) != 0) {
                            while (!(s1_ == null || s1_.helper_.guard(arg0Value_, arg1Value_) && arg0Value_.getObject() != arg1Value_.getObject())) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && (helper__ = (ManagedMemMoveHelperNode)super.insert((Node)ManagedMemMoveHelperNode.create(arg0Value_, arg1Value_))).guard(arg0Value_, arg1Value_) && arg0Value_.getObject() != arg1Value_.getObject() && count1_ < 8) {
                            s1_ = (ManagedNonAliasingData)super.insert((Node)new ManagedNonAliasingData(this.managedNonAliasing_cache));
                            s1_.helper_ = s1_.insertAccessor(helper__);
                            s1_.unitSizeNode_ = s1_.insertAccessor(ManagedMemMoveHelperNodeGen.UnitSizeNodeGen.create());
                            this.managedNonAliasing_cache = s1_;
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            this.doManagedNonAliasing((LLVMManagedPointer)arg0Value_, (LLVMManagedPointer)arg1Value_, arg2Value, s1_.helper_, s1_.unitSizeNode_);
                            return;
                        }
                    }
                    if ((exclude & 2) == 0) {
                        ManagedMemMoveHelperNode helper__1;
                        int count2_ = 0;
                        ManagedAliasingData s2_ = this.managedAliasing_cache;
                        if ((state_0 & 2) != 0) {
                            while (!(s2_ == null || s2_.helper_.guard(arg0Value_, arg1Value_) && arg0Value_.getObject() == arg1Value_.getObject())) {
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null && (helper__1 = (ManagedMemMoveHelperNode)super.insert((Node)ManagedMemMoveHelperNode.create(arg0Value_, arg1Value_))).guard(arg0Value_, arg1Value_) && arg0Value_.getObject() == arg1Value_.getObject() && count2_ < 8) {
                            s2_ = (ManagedAliasingData)super.insert((Node)new ManagedAliasingData(this.managedAliasing_cache));
                            s2_.helper_ = s2_.insertAccessor(helper__1);
                            s2_.unitSizeNode_ = s2_.insertAccessor(ManagedMemMoveHelperNodeGen.UnitSizeNodeGen.create());
                            s2_.canCopyForward_ = ConditionProfile.createCountingProfile();
                            this.managedAliasing_cache = s2_;
                            this.state_0_ = state_0 |= 2;
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            this.doManagedAliasing((LLVMManagedPointer)arg0Value_, (LLVMManagedPointer)arg1Value_, arg2Value, s2_.helper_, s2_.unitSizeNode_, s2_.canCopyForward_);
                            return;
                        }
                    }
                }
                if ((exclude & 4) == 0 && LLVMTypes.isNativePointer(arg1Value)) {
                    ManagedMemMoveHelperNode helper__2;
                    arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                    int count3_ = 0;
                    ManagedNativeData s3_ = this.managedNative_cache;
                    if ((state_0 & 4) != 0) {
                        while (s3_ != null && !s3_.helper_.guard(arg0Value_, arg1Value_)) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && (helper__2 = (ManagedMemMoveHelperNode)super.insert((Node)ManagedMemMoveHelperNode.create(arg0Value_, arg1Value_))).guard(arg0Value_, arg1Value_) && count3_ < 4) {
                        s3_ = (ManagedNativeData)super.insert((Node)new ManagedNativeData(this.managedNative_cache));
                        s3_.helper_ = s3_.insertAccessor(helper__2);
                        s3_.unitSizeNode_ = s3_.insertAccessor(ManagedMemMoveHelperNodeGen.UnitSizeNodeGen.create());
                        this.managedNative_cache = s3_;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doManagedNative((LLVMManagedPointer)arg0Value_, (LLVMNativePointer)arg1Value_, arg2Value, s3_.helper_, s3_.unitSizeNode_);
                        return;
                    }
                }
            }
            if ((exclude & 8) == 0 && LLVMTypes.isNativePointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if (LLVMTypes.isManagedPointer(arg1Value)) {
                    ManagedMemMoveHelperNode helper__3;
                    arg1Value_ = LLVMTypes.asManagedPointer(arg1Value);
                    int count4_ = 0;
                    NativeManagedData s4_ = this.nativeManaged_cache;
                    if ((state_0 & 8) != 0) {
                        while (s4_ != null && !s4_.helper_.guard(arg0Value_, arg1Value_)) {
                            s4_ = s4_.next_;
                            ++count4_;
                        }
                    }
                    if (s4_ == null && (helper__3 = (ManagedMemMoveHelperNode)super.insert((Node)ManagedMemMoveHelperNode.create(arg0Value_, arg1Value_))).guard(arg0Value_, arg1Value_) && count4_ < 4) {
                        s4_ = (NativeManagedData)super.insert((Node)new NativeManagedData(this.nativeManaged_cache));
                        s4_.helper_ = s4_.insertAccessor(helper__3);
                        s4_.unitSizeNode_ = s4_.insertAccessor(ManagedMemMoveHelperNodeGen.UnitSizeNodeGen.create());
                        this.nativeManaged_cache = s4_;
                        this.state_0_ = state_0 |= 8;
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doNativeManaged((LLVMNativePointer)arg0Value_, (LLVMManagedPointer)arg1Value_, arg2Value, s4_.helper_, s4_.unitSizeNode_);
                        return;
                    }
                }
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if (LLVMTypes.isPointer(arg1Value)) {
                    arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    if (NativeProfiledMemMove.isManaged(arg0Value_) || NativeProfiledMemMove.isManaged(arg1Value_)) {
                        this.exclude_ = exclude |= 0xF;
                        this.managedNonAliasing_cache = null;
                        this.managedAliasing_cache = null;
                        this.managedNative_cache = null;
                        this.nativeManaged_cache = null;
                        state_0 &= 0xFFFFFFF0;
                        this.state_0_ = state_0 |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        this.doManagedSlowPath(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
            }
            LLVMLanguage inJava_language__ = null;
            if ((exclude & 0x10) == 0 && arg2Value <= 256L) {
                TruffleLanguage.LanguageReference lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__2 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__2 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                inJava_language__ = (LLVMLanguage)lLVMLanguageReference__2.get();
                this.inJava_convertTarget_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNodeGen.create());
                this.inJava_convertSource_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNodeGen.create());
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                this.doInJava(arg0Value, arg1Value, arg2Value, inJava_language__, this.inJava_convertTarget_, this.inJava_convertSource_);
                return;
            }
            LLVMLanguage native_language__ = null;
            TruffleLanguage.LanguageReference lLVMLanguageReference__3 = this.lLVMLanguageReference_;
            if (lLVMLanguageReference__3 == null) {
                this.lLVMLanguageReference_ = lLVMLanguageReference__3 = super.lookupLanguageReference(LLVMLanguage.class);
            }
            native_language__ = (LLVMLanguage)lLVMLanguageReference__3.get();
            this.native_convertTarget_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNodeGen.create());
            this.native_convertSource_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNodeGen.create());
            this.exclude_ = exclude |= 0x10;
            state_0 &= 0xFFFFFFDF;
            this.state_0_ = state_0 |= 0x40;
            lock.unlock();
            hasLock = false;
            this.doNative(arg0Value, arg1Value, arg2Value, native_language__, this.native_convertTarget_, this.native_convertSource_);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            ManagedNonAliasingData s1_ = this.managedNonAliasing_cache;
            ManagedAliasingData s2_ = this.managedAliasing_cache;
            ManagedNativeData s3_ = this.managedNative_cache;
            NativeManagedData s4_ = this.nativeManaged_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null || s3_ != null && s3_.next_ != null || s4_ != null && s4_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static NativeProfiledMemMove create() {
        return new NativeProfiledMemMoveNodeGen();
    }

    public static NativeProfiledMemMove getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=NativeProfiledMemMove.class)
    private static final class Uncached
    extends NativeProfiledMemMove {
        private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void executeWithTarget(Object arg0Value, Object arg1Value, long arg2Value) {
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if (LLVMTypes.isPointer(arg1Value)) {
                    LLVMPointer arg1Value_ = LLVMTypes.asPointer(arg1Value);
                    if (NativeProfiledMemMove.isManaged(arg0Value_) || NativeProfiledMemMove.isManaged(arg1Value_)) {
                        this.doManagedSlowPath(arg0Value_, arg1Value_, arg2Value);
                        return;
                    }
                }
            }
            this.doNative(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get(), LLVMToNativeNodeGen.getUncached(), LLVMToNativeNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NativeProfiledMemMove.class)
    private static final class NativeManagedData
    extends Node {
        @Node.Child
        NativeManagedData next_;
        @Node.Child
        ManagedMemMoveHelperNode helper_;
        @Node.Child
        ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode_;

        NativeManagedData(NativeManagedData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=NativeProfiledMemMove.class)
    private static final class ManagedNativeData
    extends Node {
        @Node.Child
        ManagedNativeData next_;
        @Node.Child
        ManagedMemMoveHelperNode helper_;
        @Node.Child
        ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode_;

        ManagedNativeData(ManagedNativeData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=NativeProfiledMemMove.class)
    private static final class ManagedAliasingData
    extends Node {
        @Node.Child
        ManagedAliasingData next_;
        @Node.Child
        ManagedMemMoveHelperNode helper_;
        @Node.Child
        ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile canCopyForward_;

        ManagedAliasingData(ManagedAliasingData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=NativeProfiledMemMove.class)
    private static final class ManagedNonAliasingData
    extends Node {
        @Node.Child
        ManagedNonAliasingData next_;
        @Node.Child
        ManagedMemMoveHelperNode helper_;
        @Node.Child
        ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode_;

        ManagedNonAliasingData(ManagedNonAliasingData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

