/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMRunDestructorFunctions
extends LLVMIntrinsic {
    @Node.Child
    private IndirectCallNode callNode = Truffle.getRuntime().createIndirectCallNode();

    @Specialization
    protected Object doOp(@CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
        this.runDestructorFunctions(ctx);
        return LLVMNativePointer.createNull();
    }

    @CompilerDirectives.TruffleBoundary
    private void runDestructorFunctions(LLVMContext context) {
        RootCallTarget[] targets = context.getDestructorFunctions();
        for (int i = targets.length - 1; i >= 0; --i) {
            RootCallTarget target = targets[i];
            LLVMStack stack = context.getThreadingStack().getStack();
            this.callNode.call((CallTarget)target, new Object[]{stack});
        }
    }
}

