/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.SulongStackTrace;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsicRootNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.List;

public abstract class LLVMPrintStackTrace
extends LLVMIntrinsic {
    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Object doOp() {
        SulongStackTrace trace = LLVMPrintStackTrace.getStackTrace(this, "__sulong_print_stacktrace", true);
        List<SulongStackTrace.Element> elements = trace.getTrace();
        System.err.println("C stack trace:");
        for (SulongStackTrace.Element element : elements) {
            System.err.print(element);
        }
        return LLVMNativePointer.createNull();
    }

    public static SulongStackTrace getStackTrace(LLVMNode node) {
        return LLVMPrintStackTrace.getStackTrace(node, "", false);
    }

    private static SulongStackTrace getStackTrace(LLVMNode node, String message, boolean filterCurrentLocation) {
        CThrowable t = new CThrowable(node, message);
        List ctrace = TruffleStackTrace.getStackTrace((Throwable)((Object)t));
        SulongStackTrace trace = new SulongStackTrace(message);
        for (int i = 0; i < ctrace.size(); ++i) {
            TruffleStackTraceElement element = (TruffleStackTraceElement)ctrace.get(i);
            if (filterCurrentLocation && element.getLocation() == node) {
                assert (i == 0);
                continue;
            }
            LLVMPrintStackTrace.fillStackTrace(trace, element.getLocation());
        }
        return trace;
    }

    private static void fillStackTrace(SulongStackTrace stackTrace, Node node) {
        LLVMBasicBlockNode block = (LLVMBasicBlockNode)((Object)NodeUtil.findParent((Node)node, LLVMBasicBlockNode.class));
        LLVMFunctionStartNode f = (LLVMFunctionStartNode)NodeUtil.findParent((Node)node, LLVMFunctionStartNode.class);
        if (block == null || f == null) {
            LLVMIntrinsicRootNode.LLVMIntrinsicExpressionNode intrinsic = (LLVMIntrinsicRootNode.LLVMIntrinsicExpressionNode)((Object)NodeUtil.findParent((Node)node, LLVMIntrinsicRootNode.LLVMIntrinsicExpressionNode.class));
            if (intrinsic != null) {
                stackTrace.addStackTraceElement(intrinsic.toString(), null, null);
            }
            return;
        }
        LLVMSourceLocation location = null;
        if (node instanceof LLVMInstrumentableNode) {
            location = ((LLVMInstrumentableNode)node).getSourceLocation();
        }
        if (location == null) {
            location = block.getSourceLocation();
        }
        if (location != null) {
            stackTrace.addStackTraceElement(f.getOriginalName(), location, f.getBcName(), f.getBcSource().getName(), LLVMPrintStackTrace.blockName(block));
            return;
        }
        SourceSection s = node.getSourceSection();
        if (s == null) {
            s = f.getSourceSection();
        }
        if (s == null) {
            stackTrace.addStackTraceElement(f.getBcName(), f.getBcSource().getName(), LLVMPrintStackTrace.blockName(block));
        } else {
            location = LLVMSourceLocation.createUnknown(s);
            stackTrace.addStackTraceElement(f.getOriginalName(), location, f.getBcName(), f.getBcSource().getName(), LLVMPrintStackTrace.blockName(block));
        }
    }

    private static String blockName(LLVMBasicBlockNode block) {
        CompilerAsserts.neverPartOfCompilation();
        int blockId = block.getBlockId();
        String blockName = block.getBlockName();
        return String.format("id: %d name: %s", blockId, blockName == null ? "N/A" : blockName);
    }

    private static class CThrowable
    extends AbstractTruffleException {
        CThrowable(Node node, String message) {
            super(message, node);
        }
    }
}

