/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import com.oracle.truffle.llvm.runtime.pthread.PThreadExitException;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;

public final class LLVMPThreadStart {

    public static final class LLVMPThreadFunctionRootNode
    extends LLVMRootNode {
        @Node.Child
        private LLVMExpressionNode callNode;
        private final FrameSlot functionSlot;
        private final FrameSlot argSlot;
        @CompilerDirectives.CompilationFinal
        TruffleLanguage.ContextReference<LLVMContext> ctxRef;

        public static FrameDescriptor createFrameDescriptor() {
            FrameDescriptor descriptor = new FrameDescriptor();
            descriptor.addFrameSlot((Object)"function");
            descriptor.addFrameSlot((Object)"arg");
            return descriptor;
        }

        public LLVMPThreadFunctionRootNode(LLVMLanguage language, FrameDescriptor frameDescriptor, NodeFactory nodeFactory) {
            super(language, frameDescriptor, nodeFactory.createStackAccess(frameDescriptor));
            this.functionSlot = frameDescriptor.findFrameSlot((Object)"function");
            this.argSlot = frameDescriptor.findFrameSlot((Object)"arg");
            this.callNode = CommonNodeFactory.createFunctionCall(CommonNodeFactory.createFrameRead(PointerType.VOID, this.functionSlot), new LLVMExpressionNode[]{nodeFactory.createGetStackFromFrame(), CommonNodeFactory.createFrameRead(PointerType.VOID, this.argSlot)}, FunctionType.create(PointerType.VOID, PointerType.VOID, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
            }
            this.stackAccess.executeEnter(frame, ((LLVMContext)this.ctxRef.get()).getThreadingStack().getStack());
            try {
                Object[] arguments = frame.getArguments();
                Object function = arguments[0];
                Object arg = arguments[1];
                frame.setObject(this.functionSlot, function);
                frame.setObject(this.argSlot, arg);
                Object object = this.callNode.executeGeneric(frame);
                return object;
            }
            finally {
                this.stackAccess.executeExit(frame);
            }
        }
    }

    static final class LLVMPThreadRunnable
    implements Runnable {
        private boolean isThread;
        private Object startRoutine;
        private Object arg;
        private LLVMContext context;

        LLVMPThreadRunnable(Object startRoutine, Object arg, LLVMContext context, boolean isThread) {
            this.startRoutine = startRoutine;
            this.arg = arg;
            this.context = context;
            this.isThread = isThread;
        }

        @Override
        public void run() {
            LLVMPThreadContext pThreadContext = this.context.getpThreadContext();
            try {
                Object returnValue = pThreadContext.getPthreadCallTarget().call(new Object[]{this.startRoutine, this.arg});
                if (returnValue == null) {
                    returnValue = LLVMNativePointer.createNull();
                }
                pThreadContext.setThreadReturnValue(Thread.currentThread().getId(), returnValue);
            }
            catch (PThreadExitException key) {
            }
            catch (Throwable t) {
                pThreadContext.setThreadReturnValue(Thread.currentThread().getId(), LLVMNativePointer.createNull());
                throw t;
            }
            finally {
                if (this.isThread) {
                    for (int key = 1; key <= pThreadContext.getNumberOfPthreadKeys(); ++key) {
                        LLVMPointer keyMapping;
                        LLVMPointer destructor = pThreadContext.getDestructor(key);
                        if (destructor == null || destructor.isNull() || (keyMapping = pThreadContext.getAndRemoveSpecificUnlessNull(key)) == null) continue;
                        assert (!keyMapping.isNull());
                        new LLVMPThreadRunnable(destructor, keyMapping, this.context, false).run();
                    }
                    pThreadContext.clearThreadId();
                }
            }
        }
    }
}

