/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMVaListLibrary.class)
final class LLVMVaListLibraryGen
extends LibraryFactory<LLVMVaListLibrary> {
    private static final Class<LLVMVaListLibrary> LIBRARY_CLASS = LLVMVaListLibraryGen.lazyLibraryClass();
    private static final Message INITIALIZE = new MessageImpl("initialize", 0, Void.TYPE, Object.class, Object[].class, Integer.TYPE);
    private static final Message CLEANUP = new MessageImpl("cleanup", 1, Void.TYPE, Object.class);
    private static final Message COPY = new MessageImpl("copy", 2, Void.TYPE, Object.class, Object.class, Integer.TYPE);
    private static final Message SHIFT = new MessageImpl("shift", 3, Object.class, Object.class, Type.class);
    private static final LLVMVaListLibraryGen INSTANCE = new LLVMVaListLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMVaListLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(INITIALIZE, CLEANUP, COPY, SHIFT)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return LLVMVaListLibrary.class;
    }

    protected LLVMVaListLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected LLVMVaListLibrary createDelegate(LLVMVaListLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMVaListLibrary lib = (LLVMVaListLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                lib.initialize(receiver, (Object[])args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 1: {
                lib.cleanup(receiver);
                return null;
            }
            case 2: {
                lib.copy(receiver, args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 3: {
                return lib.shift(receiver, (Type)args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMVaListLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMVaListLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMVaListLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary", false, LLVMVaListLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMVaListLibrary {
        @Node.Child
        LLVMVaListLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMVaListLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.initialize(receiver_, arguments, numberOfExplicitArguments);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void cleanup(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.cleanup(receiver_);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void copy(Object receiver_, Object destVaList, int numberOfExplicitArguments) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.copy(receiver_, destVaList, numberOfExplicitArguments);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object shift(Object receiver_, Type type) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.shift(receiver_, type);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            LLVMVaListLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (LLVMVaListLibrary)this.insert((Node)INSTANCE.create(receiver_));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        LLVMVaListLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMVaListLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMVaListLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(LLVMVaListLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMVaListLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class UncachedDispatch
    extends LLVMVaListLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments) {
            ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).initialize(receiver_, arguments, numberOfExplicitArguments);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void cleanup(Object receiver_) {
            ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).cleanup(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copy(Object receiver_, Object destVaList, int numberOfExplicitArguments) {
            ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).copy(receiver_, destVaList, numberOfExplicitArguments);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object shift(Object receiver_, Type type) {
            return ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).shift(receiver_, type);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMVaListLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).initialize(receiver_, arguments, numberOfExplicitArguments);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void cleanup(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).cleanup(receiver_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void copy(Object receiver_, Object destVaList, int numberOfExplicitArguments) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).copy(receiver_, destVaList, numberOfExplicitArguments);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object shift(Object receiver_, Type type) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).shift(receiver_, type);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class Delegate
    extends LLVMVaListLibrary {
        @Node.Child
        private LLVMVaListLibrary delegateLibrary;

        Delegate(LLVMVaListLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).initialize(delegate, arguments, numberOfExplicitArguments);
                return;
            }
            this.delegateLibrary.initialize(receiver_, arguments, numberOfExplicitArguments);
        }

        @Override
        public void cleanup(Object receiver_) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).cleanup(delegate);
                return;
            }
            this.delegateLibrary.cleanup(receiver_);
        }

        @Override
        public void copy(Object receiver_, Object destVaList, int numberOfExplicitArguments) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copy(delegate, destVaList, numberOfExplicitArguments);
                return;
            }
            this.delegateLibrary.copy(receiver_, destVaList, numberOfExplicitArguments);
        }

        @Override
        public Object shift(Object receiver_, Type type) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).shift(delegate, type);
            }
            return this.delegateLibrary.shift(receiver_, type);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class Proxy
    extends LLVMVaListLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments) {
            try {
                this.lib.send(receiver_, INITIALIZE, new Object[]{arguments, numberOfExplicitArguments});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void cleanup(Object receiver_) {
            try {
                this.lib.send(receiver_, CLEANUP, new Object[0]);
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void copy(Object receiver_, Object destVaList, int numberOfExplicitArguments) {
            try {
                this.lib.send(receiver_, COPY, new Object[]{destVaList, numberOfExplicitArguments});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object shift(Object receiver_, Type type) {
            try {
                return this.lib.send(receiver_, SHIFT, new Object[]{type});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class Default
    extends LibraryExport<LLVMVaListLibrary> {
        private Default() {
            super(LLVMVaListLibrary.class, Object.class, false);
        }

        protected LLVMVaListLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMVaListLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMVaListLibrary.class)
        private static final class Uncached
        extends LLVMVaListLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void initialize(Object receiver, Object[] arguments, int numberOfExplicitArguments) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void cleanup(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copy(Object receiver, Object destVaList, int numberOfExplicitArguments) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object shift(Object receiver, Type type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=LLVMVaListLibrary.class)
        private static final class Cached
        extends LLVMVaListLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void initialize(Object receiver, Object[] arguments, int numberOfExplicitArguments) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void cleanup(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copy(Object receiver, Object destVaList, int numberOfExplicitArguments) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object shift(Object receiver, Type type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }
}

