/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToDebugValueNode.class)
public final class LLVMToDebugValueNodeGen
extends LLVMToDebugValueNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMToDebugValueNodeGen() {
    }

    @Override
    protected LLVMDebugValue executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state_0 & 2) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state_0 & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state_0 & 8) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state_0 & 0x10) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state_0 & 0x20) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x3800000) >>> 23, arg0Value)) {
            LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x3800000) >>> 23, arg0Value);
            return this.fromIVarBit(arg0Value_);
        }
        if ((state_0 & 0x40) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            return this.fromNativePointer(arg0Value_);
        }
        if ((state_0 & 0x80) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            return this.fromManagedPointer(arg0Value_);
        }
        if ((state_0 & 0x100) != 0 && arg0Value instanceof LLVMFunctionDescriptor) {
            LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
            return this.fromFunctionHandle(arg0Value_);
        }
        if ((state_0 & 0x200) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state_0 & 0x400) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state_0 & 0x800) != 0 && arg0Value instanceof LLVM80BitFloat) {
            LLVM80BitFloat arg0Value_ = (LLVM80BitFloat)arg0Value;
            return this.from80BitFloat(arg0Value_);
        }
        if ((state_0 & 0x1000) != 0 && arg0Value instanceof LLVMI1Vector) {
            LLVMI1Vector arg0Value_ = (LLVMI1Vector)arg0Value;
            return this.fromI1Vector(arg0Value_);
        }
        if ((state_0 & 0x2000) != 0 && arg0Value instanceof LLVMI8Vector) {
            LLVMI8Vector arg0Value_ = (LLVMI8Vector)arg0Value;
            return this.fromI8Vector(arg0Value_);
        }
        if ((state_0 & 0x4000) != 0 && arg0Value instanceof LLVMI16Vector) {
            LLVMI16Vector arg0Value_ = (LLVMI16Vector)arg0Value;
            return this.fromI16Vector(arg0Value_);
        }
        if ((state_0 & 0x8000) != 0 && arg0Value instanceof LLVMI32Vector) {
            LLVMI32Vector arg0Value_ = (LLVMI32Vector)arg0Value;
            return this.fromI32Vector(arg0Value_);
        }
        if ((state_0 & 0x10000) != 0 && arg0Value instanceof LLVMI64Vector) {
            LLVMI64Vector arg0Value_ = (LLVMI64Vector)arg0Value;
            return this.fromI64Vector(arg0Value_);
        }
        if ((state_0 & 0x20000) != 0 && arg0Value instanceof LLVMFloatVector) {
            LLVMFloatVector arg0Value_ = (LLVMFloatVector)arg0Value;
            return this.fromFloatVector(arg0Value_);
        }
        if ((state_0 & 0x40000) != 0 && arg0Value instanceof LLVMDoubleVector) {
            LLVMDoubleVector arg0Value_ = (LLVMDoubleVector)arg0Value;
            return this.fromDoubleVector(arg0Value_);
        }
        if ((state_0 & 0x80000) != 0 && arg0Value instanceof LLVMPointerVector) {
            LLVMPointerVector arg0Value_ = (LLVMPointerVector)arg0Value;
            return this.fromAddressVector(arg0Value_);
        }
        if ((state_0 & 0x100000) != 0 && arg0Value instanceof LLVMGlobalContainer) {
            LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer)arg0Value;
            return this.fromGlobalContainer(arg0Value_);
        }
        if ((state_0 & 0x200000) != 0 && arg0Value instanceof LLVMDebugGlobalVariable) {
            LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
            LLVMContext fromGlobal_context__ = (LLVMContext)lLVMLanguageContextReference__.get();
            return this.fromGlobal(arg0Value_, fromGlobal_context__);
        }
        if ((state_0 & 0x400000) != 0 && LLVMToDebugValueNodeGen.fallbackGuard_(state_0, arg0Value)) {
            return this.fromGenericObject(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMDebugValue executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromBoolean(arg0Value_);
                return lLVMDebugValue;
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromByte(arg0Value_);
                return lLVMDebugValue;
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromShort(arg0Value_);
                return lLVMDebugValue;
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromInt(arg0Value_);
                return lLVMDebugValue;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromLong(arg0Value_);
                return lLVMDebugValue;
            }
            int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(arg0Value);
            if (lLVMIVarBitCast0 != 0) {
                LLVMIVarBit arg0Value_2 = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, arg0Value);
                state_0 |= lLVMIVarBitCast0 << 23;
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromIVarBit(arg0Value_2);
                return lLVMDebugValue;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromNativePointer(arg0Value_);
                return arg0Value_2;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromManagedPointer(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromFunctionHandle(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_0_ = state_0 |= 0x200;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromFloat(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                this.state_0_ = state_0 |= 0x400;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromDouble(arg0Value_);
                return lLVMDebugValue;
            }
            if (arg0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat arg0Value_ = (LLVM80BitFloat)arg0Value;
                this.state_0_ = state_0 |= 0x800;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.from80BitFloat(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMI1Vector) {
                LLVMI1Vector arg0Value_ = (LLVMI1Vector)arg0Value;
                this.state_0_ = state_0 |= 0x1000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromI1Vector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMI8Vector) {
                LLVMI8Vector arg0Value_ = (LLVMI8Vector)arg0Value;
                this.state_0_ = state_0 |= 0x2000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromI8Vector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMI16Vector) {
                LLVMI16Vector arg0Value_ = (LLVMI16Vector)arg0Value;
                this.state_0_ = state_0 |= 0x4000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromI16Vector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMI32Vector) {
                LLVMI32Vector arg0Value_ = (LLVMI32Vector)arg0Value;
                this.state_0_ = state_0 |= 0x8000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromI32Vector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMI64Vector) {
                LLVMI64Vector arg0Value_ = (LLVMI64Vector)arg0Value;
                this.state_0_ = state_0 |= 0x10000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromI64Vector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMFloatVector) {
                LLVMFloatVector arg0Value_ = (LLVMFloatVector)arg0Value;
                this.state_0_ = state_0 |= 0x20000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromFloatVector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector arg0Value_ = (LLVMDoubleVector)arg0Value;
                this.state_0_ = state_0 |= 0x40000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromDoubleVector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMPointerVector) {
                LLVMPointerVector arg0Value_ = (LLVMPointerVector)arg0Value;
                this.state_0_ = state_0 |= 0x80000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromAddressVector(arg0Value_);
                return arg0Value_2;
            }
            if (arg0Value instanceof LLVMGlobalContainer) {
                LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer)arg0Value;
                this.state_0_ = state_0 |= 0x100000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue arg0Value_2 = this.fromGlobalContainer(arg0Value_);
                return arg0Value_2;
            }
            LLVMContext fromGlobal_context__ = null;
            if (arg0Value instanceof LLVMDebugGlobalVariable) {
                LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__1 == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__1 = super.lookupContextReference(LLVMLanguage.class);
                }
                fromGlobal_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                this.state_0_ = state_0 |= 0x200000;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue = this.fromGlobal(arg0Value_, fromGlobal_context__);
                return lLVMDebugValue;
            }
            this.state_0_ = state_0 |= 0x400000;
            lock.unlock();
            hasLock = false;
            LLVMDebugValue lLVMDebugValue = this.fromGenericObject(arg0Value);
            return lLVMDebugValue;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x7FFFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x7FFFFF & (state_0 & 0x7FFFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state_0, Object arg0Value) {
        if ((state_0 & 1) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if ((state_0 & 2) == 0 && arg0Value instanceof Byte) {
            return false;
        }
        if ((state_0 & 4) == 0 && arg0Value instanceof Short) {
            return false;
        }
        if ((state_0 & 8) == 0 && arg0Value instanceof Integer) {
            return false;
        }
        if ((state_0 & 0x10) == 0 && arg0Value instanceof Long) {
            return false;
        }
        if (LLVMTypesGen.isImplicitLLVMIVarBit(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x40) == 0 && LLVMTypes.isNativePointer(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x80) == 0 && LLVMTypes.isManagedPointer(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x100) == 0 && arg0Value instanceof LLVMFunctionDescriptor) {
            return false;
        }
        if ((state_0 & 0x200) == 0 && arg0Value instanceof Float) {
            return false;
        }
        if ((state_0 & 0x400) == 0 && arg0Value instanceof Double) {
            return false;
        }
        if ((state_0 & 0x800) == 0 && arg0Value instanceof LLVM80BitFloat) {
            return false;
        }
        if ((state_0 & 0x1000) == 0 && arg0Value instanceof LLVMI1Vector) {
            return false;
        }
        if ((state_0 & 0x2000) == 0 && arg0Value instanceof LLVMI8Vector) {
            return false;
        }
        if ((state_0 & 0x4000) == 0 && arg0Value instanceof LLVMI16Vector) {
            return false;
        }
        if ((state_0 & 0x8000) == 0 && arg0Value instanceof LLVMI32Vector) {
            return false;
        }
        if ((state_0 & 0x10000) == 0 && arg0Value instanceof LLVMI64Vector) {
            return false;
        }
        if ((state_0 & 0x20000) == 0 && arg0Value instanceof LLVMFloatVector) {
            return false;
        }
        if ((state_0 & 0x40000) == 0 && arg0Value instanceof LLVMDoubleVector) {
            return false;
        }
        if ((state_0 & 0x80000) == 0 && arg0Value instanceof LLVMPointerVector) {
            return false;
        }
        if ((state_0 & 0x100000) == 0 && arg0Value instanceof LLVMGlobalContainer) {
            return false;
        }
        return (state_0 & 0x200000) != 0 || !(arg0Value instanceof LLVMDebugGlobalVariable);
    }

    public static LLVMToDebugValueNode create() {
        return new LLVMToDebugValueNodeGen();
    }

    public static LLVMToDebugValueNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMToDebugValueNode.class)
    private static final class Uncached
    extends LLVMToDebugValueNode {
        private final TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_ = this.lookupContextReference(LLVMLanguage.class);

        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected LLVMDebugValue executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return this.fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return this.fromByte(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                return this.fromShort(arg0Value_);
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return this.fromInt(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return this.fromLong(arg0Value_);
            }
            if (LLVMTypesGen.isImplicitLLVMIVarBit(arg0Value)) {
                LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit(arg0Value);
                return this.fromIVarBit(arg0Value_);
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                return this.fromNativePointer(arg0Value_);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.fromManagedPointer(arg0Value_);
            }
            if (arg0Value instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
                return this.fromFunctionHandle(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                return this.fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                return this.fromDouble(arg0Value_);
            }
            if (arg0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat arg0Value_ = (LLVM80BitFloat)arg0Value;
                return this.from80BitFloat(arg0Value_);
            }
            if (arg0Value instanceof LLVMI1Vector) {
                LLVMI1Vector arg0Value_ = (LLVMI1Vector)arg0Value;
                return this.fromI1Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI8Vector) {
                LLVMI8Vector arg0Value_ = (LLVMI8Vector)arg0Value;
                return this.fromI8Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI16Vector) {
                LLVMI16Vector arg0Value_ = (LLVMI16Vector)arg0Value;
                return this.fromI16Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI32Vector) {
                LLVMI32Vector arg0Value_ = (LLVMI32Vector)arg0Value;
                return this.fromI32Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI64Vector) {
                LLVMI64Vector arg0Value_ = (LLVMI64Vector)arg0Value;
                return this.fromI64Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMFloatVector) {
                LLVMFloatVector arg0Value_ = (LLVMFloatVector)arg0Value;
                return this.fromFloatVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector arg0Value_ = (LLVMDoubleVector)arg0Value;
                return this.fromDoubleVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMPointerVector) {
                LLVMPointerVector arg0Value_ = (LLVMPointerVector)arg0Value;
                return this.fromAddressVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMGlobalContainer) {
                LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer)arg0Value;
                return this.fromGlobalContainer(arg0Value_);
            }
            if (arg0Value instanceof LLVMDebugGlobalVariable) {
                LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
                return this.fromGlobal(arg0Value_, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }
            return this.fromGenericObject(arg0Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

