/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class LLVMComplex80BitFloatMul
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode aNode;
    @Node.Child
    private LLVMExpressionNode bNode;
    @Node.Child
    private LLVMExpressionNode cNode;
    @Node.Child
    private LLVMExpressionNode dNode;
    @Node.Child
    private LLVMExpressionNode alloc;
    @Node.Child
    private LLVM80BitFloatStoreNode store;

    public LLVMComplex80BitFloatMul(LLVMExpressionNode alloc, LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        this.alloc = alloc;
        this.aNode = a;
        this.bNode = b;
        this.cNode = c;
        this.dNode = d;
        this.store = LLVM80BitFloatStoreNode.create();
    }

    int getSizeInBytes() {
        try {
            long value = this.getDataLayout().getSize(PrimitiveType.X86_FP80);
            assert ((long)((int)value) == value) : "Size of X86_F80 does not fit into an int?";
            return (int)value;
        }
        catch (Type.TypeOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Specialization
    public Object doMul(VirtualFrame frame, @Cached(value="getSizeInBytes()") int sizeInBytes) {
        try {
            LLVM80BitFloat longDoubleA = (LLVM80BitFloat)this.aNode.executeGeneric(frame);
            LLVM80BitFloat longDoubleB = (LLVM80BitFloat)this.bNode.executeGeneric(frame);
            LLVM80BitFloat longDoubleC = (LLVM80BitFloat)this.cNode.executeGeneric(frame);
            LLVM80BitFloat longDoubleD = (LLVM80BitFloat)this.dNode.executeGeneric(frame);
            double a = longDoubleA.getDoubleValue();
            double b = longDoubleB.getDoubleValue();
            double c = longDoubleC.getDoubleValue();
            double d = longDoubleD.getDoubleValue();
            double ac = a * c;
            double bd = b * d;
            double ad = a * d;
            double bc = b * c;
            double zReal = ac - bd;
            double zImag = ad + bc;
            LLVMPointer allocatedMemory = this.alloc.executeLLVMPointer(frame);
            this.store.executeWithTarget(allocatedMemory, LLVM80BitFloat.fromDouble(zReal));
            this.store.executeWithTarget(allocatedMemory.increment(sizeInBytes), LLVM80BitFloat.fromDouble(zImag));
            return allocatedMemory;
        }
        catch (UnexpectedResultException | ClassCastException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }
}

