/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemCopy;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMMemCopy.class)
public final class LLVMMemCopyNodeGen
extends LLVMMemCopy {
    @Node.Child
    private LLVMExpressionNode destination_;
    @Node.Child
    private LLVMExpressionNode source_;
    @Node.Child
    private LLVMExpressionNode length_;
    @Node.Child
    private LLVMExpressionNode isVolatile_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMMemCopyNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode destination, LLVMExpressionNode source, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        super(memMove);
        this.destination_ = destination;
        this.source_ = source;
        this.length_ = length;
        this.isVolatile_ = isVolatile;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object destinationValue_ = this.destination_.executeGeneric(frameValue);
        Object sourceValue_ = this.source_.executeGeneric(frameValue);
        if ((state_0 & 2) == 0 && state_0 != 0) {
            return this.executeGeneric_int_boolean0(state_0, frameValue, destinationValue_, sourceValue_);
        }
        if ((state_0 & 1) == 0 && state_0 != 0) {
            return this.executeGeneric_long_boolean1(state_0, frameValue, destinationValue_, sourceValue_);
        }
        return this.executeGeneric_generic2(state_0, frameValue, destinationValue_, sourceValue_);
    }

    private Object executeGeneric_int_boolean0(int state_0, VirtualFrame frameValue, Object destinationValue_, Object sourceValue_) {
        boolean isVolatileValue_;
        int lengthValue_;
        try {
            lengthValue_ = this.length_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return this.executeAndSpecialize(destinationValue_, sourceValue_, ex.getResult(), isVolatileValue);
        }
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(destinationValue_, sourceValue_, lengthValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        if (LLVMTypes.isPointer(destinationValue_)) {
            LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
            if (LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                return this.doVoid(destinationValue__, sourceValue__, lengthValue_, isVolatileValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_long_boolean1(int state_0, VirtualFrame frameValue, Object destinationValue_, Object sourceValue_) {
        boolean isVolatileValue_;
        long lengthValue_;
        try {
            lengthValue_ = this.length_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return this.executeAndSpecialize(destinationValue_, sourceValue_, ex.getResult(), isVolatileValue);
        }
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(destinationValue_, sourceValue_, lengthValue_, ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        if (LLVMTypes.isPointer(destinationValue_)) {
            LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
            if (LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                return this.doVoid(destinationValue__, sourceValue__, lengthValue_, isVolatileValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_generic2(int state_0, VirtualFrame frameValue, Object destinationValue_, Object sourceValue_) {
        boolean isVolatileValue_;
        Object lengthValue_ = this.length_.executeGeneric(frameValue);
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(destinationValue_, sourceValue_, lengthValue_, ex.getResult());
        }
        if (state_0 != 0 && LLVMTypes.isPointer(destinationValue_)) {
            LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
            if (LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                if ((state_0 & 1) != 0 && lengthValue_ instanceof Integer) {
                    int lengthValue__ = (Integer)lengthValue_;
                    return this.doVoid(destinationValue__, sourceValue__, lengthValue__, isVolatileValue_);
                }
                if ((state_0 & 2) != 0 && lengthValue_ instanceof Long) {
                    long lengthValue__ = (Long)lengthValue_;
                    return this.doVoid(destinationValue__, sourceValue__, lengthValue__, isVolatileValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeAndSpecialize(Object destinationValue, Object sourceValue, Object lengthValue, Object isVolatileValue) {
        int state_0 = this.state_0_;
        if (LLVMTypes.isPointer(destinationValue)) {
            LLVMPointer destinationValue_ = LLVMTypes.asPointer(destinationValue);
            if (LLVMTypes.isPointer(sourceValue)) {
                LLVMPointer sourceValue_ = LLVMTypes.asPointer(sourceValue);
                if (isVolatileValue instanceof Boolean) {
                    boolean isVolatileValue_ = (Boolean)isVolatileValue;
                    if (lengthValue instanceof Integer) {
                        int lengthValue_ = (Integer)lengthValue;
                        this.state_0_ = state_0 |= 1;
                        return this.doVoid(destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
                    }
                    if (lengthValue instanceof Long) {
                        long lengthValue_ = (Long)lengthValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doVoid(destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.destination_, this.source_, this.length_, this.isVolatile_}, new Object[]{destinationValue, sourceValue, lengthValue, isVolatileValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMMemCopy create(LLVMMemMoveNode memMove, LLVMExpressionNode destination, LLVMExpressionNode source, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        return new LLVMMemCopyNodeGen(memMove, destination, source, length, isVolatile);
    }
}

