/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

public final class LLVMPolyglotRemove {

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPolyglotRemoveArrayElement
    extends LLVMIntrinsic {
        @Specialization
        protected boolean doRemove(LLVMManagedPointer value, int idx, @Cached LLVMAsForeignNode asForeign, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile notFound, @Cached BranchProfile exception) {
            Object foreign = asForeign.execute(value);
            try {
                interop.removeArrayElement(foreign, (long)idx);
                return true;
            }
            catch (InvalidArrayIndexException ex) {
                notFound.enter();
                return false;
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Cannot remove index %d from polyglot value.", idx);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        public boolean fallback(Object value, Object id) {
            throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMPolyglotRemoveMember
    extends LLVMIntrinsic {
        @Specialization
        protected boolean doRemove(LLVMManagedPointer value, Object id, @Cached LLVMAsForeignNode asForeign, @Cached LLVMReadStringNode readStr, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile notFound, @Cached BranchProfile exception) {
            Object foreign = asForeign.execute(value);
            try {
                interop.removeMember(foreign, readStr.executeWithTarget(id));
                return true;
            }
            catch (UnknownIdentifierException ex) {
                notFound.enter();
                return false;
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Cannot remove member '%s' from polyglot value.", id);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        public boolean error(Object value, Object id) {
            throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
        }
    }
}

