/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChild(value="object", type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotNewInstance
extends LLVMIntrinsic {
    @Node.Children
    private final LLVMExpressionNode[] args;
    @Node.Children
    private final LLVMDataEscapeNode[] prepareValuesForEscape;
    @Node.Child
    private InteropLibrary foreignNewInstance;
    @Node.Child
    private LLVMAsForeignNode asForeign = LLVMAsForeignNode.create();

    public LLVMPolyglotNewInstance(LLVMExpressionNode[] args, Type[] argTypes) {
        this.args = args;
        this.prepareValuesForEscape = new LLVMDataEscapeNode[args.length];
        for (int i = 0; i < this.prepareValuesForEscape.length; ++i) {
            this.prepareValuesForEscape[i] = LLVMDataEscapeNode.create(argTypes[i]);
        }
        this.foreignNewInstance = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
    }

    @Specialization
    @ExplodeLoop
    protected Object doNew(VirtualFrame frame, LLVMManagedPointer value, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM) {
        Object foreign = this.asForeign.execute(value);
        Object[] evaluatedArgs = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            evaluatedArgs[i] = this.prepareValuesForEscape[i].executeWithTarget(this.args[i].executeGeneric(frame));
        }
        try {
            Object rawValue = this.foreignNewInstance.instantiate(foreign, evaluatedArgs);
            return toLLVM.executeWithTarget(rawValue);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMPolyglotException(this, "Polyglot value cannot be instantiated.");
        }
        catch (UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMPolyglotException(this, "Wrong argument type passed to polyglot_new_instance.");
        }
        catch (ArityException e) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMPolyglotException((Node)this, "Wrong number of arguments passed to polyglot_new_instance, expected %d but got %d.", e.getExpectedArity(), e.getActualArity());
        }
    }

    @Fallback
    public Object fallback(Object value) {
        CompilerDirectives.transferToInterpreter();
        throw new LLVMPolyglotException(this, "Non-polyglot value passed to polyglot_new_instance.");
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.POINTER);
    }
}

