/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMPolyglotInvoke
extends LLVMIntrinsic {
    @Node.Children
    private final LLVMExpressionNode[] args;
    @Node.Children
    private final LLVMDataEscapeNode[] prepareValuesForEscape;
    @Node.Child
    private InteropLibrary foreignInvoke;
    @Node.Child
    private ForeignToLLVM toLLVM;
    @Node.Child
    private LLVMAsForeignNode asForeign = LLVMAsForeignNode.create();
    @CompilerDirectives.CompilationFinal
    private LLVMThreadingStack threadingStack = null;

    public LLVMPolyglotInvoke(ForeignToLLVM toLLVM, LLVMExpressionNode[] args, Type[] argTypes) {
        this.toLLVM = toLLVM;
        this.args = args;
        this.prepareValuesForEscape = new LLVMDataEscapeNode[args.length];
        for (int i = 0; i < this.prepareValuesForEscape.length; ++i) {
            this.prepareValuesForEscape[i] = LLVMDataEscapeNode.create(argTypes[i]);
        }
        this.foreignInvoke = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
    }

    @ExplodeLoop
    private Object doInvoke(VirtualFrame frame, Object value, String id) {
        Object[] evaluatedArgs = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            evaluatedArgs[i] = this.prepareValuesForEscape[i].executeWithTarget(this.args[i].executeGeneric(frame));
        }
        try {
            Object rawValue = this.foreignInvoke.invokeMember(value, id, evaluatedArgs);
            return this.toLLVM.executeWithTarget(rawValue);
        }
        catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }

    @Specialization
    protected Object doIntrinsic(VirtualFrame frame, LLVMManagedPointer value, Object id, @Cached(value="createReadString()") LLVMReadStringNode readStr) {
        Object foreign = this.asForeign.execute(value);
        return this.doInvoke(frame, foreign, readStr.executeWithTarget(id));
    }

    @Fallback
    public Object fallback(Object object, Object name) {
        throw new LLVMPolyglotException(this, "Invalid argument to polyglot builtin.");
    }
}

