/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotHasMember;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotHasMember.class)
public final class LLVMPolyglotHasMemberNodeGen
extends LLVMPolyglotHasMember {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private LLVMExpressionNode object_;
    @Node.Child
    private LLVMExpressionNode name_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private HasMemberData hasMember_cache;

    private LLVMPolyglotHasMemberNodeGen(LLVMExpressionNode object, LLVMExpressionNode name) {
        this.object_ = object;
        this.name_ = name;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        Object nameValue_ = this.name_.executeGeneric(frameValue);
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(objectValue_)) {
                LLVMManagedPointer objectValue__ = LLVMTypes.asManagedPointer(objectValue_);
                HasMemberData s1_ = this.hasMember_cache;
                if (s1_ != null) {
                    return this.doHasMember(objectValue__, nameValue_, s1_.asForeign_, s1_.readString_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMPolyglotHasMemberNodeGen.fallbackGuard_(state_0, objectValue_, nameValue_)) {
                return this.fallback(objectValue_, nameValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(objectValue_, nameValue_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            return LLVMTypesGen.expectBoolean(this.executeGeneric(frameValue));
        }
        Object objectValue_ = this.object_.executeGeneric(frameValue);
        Object nameValue_ = this.name_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(objectValue_)) {
            LLVMManagedPointer objectValue__ = LLVMTypes.asManagedPointer(objectValue_);
            HasMemberData s1_ = this.hasMember_cache;
            if (s1_ != null) {
                return this.doHasMember(objectValue__, nameValue_, s1_.asForeign_, s1_.readString_, s1_.interop_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectBoolean(this.executeAndSpecialize(objectValue_, nameValue_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object objectValue, Object nameValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (LLVMTypes.isManagedPointer(objectValue)) {
                LLVMManagedPointer objectValue_ = LLVMTypes.asManagedPointer(objectValue);
                HasMemberData s1_ = (HasMemberData)super.insert((Node)new HasMemberData());
                s1_.asForeign_ = s1_.insertAccessor(LLVMAsForeignNode.create());
                s1_.readString_ = s1_.insertAccessor(LLVMReadStringNodeGen.create());
                s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                this.hasMember_cache = s1_;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Boolean bl = this.doHasMember(objectValue_, nameValue, s1_.asForeign_, s1_.readString_, s1_.interop_);
                return bl;
            }
            this.state_0_ = state_0 |= 2;
            lock.unlock();
            hasLock = false;
            Object object = this.fallback(objectValue, nameValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state_0, Object objectValue, Object nameValue) {
        return (state_0 & 1) != 0 || !LLVMTypes.isManagedPointer(objectValue);
    }

    public static LLVMPolyglotHasMember create(LLVMExpressionNode object, LLVMExpressionNode name) {
        return new LLVMPolyglotHasMemberNodeGen(object, name);
    }

    @GeneratedBy(value=LLVMPolyglotHasMember.class)
    private static final class HasMemberData
    extends Node {
        @Node.Child
        LLVMAsForeignNode asForeign_;
        @Node.Child
        LLVMReadStringNode readString_;
        @Node.Child
        InteropLibrary interop_;

        HasMemberData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

