/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotEvalNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import java.io.IOException;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMPolyglotEval
extends LLVMIntrinsic {
    @Node.Child
    GetSourceNode getSource;

    public static LLVMPolyglotEval create(LLVMExpressionNode id, LLVMExpressionNode code) {
        return LLVMPolyglotEvalNodeGen.create(LLVMPolyglotEvalNodeGen.GetSourceStringNodeGen.create(), id, code);
    }

    public static LLVMPolyglotEval createFile(LLVMExpressionNode id, LLVMExpressionNode filename) {
        return LLVMPolyglotEvalNodeGen.create(LLVMPolyglotEvalNodeGen.GetSourceFileNodeGen.create(), id, filename);
    }

    LLVMPolyglotEval(GetSourceNode getSource) {
        this.getSource = getSource;
    }

    @Specialization
    protected Object doEval(Object idPointer, Object srcPointer, @Cached(value="createReadString()") LLVMReadStringNode readId, @Cached(value="createReadString()") LLVMReadStringNode readSrc, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM) {
        try {
            CallTarget callTarget = this.getSource.execute(readId.executeWithTarget(idPointer), readSrc.executeWithTarget(srcPointer));
            Object foreign = callTarget.call(new Object[0]);
            return toLLVM.executeWithTarget(foreign);
        }
        catch (IllegalStateException e) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMPolyglotException(this, e.getMessage());
        }
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.POINTER);
    }

    static abstract class GetSourceFileNode
    extends GetSourceNode {
        GetSourceFileNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        CallTarget uncached(String id, String filename, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
            try {
                TruffleLanguage.Env env = ctx.getEnv();
                Source sourceObject = Source.newBuilder((String)id, (TruffleFile)env.getPublicTruffleFile(filename)).build();
                return env.parsePublic(sourceObject, new String[0]);
            }
            catch (IOException ex) {
                throw new LLVMPolyglotException((Node)this, "Could not parse file %s (%s).", filename, ex.getMessage());
            }
        }
    }

    static abstract class GetSourceStringNode
    extends GetSourceNode {
        GetSourceStringNode() {
        }

        @Specialization(limit="2", guards={"id.equals(cachedId)", "code.equals(cachedCode)"}, assumptions={"singleContextAssumption()"})
        CallTarget doCached(String id, String code, @Cached(value="id") String cachedId, @Cached(value="code") String cachedCode, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="uncached(cachedId, cachedCode, ctxRef)") CallTarget callTarget) {
            return callTarget;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCached"})
        CallTarget uncached(String id, String code, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
            LLVMContext ctx = (LLVMContext)ctxRef.get();
            TruffleLanguage.Env env = ctx.getEnv();
            LanguageInfo lang = (LanguageInfo)env.getPublicLanguages().get(id);
            if (lang == null) {
                throw new LLVMPolyglotException((Node)this, "Language '%s' not found.", id);
            }
            Source sourceObject = Source.newBuilder((String)id, (CharSequence)code, (String)"<eval>").build();
            return ctx.getEnv().parsePublic(sourceObject, new String[0]);
        }
    }

    static abstract class GetSourceNode
    extends LLVMNode {
        GetSourceNode() {
        }

        abstract CallTarget execute(String var1, String var2);
    }
}

