/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLandingpadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMLandingpadNode.LandingpadEntryNode.class)
final class LandingpadEntryNodeWrapper
extends LLVMLandingpadNode.LandingpadEntryNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LLVMLandingpadNode.LandingpadEntryNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    LandingpadEntryNodeWrapper(LLVMLandingpadNode.LandingpadEntryNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LLVMLandingpadNode.LandingpadEntryNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public int execute(VirtualFrame frame, LLVMStack stack, LLVMPointer unwindHeader) {
        int returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame, stack, unwindHeader);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, (Object)returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = (Integer)result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }
}

