/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMNativePointerException;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeCallUtils;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public abstract class LLVMNativeDispatchNode
extends LLVMNode {
    private final FunctionType type;
    private final Source signatureSource;
    @CompilerDirectives.CompilationFinal
    private ContextExtension.Key<NativeContextExtension> nativeCtxExtKey;

    protected LLVMNativeDispatchNode(FunctionType type, Source signatureSource) {
        this.type = type;
        this.signatureSource = signatureSource;
    }

    public abstract Object executeDispatch(Object var1, Object[] var2);

    NativeContextExtension getNativeCtxExt(TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        if (this.nativeCtxExtKey == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCtxExtKey = ((LLVMContext)ctxRef.get()).getLanguage().lookupContextExtension(NativeContextExtension.class);
        }
        return this.nativeCtxExtKey.get((LLVMContext)ctxRef.get());
    }

    @CompilerDirectives.TruffleBoundary
    protected Object bindSignature(NativeContextExtension ctxExt, long pointer) {
        return ctxExt.bindSignature(pointer, this.signatureSource);
    }

    @ExplodeLoop
    protected LLVMNativeConvertNode[] createToNativeNodes() {
        LLVMNativeConvertNode[] ret = new LLVMNativeConvertNode[this.type.getNumberOfArguments() - 1];
        for (int i = 1; i < this.type.getNumberOfArguments(); ++i) {
            ret[i - 1] = LLVMNativeConvertNode.createToNative(this.type.getArgumentType(i));
        }
        return ret;
    }

    protected LLVMNativeConvertNode createFromNativeNode() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMNativeConvertNode.createFromNative(this.type.getReturnType());
    }

    @ExplodeLoop
    private static Object[] prepareNativeArguments(Object[] arguments, LLVMNativeConvertNode[] toNative) {
        Object[] nativeArgs = new Object[arguments.length - 1];
        for (int i = 1; i < arguments.length; ++i) {
            nativeArgs[i - 1] = toNative[i - 1].executeConvert(arguments[i]);
        }
        return nativeArgs;
    }

    @Specialization(guards={"function.asNative() == cachedFunction.asNative()", "!cachedFunction.isNull()"}, assumptions={"singleContextAssumption()"})
    protected Object doCached(LLVMNativePointer function, Object[] arguments, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached(value="function") LLVMNativePointer cachedFunction, @Cached(value="bindSignature(getNativeCtxExt(context), cachedFunction.asNative())") Object nativeFunctionHandle, @CachedLibrary(value="nativeFunctionHandle") InteropLibrary nativeCall, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object[] nativeArgs = LLVMNativeDispatchNode.prepareNativeArguments(arguments, toNative);
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, nativeFunctionHandle, nativeArgs, null);
        return fromNative.executeConvert(returnValue);
    }

    @Specialization(replaces={"doCached"}, guards={"!function.isNull()"})
    protected Object doGeneric(LLVMNativePointer function, Object[] arguments, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @CachedLibrary(limit="5") InteropLibrary nativeCall, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object[] nativeArgs = LLVMNativeDispatchNode.prepareNativeArguments(arguments, toNative);
        Object bound = this.bindSignature(this.getNativeCtxExt(context), function.asNative());
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, bound, nativeArgs, null);
        return fromNative.executeConvert(returnValue);
    }

    @Specialization(guards={"function.isNull()"})
    protected Object doNull(LLVMNativePointer function, Object[] arguments) {
        throw new LLVMNativePointerException(this, "Invalid native function pointer", null);
    }
}

