/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import java.util.StringJoiner;

public final class LLVMNativeCallUtils {
    static Object bindNativeSymbol(InteropLibrary interop, Object symbol, String signature) {
        try {
            return interop.invokeMember(symbol, "bind", new Object[]{signature});
        }
        catch (InteropException ex) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Could not bind " + symbol + " " + signature, ex);
        }
    }

    static Object callNativeFunction(boolean enabled, TruffleLanguage.ContextReference<LLVMContext> context, InteropLibrary nativeCall, Object function, Object[] nativeArgs, LLVMFunctionDescriptor descriptor) {
        CompilerAsserts.partialEvaluationConstant((boolean)enabled);
        if (enabled && descriptor != null) {
            LLVMNativeCallUtils.traceNativeCall((LLVMContext)context.get(), descriptor);
        }
        try {
            return nativeCall.execute(function, nativeArgs);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Exception thrown by a callback during the native call " + function + LLVMNativeCallUtils.argsToString(nativeArgs), e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String argsToString(Object[] nativeArgs) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Object arg : nativeArgs) {
            joiner.add(arg.toString());
        }
        return joiner.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static void traceNativeCall(LLVMContext context, LLVMFunctionDescriptor descriptor) {
        context.registerNativeCall(descriptor);
    }
}

