/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMNativePointerException;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeCallUtils;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMNativeDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

public abstract class LLVMDispatchNode
extends LLVMNode {
    protected static final int INLINE_CACHE_SIZE = 5;
    protected final FunctionType type;
    @CompilerDirectives.CompilationFinal
    private Source signatureSource;
    @CompilerDirectives.CompilationFinal
    private ContextExtension.Key<NativeContextExtension> nativeCtxExtKey;

    protected LLVMDispatchNode(FunctionType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return this.getShortString("type", "signature");
    }

    boolean haveNativeCtxExt() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMLanguage.getLanguage().lookupContextExtension(NativeContextExtension.class) != null;
    }

    NativeContextExtension getNativeCtxExt(TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        if (this.nativeCtxExtKey == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCtxExtKey = ((LLVMContext)ctxRef.get()).getLanguage().lookupContextExtension(NativeContextExtension.class);
        }
        return this.nativeCtxExtKey.get((LLVMContext)ctxRef.get());
    }

    private Source getSignatureSource(TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        if (this.signatureSource == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            try {
                this.signatureSource = this.getNativeCtxExt(ctxRef).getNativeSignatureSourceSkipStackArg(this.type);
            }
            catch (NativeContextExtension.UnsupportedNativeTypeException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)ex);
            }
        }
        return this.signatureSource;
    }

    public abstract Object executeDispatch(Object var1, Object[] var2);

    protected DirectCallNode createCallNode(LLVMFunctionCode code) {
        if (code.isLLVMIRFunction()) {
            return DirectCallNode.create((CallTarget)code.getLLVMIRFunctionSlowPath());
        }
        if (code.isIntrinsicFunctionSlowPath()) {
            return DirectCallNode.create((CallTarget)code.getIntrinsicSlowPath().cachedCallTarget(this.type));
        }
        return null;
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"code == cachedFunctionCode"})
    protected static Object doDirectCodeFast(LLVMFunctionCode code, Object[] arguments, @Cached(value="code") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCallNode(cachedFunctionCode)") DirectCallNode callNode) {
        assert (callNode != null) : "inconsistent behavior of LLVMLookupDispatchTargetSymbolNode";
        return callNode.call(arguments);
    }

    @Specialization(limit="INLINE_CACHE_SIZE", replaces={"doDirectCodeFast"}, guards={"descriptor == cachedDescriptor", "callNode != null"}, assumptions={"singleContextAssumption()"})
    protected static Object doDirectFunction(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor") LLVMFunctionDescriptor cachedDescriptor, @Cached(value="cachedDescriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCallNode(cachedFunctionCode)") DirectCallNode callNode) {
        return callNode.call(arguments);
    }

    @Specialization(limit="INLINE_CACHE_SIZE", replaces={"doDirectCodeFast", "doDirectFunction"}, guards={"descriptor.getFunctionCode() == cachedFunctionCode", "callNode != null"})
    protected static Object doDirectCode(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCallNode(cachedFunctionCode)") DirectCallNode callNode) {
        return callNode.call(arguments);
    }

    @Specialization(replaces={"doDirectCodeFast", "doDirectCode"}, guards={"descriptor.getFunctionCode().isLLVMIRFunction()"})
    protected static Object doIndirect(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached LLVMFunctionCode.ResolveFunctionNode resolve, @Cached(value="create()") IndirectCallNode callNode) {
        return callNode.call((CallTarget)descriptor.getFunctionCode().getLLVMIRFunction(resolve), arguments);
    }

    @Specialization(replaces={"doDirectCodeFast", "doDirectCode"}, guards={"descriptor.getFunctionCode().isIntrinsicFunction(resolve)"})
    protected Object doIndirectIntrinsic(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached LLVMFunctionCode.ResolveFunctionNode resolve, @Cached(value="create()") IndirectCallNode callNode) {
        return callNode.call((CallTarget)descriptor.getFunctionCode().getIntrinsic(resolve).cachedCallTarget(this.type), arguments);
    }

    @Specialization(limit="INLINE_CACHE_SIZE", guards={"descriptor == cachedDescriptor", "cachedFunctionCode.isNativeFunctionSlowPath()", "haveNativeCtxExt()"}, assumptions={"singleContextAssumption()"})
    protected Object doCachedNativeFunction(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor") LLVMFunctionDescriptor cachedDescriptor, @Cached(value="cachedDescriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached(value="bindSymbol(cachedFunctionCode, context)") Object cachedBoundFunction, @CachedLibrary(value="cachedBoundFunction") InteropLibrary nativeCall, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, cachedBoundFunction, nativeArgs, cachedDescriptor);
        return fromNative.executeConvert(returnValue);
    }

    @Specialization(replaces={"doCachedNativeFunction"}, guards={"descriptor.getFunctionCode() == cachedFunctionCode", "cachedFunctionCode.isNativeFunctionSlowPath()"}, assumptions={"singleContextAssumption()"})
    protected Object doCachedNativeCode(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="descriptor.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached(value="bindSymbol(cachedFunctionCode, context)") Object cachedBoundFunction, @CachedLibrary(value="cachedBoundFunction") InteropLibrary nativeCall, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, cachedBoundFunction, nativeArgs, descriptor);
        return fromNative.executeConvert(returnValue);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object doBind(NativeContextExtension ctxExt, LLVMFunctionCode functionCode, Source signatureSource) {
        return ctxExt.bindSignature(functionCode, signatureSource);
    }

    protected Object bindSymbol(LLVMFunctionCode functionCode, TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
        assert (functionCode.getNativeFunctionSlowPath() != null) : functionCode.getLLVMFunction().getName();
        return LLVMDispatchNode.doBind(this.getNativeCtxExt(ctxRef), functionCode, this.getSignatureSource(ctxRef));
    }

    @Specialization(replaces={"doCachedNativeCode"}, guards={"descriptor.getFunctionCode().isNativeFunction(resolve)", "haveNativeCtxExt()"})
    protected Object doNative(LLVMFunctionDescriptor descriptor, Object[] arguments, @Cached(value="createToNativeNodes()") LLVMNativeConvertNode[] toNative, @Cached(value="createFromNativeNode()") LLVMNativeConvertNode fromNative, @CachedLibrary(limit="3") InteropLibrary nativeCall, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> context, @Cached LLVMFunctionCode.ResolveFunctionNode resolve, @Cached(value="nativeCallStatisticsEnabled(context)") boolean statistics) {
        Object[] nativeArgs = LLVMDispatchNode.prepareNativeArguments(arguments, toNative);
        Object boundSymbol = this.bindSymbol(descriptor.getFunctionCode(), context);
        Object returnValue = LLVMNativeCallUtils.callNativeFunction(statistics, context, nativeCall, boundSymbol, nativeArgs, descriptor);
        return fromNative.executeConvert(returnValue);
    }

    @ExplodeLoop
    private static Object[] prepareNativeArguments(Object[] arguments, LLVMNativeConvertNode[] toNative) {
        Object[] nativeArgs = new Object[arguments.length - 1];
        for (int i = 1; i < arguments.length; ++i) {
            nativeArgs[i - 1] = toNative[i - 1].executeConvert(arguments[i]);
        }
        return nativeArgs;
    }

    protected LLVMNativeConvertNode[] createToNativeNodes() {
        LLVMNativeConvertNode[] ret = new LLVMNativeConvertNode[this.type.getNumberOfArguments() - 1];
        for (int i = 1; i < this.type.getNumberOfArguments(); ++i) {
            ret[i - 1] = LLVMNativeConvertNode.createToNative(this.type.getArgumentType(i));
        }
        return ret;
    }

    protected LLVMNativeConvertNode createFromNativeNode() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMNativeConvertNode.createFromNative(this.type.getReturnType());
    }

    @Specialization(guards={"foreigns.isForeign(receiver)"})
    protected Object doForeign(Object receiver, Object[] arguments, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") NativeTypeLibrary natives, @Cached(value="create(type)") LLVMLookupDispatchForeignNode lookupDispatchForeignNode) {
        return lookupDispatchForeignNode.execute(foreigns.asForeign(receiver), natives.getNativeType(receiver), arguments);
    }

    @Specialization(guards={"haveNativeCtxExt()"})
    protected static Object doNativeFunction(LLVMNativePointer pointer, Object[] arguments, @Cached(value="createCachedNativeDispatch()") LLVMNativeDispatchNode dispatchNode) {
        try {
            return dispatchNode.executeDispatch(pointer, arguments);
        }
        catch (IllegalStateException e) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMNativePointerException(dispatchNode, "Invalid native function pointer", e);
        }
    }

    @Specialization(guards={"!haveNativeCtxExt()"})
    protected Object doInvalidNativeFunction(LLVMNativePointer pointer, Object[] arguments) {
        throw new LLVMNativePointerException(this, "Invalid native function pointer", null);
    }

    protected LLVMNativeDispatchNode createCachedNativeDispatch() {
        return LLVMNativeDispatchNodeGen.create(this.type, this.getSignatureSource((TruffleLanguage.ContextReference<LLVMContext>)this.lookupContextReference(LLVMLanguage.class)));
    }

    static abstract class LLVMLookupDispatchForeignNode
    extends LLVMNode {
        private final boolean isVoidReturn;
        private final int argumentCount;
        private final FunctionType type;

        LLVMLookupDispatchForeignNode(FunctionType type) {
            this.type = type;
            this.isVoidReturn = type.getReturnType() instanceof VoidType;
            this.argumentCount = type.getNumberOfArguments();
        }

        abstract Object execute(Object var1, Object var2, Object[] var3);

        @Specialization(guards={"functionType == cachedType"}, limit="5")
        protected Object doCachedType(Object function, LLVMInteropType.Function functionType, Object[] arguments, @Cached(value="functionType") LLVMInteropType.Function cachedType, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode) {
            return this.doGeneric(function, cachedType, arguments, crossLanguageCall, dataEscapeNodes, toLLVMNode);
        }

        @Specialization(replaces={"doCachedType"}, limit="0")
        protected Object doGeneric(Object function, LLVMInteropType.Function functionType, Object[] arguments, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode) {
            try {
                Object[] args = this.getForeignArguments(dataEscapeNodes, arguments, functionType);
                Object ret = crossLanguageCall.execute(function, args);
                if (!this.isVoidReturn && functionType != null) {
                    LLVMInteropType retType = functionType.getReturnType();
                    if (retType instanceof LLVMInteropType.Value) {
                        return toLLVMNode.executeWithType(ret, ((LLVMInteropType.Value)retType).baseType);
                    }
                    CompilerDirectives.transferToInterpreter();
                    throw new LLVMPolyglotException(this, "Cannot call polyglot function with structured return type.");
                }
                return toLLVMNode.executeWithTarget(ret);
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        boolean isNotFunctionType(Object functionType) {
            return !(functionType instanceof LLVMInteropType.Function);
        }

        @Specialization(guards={"isNotFunctionType(functionType)"}, limit="5")
        protected Object doUnknownType(Object function, Object functionType, Object[] arguments, @CachedLibrary(value="function") InteropLibrary crossLanguageCall, @Cached(value="createLLVMDataEscapeNodes()") LLVMDataEscapeNode[] dataEscapeNodes, @Cached(value="createToLLVMNode()") ForeignToLLVM toLLVMNode) {
            return this.doGeneric(function, null, arguments, crossLanguageCall, dataEscapeNodes, toLLVMNode);
        }

        @ExplodeLoop
        private Object[] getForeignArguments(LLVMDataEscapeNode[] dataEscapeNodes, Object[] arguments, LLVMInteropType.Function functionType) {
            int i;
            assert (arguments.length == this.argumentCount);
            Object[] args = new Object[dataEscapeNodes.length];
            if (functionType != null) {
                assert (arguments.length == functionType.getNumberOfParameters() + 1);
                for (i = 0; i < functionType.getNumberOfParameters(); ++i) {
                    LLVMInteropType argType = functionType.getParameter(i);
                    if (!(argType instanceof LLVMInteropType.Value)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new LLVMPolyglotException(this, "Cannot call polyglot function with structured argument type.");
                    }
                    LLVMInteropType.Structured baseType = ((LLVMInteropType.Value)argType).baseType;
                    args[i] = dataEscapeNodes[i].executeWithType(arguments[i + 1], baseType);
                }
            }
            while (i < args.length) {
                args[i] = dataEscapeNodes[i].executeWithTarget(arguments[i + 1]);
                ++i;
            }
            return args;
        }

        protected ForeignToLLVM createToLLVMNode() {
            return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.convert(this.type.getReturnType()));
        }

        protected LLVMDataEscapeNode[] createLLVMDataEscapeNodes() {
            CompilerAsserts.neverPartOfCompilation();
            LLVMDataEscapeNode[] args = new LLVMDataEscapeNode[this.type.getNumberOfArguments() - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = LLVMDataEscapeNode.create(this.type.getArgumentType(i + 1));
            }
            return args;
        }

        public static LLVMLookupDispatchForeignNode create(FunctionType type) {
            return LLVMDispatchNodeGen.LLVMLookupDispatchForeignNodeGen.create(type);
        }
    }
}

