/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMBrUnconditionalNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMDispatchBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMLoopNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMSwitchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNode;

public final class LLVMLoopDispatchNode
extends LLVMNode
implements RepeatingNode {
    private final FrameSlot exceptionValueSlot;
    private final int headerId;
    @Node.Children
    private final LLVMBasicBlockNode[] bodyNodes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] indexMapping;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] loopSuccessors;
    private final FrameSlot successorSlot;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMBasicBlockNode[] originalBodyNodes;

    public LLVMLoopDispatchNode(FrameSlot exceptionValueSlot, LLVMBasicBlockNode[] bodyNodes, LLVMBasicBlockNode[] originalBodyNodes, int headerId, int[] indexMapping, int[] successors, FrameSlot successorSlot) {
        this.exceptionValueSlot = exceptionValueSlot;
        this.bodyNodes = bodyNodes;
        this.originalBodyNodes = originalBodyNodes;
        this.indexMapping = indexMapping;
        this.headerId = headerId;
        this.loopSuccessors = successors;
        this.successorSlot = successorSlot;
    }

    @ExplodeLoop
    private boolean isInLoop(int bci) {
        for (int i : this.loopSuccessors) {
            if (i != bci) continue;
            return false;
        }
        return true;
    }

    public boolean executeRepeating(VirtualFrame frame) {
        throw new IllegalStateException();
    }

    /*
     * Unable to fully structure code
     */
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object executeRepeatingWithValue(VirtualFrame frame) {
        CompilerAsserts.partialEvaluationConstant((int)this.bodyNodes.length);
        basicBlockIndex = this.headerId;
        while (true) lbl-1000:
        // 12 sources

        {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block24: {
                                block25: {
                                    CompilerAsserts.partialEvaluationConstant((int)basicBlockIndex);
                                    bb = this.bodyNodes[this.indexMapping[basicBlockIndex]];
                                    bb.initialize();
                                    bb = this.bodyNodes[this.indexMapping[basicBlockIndex]];
                                    bb.execute(frame);
                                    controlFlowNode = bb.getTerminatingInstruction();
                                    if (!(controlFlowNode instanceof LLVMConditionalBranchNode)) break block24;
                                    conditionalBranchNode = (LLVMConditionalBranchNode)controlFlowNode;
                                    condition = conditionalBranchNode.executeCondition(frame);
                                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(0), (boolean)condition)) break block25;
                                    if (CompilerDirectives.inInterpreter()) {
                                        bb.increaseBranchProbability(0);
                                    }
                                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                                    LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 0);
                                    basicBlockIndex = conditionalBranchNode.getTrueSuccessor();
                                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                                    if (basicBlockIndex == this.headerId) {
                                        return RepeatingNode.CONTINUE_LOOP_STATUS;
                                    }
                                    if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                                    frame.setInt(this.successorSlot, basicBlockIndex);
                                    return RepeatingNode.BREAK_LOOP_STATUS;
                                }
                                if (CompilerDirectives.inInterpreter()) {
                                    bb.increaseBranchProbability(1);
                                }
                                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                                LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 1);
                                basicBlockIndex = conditionalBranchNode.getFalseSuccessor();
                                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                                if (basicBlockIndex == this.headerId) {
                                    return RepeatingNode.CONTINUE_LOOP_STATUS;
                                }
                                if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                                frame.setInt(this.successorSlot, basicBlockIndex);
                                return RepeatingNode.BREAK_LOOP_STATUS;
                            }
                            if (!(controlFlowNode instanceof LLVMSwitchNode)) break block26;
                            switchNode = (LLVMSwitchNode)controlFlowNode;
                            condition = switchNode.executeCondition(frame);
                            successors = switchNode.getSuccessors();
                            for (i = 0; i < successors.length - 1; ++i) {
                                if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (boolean)switchNode.checkCase(frame, i, condition))) continue;
                                if (CompilerDirectives.inInterpreter()) {
                                    bb.increaseBranchProbability(i);
                                }
                                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                                LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                                basicBlockIndex = successors[i];
                                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                                if (basicBlockIndex == this.headerId) {
                                    return RepeatingNode.CONTINUE_LOOP_STATUS;
                                }
                                if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                                frame.setInt(this.successorSlot, basicBlockIndex);
                                return RepeatingNode.BREAK_LOOP_STATUS;
                            }
                            i = successors.length - 1;
                            if (CompilerDirectives.inInterpreter()) {
                                bb.increaseBranchProbability(i);
                            }
                            LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                            LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                            basicBlockIndex = successors[i];
                            LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                            if (basicBlockIndex == this.headerId) {
                                return RepeatingNode.CONTINUE_LOOP_STATUS;
                            }
                            if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                            frame.setInt(this.successorSlot, basicBlockIndex);
                            return RepeatingNode.BREAK_LOOP_STATUS;
                        }
                        if (!(controlFlowNode instanceof LLVMLoopNode)) break block27;
                        loop = (LLVMLoopNode)controlFlowNode;
                        loop.executeLoop(frame);
                        successorBasicBlockIndex = FrameUtil.getIntSafe((Frame)frame, (FrameSlot)this.successorSlot);
                        frame.setInt(this.successorSlot, 0);
                        successors = loop.getSuccessors();
                        for (i = 0; i < successors.length - 1; ++i) {
                            if (successorBasicBlockIndex != successors[i]) continue;
                            basicBlockIndex = successors[i];
                            if (basicBlockIndex == this.headerId) {
                                return RepeatingNode.CONTINUE_LOOP_STATUS;
                            }
                            if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                            frame.setInt(this.successorSlot, basicBlockIndex);
                            return RepeatingNode.BREAK_LOOP_STATUS;
                        }
                        i = successors.length - 1;
                        if (!LLVMLoopDispatchNode.$assertionsDisabled && successors[i] != successorBasicBlockIndex) {
                            throw new AssertionError((Object)"Could not find loop successor!");
                        }
                        basicBlockIndex = successors[i];
                        if (basicBlockIndex == this.headerId) {
                            return RepeatingNode.CONTINUE_LOOP_STATUS;
                        }
                        if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                        frame.setInt(this.successorSlot, basicBlockIndex);
                        return RepeatingNode.BREAK_LOOP_STATUS;
                    }
                    if (!(controlFlowNode instanceof LLVMIndirectBranchNode)) break block28;
                    indirectBranchNode = (LLVMIndirectBranchNode)controlFlowNode;
                    successors = indirectBranchNode.getSuccessors();
                    successorBasicBlockIndex = indirectBranchNode.executeCondition(frame);
                    for (i = 0; i < successors.length - 1; ++i) {
                        if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (boolean)(successors[i] == successorBasicBlockIndex))) continue;
                        if (CompilerDirectives.inInterpreter()) {
                            bb.increaseBranchProbability(i);
                        }
                        LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                        LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                        basicBlockIndex = successors[i];
                        LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                        if (basicBlockIndex == this.headerId) {
                            return RepeatingNode.CONTINUE_LOOP_STATUS;
                        }
                        if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                        frame.setInt(this.successorSlot, basicBlockIndex);
                        return RepeatingNode.BREAK_LOOP_STATUS;
                    }
                    i = successors.length - 1;
                    if (!LLVMLoopDispatchNode.$assertionsDisabled && successorBasicBlockIndex != successors[i]) {
                        throw new AssertionError();
                    }
                    if (CompilerDirectives.inInterpreter()) {
                        bb.increaseBranchProbability(i);
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                    basicBlockIndex = successors[i];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                    if (basicBlockIndex == this.headerId) {
                        return RepeatingNode.CONTINUE_LOOP_STATUS;
                    }
                    if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                    frame.setInt(this.successorSlot, basicBlockIndex);
                    return RepeatingNode.BREAK_LOOP_STATUS;
                }
                if (!(controlFlowNode instanceof LLVMBrUnconditionalNode)) break block29;
                unconditionalNode = (LLVMBrUnconditionalNode)controlFlowNode;
                unconditionalNode.execute(frame);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, unconditionalNode, 0);
                basicBlockIndex = unconditionalNode.getSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                if (basicBlockIndex == this.headerId) {
                    return RepeatingNode.CONTINUE_LOOP_STATUS;
                }
                if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                frame.setInt(this.successorSlot, basicBlockIndex);
                return RepeatingNode.BREAK_LOOP_STATUS;
            }
            if (!(controlFlowNode instanceof LLVMInvokeNode)) break;
            invokeNode = (LLVMInvokeNode)controlFlowNode;
            try {
                invokeNode.execute(frame);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 0);
                basicBlockIndex = invokeNode.getNormalSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                if (basicBlockIndex == this.headerId) {
                    return RepeatingNode.CONTINUE_LOOP_STATUS;
                }
                if (this.isInLoop(basicBlockIndex)) ** GOTO lbl-1000
                frame.setInt(this.successorSlot, basicBlockIndex);
                return RepeatingNode.BREAK_LOOP_STATUS;
            }
            catch (LLVMUserException e) {
                frame.setObject(this.exceptionValueSlot, (Object)e);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 1);
                basicBlockIndex = invokeNode.getUnwindSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.originalBodyNodes[basicBlockIndex].nullableBefore);
                if (basicBlockIndex != this.headerId) continue;
                return RepeatingNode.CONTINUE_LOOP_STATUS;
                if (this.isInLoop(basicBlockIndex)) continue;
                frame.setInt(this.successorSlot, basicBlockIndex);
                return RepeatingNode.BREAK_LOOP_STATUS;
            }
            break;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException("unexpected controlFlowNode type: " + (Object)controlFlowNode);
    }
}

