/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode;

@GeneratedBy(value=LLVMIndirectBranchNode.class)
final class LLVMIndirectBranchNodeWrapper
extends LLVMIndirectBranchNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LLVMIndirectBranchNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    LLVMIndirectBranchNodeWrapper(LLVMIndirectBranchNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LLVMIndirectBranchNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public int executeCondition(VirtualFrame frame) {
        int returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.executeCondition(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, (Object)returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = (Integer)result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public int getSuccessorCount() {
        return this.delegateNode.getSuccessorCount();
    }

    @Override
    public int[] getSuccessors() {
        return this.delegateNode.getSuccessors();
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return this.delegateNode.getPhiNode(successorIndex);
    }
}

