/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMFrameNullerUtil;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMBrUnconditionalNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMLoopNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMSwitchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMResumeNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnreachableNode;
import com.oracle.truffle.llvm.runtime.types.symbols.LocalVariableDebugInfo;

public abstract class LLVMDispatchBasicBlockNode
extends LLVMExpressionNode {
    private final FrameSlot exceptionValueSlot;
    private final LocalVariableDebugInfo debugInfo;
    @Node.Children
    private final LLVMBasicBlockNode[] bodyNodes;
    private final FrameSlot loopSuccessorSlot;

    public LLVMDispatchBasicBlockNode(FrameSlot exceptionValueSlot, LLVMBasicBlockNode[] bodyNodes, FrameSlot loopSuccessorSlot, LocalVariableDebugInfo debugInfo) {
        this.exceptionValueSlot = exceptionValueSlot;
        this.bodyNodes = bodyNodes;
        this.loopSuccessorSlot = loopSuccessorSlot;
        this.debugInfo = debugInfo;
    }

    public LocalVariableDebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    @Specialization
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object doDispatch(VirtualFrame frame) {
        Object returnValue = null;
        CompilerAsserts.partialEvaluationConstant((int)this.bodyNodes.length);
        int basicBlockIndex = 0;
        int backEdgeCounter = 0;
        block2: while (basicBlockIndex != -1) {
            int i;
            CompilerAsserts.partialEvaluationConstant((int)basicBlockIndex);
            LLVMBasicBlockNode bb = this.bodyNodes[basicBlockIndex];
            bb.initialize();
            bb = this.bodyNodes[basicBlockIndex];
            bb.execute(frame);
            LLVMControlFlowNode controlFlowNode = bb.getTerminatingInstruction();
            if (controlFlowNode instanceof LLVMConditionalBranchNode) {
                LLVMConditionalBranchNode conditionalBranchNode = (LLVMConditionalBranchNode)controlFlowNode;
                boolean condition = conditionalBranchNode.executeCondition(frame);
                if (CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(0), (boolean)condition)) {
                    if (CompilerDirectives.inInterpreter()) {
                        bb.increaseBranchProbability(0);
                        if (conditionalBranchNode.getTrueSuccessor() <= basicBlockIndex) {
                            ++backEdgeCounter;
                        }
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 0);
                    basicBlockIndex = conditionalBranchNode.getTrueSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue;
                }
                if (CompilerDirectives.inInterpreter()) {
                    bb.increaseBranchProbability(1);
                    if (conditionalBranchNode.getFalseSuccessor() <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                }
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 1);
                basicBlockIndex = conditionalBranchNode.getFalseSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMSwitchNode) {
                LLVMSwitchNode switchNode = (LLVMSwitchNode)controlFlowNode;
                Object condition = switchNode.executeCondition(frame);
                int[] successors = switchNode.getSuccessors();
                for (i = 0; i < successors.length - 1; ++i) {
                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (boolean)switchNode.checkCase(frame, i, condition))) continue;
                    if (CompilerDirectives.inInterpreter()) {
                        bb.increaseBranchProbability(i);
                        if (successors[i] <= basicBlockIndex) {
                            ++backEdgeCounter;
                        }
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                    basicBlockIndex = successors[i];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue block2;
                }
                i = successors.length - 1;
                if (CompilerDirectives.inInterpreter()) {
                    bb.increaseBranchProbability(i);
                    if (successors[i] <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                }
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                basicBlockIndex = successors[i];
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMLoopNode) {
                LLVMLoopNode loop = (LLVMLoopNode)controlFlowNode;
                loop.executeLoop(frame);
                int successorBasicBlockIndex = FrameUtil.getIntSafe((Frame)frame, (FrameSlot)this.loopSuccessorSlot);
                frame.setInt(this.loopSuccessorSlot, 0);
                int[] successors = loop.getSuccessors();
                for (i = 0; i < successors.length - 1; ++i) {
                    if (successorBasicBlockIndex != successors[i]) continue;
                    if (CompilerDirectives.inInterpreter() && successors[i] <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                    basicBlockIndex = successors[i];
                    continue block2;
                }
                i = successors.length - 1;
                assert (successors[i] == successorBasicBlockIndex) : "Could not find loop successor!";
                if (CompilerDirectives.inInterpreter() && successors[i] <= basicBlockIndex) {
                    ++backEdgeCounter;
                }
                basicBlockIndex = successors[i];
                continue;
            }
            if (controlFlowNode instanceof LLVMIndirectBranchNode) {
                LLVMIndirectBranchNode indirectBranchNode = (LLVMIndirectBranchNode)controlFlowNode;
                int[] successors = indirectBranchNode.getSuccessors();
                int successorBasicBlockIndex = indirectBranchNode.executeCondition(frame);
                for (i = 0; i < successors.length - 1; ++i) {
                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (successors[i] == successorBasicBlockIndex ? (byte)1 : 0) != 0)) continue;
                    if (CompilerDirectives.inInterpreter()) {
                        bb.increaseBranchProbability(i);
                        if (successors[i] <= basicBlockIndex) {
                            ++backEdgeCounter;
                        }
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                    basicBlockIndex = successors[i];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                    continue block2;
                }
                i = successors.length - 1;
                assert (successorBasicBlockIndex == successors[i]);
                if (CompilerDirectives.inInterpreter()) {
                    bb.increaseBranchProbability(i);
                    if (successors[i] <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                }
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                basicBlockIndex = successors[i];
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMBrUnconditionalNode) {
                LLVMBrUnconditionalNode unconditionalNode = (LLVMBrUnconditionalNode)controlFlowNode;
                if (CompilerDirectives.inInterpreter() && unconditionalNode.getSuccessor() <= basicBlockIndex) {
                    ++backEdgeCounter;
                }
                unconditionalNode.execute(frame);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                LLVMDispatchBasicBlockNode.executePhis(frame, unconditionalNode, 0);
                basicBlockIndex = unconditionalNode.getSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                continue;
            }
            if (controlFlowNode instanceof LLVMInvokeNode) {
                LLVMInvokeNode invokeNode = (LLVMInvokeNode)controlFlowNode;
                try {
                    invokeNode.execute(frame);
                    if (CompilerDirectives.inInterpreter() && invokeNode.getNormalSuccessor() <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 0);
                    basicBlockIndex = invokeNode.getNormalSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                }
                catch (LLVMUserException e) {
                    frame.setObject(this.exceptionValueSlot, (Object)e);
                    if (CompilerDirectives.inInterpreter() && invokeNode.getUnwindSuccessor() <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                    LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 1);
                    basicBlockIndex = invokeNode.getUnwindSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, this.bodyNodes[basicBlockIndex].nullableBefore);
                }
                continue;
            }
            if (controlFlowNode instanceof LLVMRetNode) {
                LLVMRetNode retNode = (LLVMRetNode)controlFlowNode;
                returnValue = retNode.execute(frame);
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(retNode));
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                basicBlockIndex = retNode.getSuccessor();
                continue;
            }
            if (controlFlowNode instanceof LLVMResumeNode) {
                LLVMResumeNode resumeNode = (LLVMResumeNode)controlFlowNode;
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(resumeNode));
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, bb.nullableAfter);
                resumeNode.execute(frame);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("must not reach here");
            }
            if (controlFlowNode instanceof LLVMUnreachableNode) {
                LLVMUnreachableNode unreachableNode = (LLVMUnreachableNode)controlFlowNode;
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(unreachableNode));
                unreachableNode.execute(frame);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("must not reach here");
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException("unexpected controlFlowNode type: " + (Object)((Object)controlFlowNode));
        }
        assert (backEdgeCounter >= 0);
        LoopNode.reportLoopCount((Node)this, (int)backEdgeCounter);
        assert (returnValue != null);
        return returnValue;
    }

    @ExplodeLoop
    public static void executePhis(VirtualFrame frame, LLVMControlFlowNode controlFlowNode, int successorIndex) {
        LLVMStatementNode phi = controlFlowNode.getPhiNode(successorIndex);
        if (phi != null) {
            phi.execute(frame);
        }
    }

    @ExplodeLoop
    public static void nullDeadSlots(VirtualFrame frame, FrameSlot[] frameSlotsToNull) {
        if (frameSlotsToNull != null) {
            assert (frameSlotsToNull.length > 0);
            for (int i = 0; i < frameSlotsToNull.length; ++i) {
                LLVMFrameNullerUtil.nullFrameSlot(frame, frameSlotsToNull[i]);
            }
        }
    }

    private static boolean noPhisNecessary(LLVMControlFlowNode controlFlowNode) {
        return controlFlowNode.getSuccessorCount() == 0 || controlFlowNode.getSuccessorCount() == 1 && controlFlowNode.getPhiNode(0) == null;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return false;
        }
        if (tag == StandardTags.RootBodyTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }
}

