/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMBrUnconditionalNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMBrUnconditionalNodeWrapper;

@GenerateWrapper
@NodeField(name="successor", type=int.class)
public abstract class LLVMBrUnconditionalNode
extends LLVMControlFlowNode {
    public static LLVMBrUnconditionalNode create(int successor, LLVMStatementNode phi) {
        return LLVMBrUnconditionalNodeFactory.LLVMBrUnconditionalNodeImplNodeGen.create(phi, successor);
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMBrUnconditionalNodeWrapper(this, probe);
    }

    public abstract int getSuccessor();

    public abstract void execute(VirtualFrame var1);

    static abstract class LLVMBrUnconditionalNodeImpl
    extends LLVMBrUnconditionalNode {
        @Node.Child
        private LLVMStatementNode phi;

        LLVMBrUnconditionalNodeImpl(LLVMStatementNode phi) {
            this.phi = phi;
        }

        @Override
        public String toString() {
            return this.getShortString("successor");
        }

        @Override
        public int getSuccessorCount() {
            return 1;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            assert (successorIndex == 0);
            return this.phi;
        }

        @Specialization
        public void doCondition() {
        }

        @Override
        public final int[] getSuccessors() {
            return new int[]{this.getSuccessor()};
        }
    }
}

