/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitSmall;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVarINode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToVarINode.class)
public final class LLVMToVarINodeGen
extends LLVMToVarINode {
    private final int bits;
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private LLVMToNativeNode toNative_;
    @Node.Child
    private LLVMToVarINode recursive_;

    private LLVMToVarINodeGen(LLVMExpressionNode fromNode, int bits) {
        this.bits = bits;
        this.fromNode_ = fromNode;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    protected LLVMIVarBit executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (state_0 != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.toNative_, this.recursive_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                this.toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                this.recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.toNative_, this.recursive_);
                return lLVMIVarBit;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMToVarINode create(LLVMExpressionNode fromNode, int bits) {
        return new LLVMToVarINodeGen(fromNode, bits);
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMBitcastToIVarNode.class)
    public static final class LLVMBitcastToIVarNodeGen
    extends LLVMToVarINode.LLVMBitcastToIVarNode {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToVarINode pointer_recursive_;

        private LLVMBitcastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x10) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FD) == 0 && (state_0 & 0x1FF) != 0) {
                return this.executeGeneric_byte0(state_0, frameValue);
            }
            if ((state_0 & 0x1FB) == 0 && (state_0 & 0x1FF) != 0) {
                return this.executeGeneric_short1(state_0, frameValue);
            }
            if ((state_0 & 0x1F7) == 0 && (state_0 & 0x1FF) != 0) {
                return this.executeGeneric_int2(state_0, frameValue);
            }
            if ((state_0 & 0x1EF) == 0 && (state_0 & 0x1FF) != 0) {
                return this.executeGeneric_long3(state_0, frameValue);
            }
            if ((state_0 & 0x1BF) == 0 && (state_0 & 0x1FF) != 0) {
                return this.executeGeneric_float4(state_0, frameValue);
            }
            if ((state_0 & 0x17F) == 0 && (state_0 & 0x1FF) != 0) {
                return this.executeGeneric_double5(state_0, frameValue);
            }
            return this.executeGeneric_generic6(state_0, frameValue);
        }

        private Object executeGeneric_byte0(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float4(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x40) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double5(int state_0, VirtualFrame frameValue) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic6(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state_0 & 0x20) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE00) >>> 9, fromNodeValue_)) {
                LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE00) >>> 9, fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__);
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI8(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI16(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI32(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI64(fromNodeValue_);
                    return lLVMIVarBit;
                }
                int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue);
                if (lLVMIVarBitCast0 != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 |= lLVMIVarBitCast0 << 9;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doFloat(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doDouble(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.do80BitFloat(fromNodeValue_);
                    return lLVMIVarBit;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FF & (state_0 & 0x1FF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVarINode.LLVMBitcastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMBitcastToIVarNodeGen(fromNode, bits);
        }
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMUnsignedCastToIVarNode.class)
    public static final class LLVMUnsignedCastToIVarNodeGen
    extends LLVMToVarINode.LLVMUnsignedCastToIVarNode {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToVarINode pointer_recursive_;

        private LLVMUnsignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x10) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7D) == 0 && state_0 != 0) {
                return this.executeGeneric_byte0(state_0, frameValue);
            }
            if ((state_0 & 0x7B) == 0 && state_0 != 0) {
                return this.executeGeneric_short1(state_0, frameValue);
            }
            if ((state_0 & 0x77) == 0 && state_0 != 0) {
                return this.executeGeneric_int2(state_0, frameValue);
            }
            if ((state_0 & 0x6F) == 0 && state_0 != 0) {
                return this.executeGeneric_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte0(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic4(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state_0 & 0x20) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                LLVMIVarBitSmall fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI8(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI16(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI32(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI64(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                    LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                    LLVMIVarBitSmall fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVarINode.LLVMUnsignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMUnsignedCastToIVarNodeGen(fromNode, bits);
        }
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMSignedCastToIVarNode.class)
    public static final class LLVMSignedCastToIVarNodeGen
    extends LLVMToVarINode.LLVMSignedCastToIVarNode {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToVarINode pointer_recursive_;

        private LLVMSignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x10) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFD) == 0 && state_0 != 0) {
                return this.executeGeneric_byte0(state_0, frameValue);
            }
            if ((state_0 & 0xFB) == 0 && state_0 != 0) {
                return this.executeGeneric_short1(state_0, frameValue);
            }
            if ((state_0 & 0xF7) == 0 && state_0 != 0) {
                return this.executeGeneric_int2(state_0, frameValue);
            }
            if ((state_0 & 0xEF) == 0 && state_0 != 0) {
                return this.executeGeneric_long3(state_0, frameValue);
            }
            return this.executeGeneric_generic4(state_0, frameValue);
        }

        private Object executeGeneric_byte0(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic4(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state_0 & 2) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state_0 & 0x20) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                LLVMIVarBitSmall fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI8(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI16(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI32(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI64(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                    LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                    LLVMIVarBitSmall fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.do80BitFloat(fromNodeValue_);
                    return lLVMIVarBit;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVarINode.LLVMSignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMSignedCastToIVarNodeGen(fromNode, bits);
        }
    }
}

