/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI32Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToI32Node.class)
public final class LLVMToI32NodeGen
extends LLVMToI32Node {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private ManagedPointerData managedPointer_cache;
    @Node.Child
    private LLVMToNativeNode pointer_toNative_;

    private LLVMToI32NodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        LLVMPointer fromNodeValue__;
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
            ManagedPointerData s1_ = this.managedPointer_cache;
            if (s1_ != null && LLVMToI32Node.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
            }
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.pointer_toNative_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public int executeI32(VirtualFrame frameValue) {
        LLVMPointer fromNodeValue__;
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
            ManagedPointerData s1_ = this.managedPointer_cache;
            if (s1_ != null && LLVMToI32Node.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
            }
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.pointer_toNative_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private int executeAndSpecialize(Object fromNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            InteropLibrary interop__;
            LLVMAsForeignLibrary foreigns__;
            LLVMPointer fromNodeValue_;
            if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToI32Node.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                s1_.interop_ = s1_.insertAccessor(interop__);
                this.managedPointer_cache = s1_;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, foreigns__, interop__);
                return n;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                int n = this.doPointer(fromNodeValue_, this.pointer_toNative_);
                return n;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMToI32Node create(LLVMExpressionNode fromNode) {
        return new LLVMToI32NodeGen(fromNode);
    }

    @GeneratedBy(value=LLVMToI32Node.LLVMBitcastToI32Node.class)
    public static final class LLVMBitcastToI32NodeGen
    extends LLVMToI32Node.LLVMBitcastToI32Node {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;

        private LLVMBitcastToI32NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FB) == 0 && state_0 != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 0x1F7) == 0 && state_0 != 0) {
                return this.executeGeneric_float1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_float1(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI32Node.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__2 = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__3 = ((Float)fromNodeValue_).floatValue();
                return this.doI32(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector((LLVMI8Vector)fromNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector((LLVMI16Vector)fromNodeValue__);
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector((LLVMI32Vector)fromNodeValue__);
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector((LLVMFloatVector)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FB) == 0 && state_0 != 0) {
                return this.executeI32_int3(state_0, frameValue);
            }
            if ((state_0 & 0x1F7) == 0 && state_0 != 0) {
                return this.executeI32_float4(state_0, frameValue);
            }
            return this.executeI32_generic5(state_0, frameValue);
        }

        private int executeI32_int3(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_float4(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_generic5(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI32Node.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__2 = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__3 = ((Float)fromNodeValue_).floatValue();
                return this.doI32(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector((LLVMI8Vector)fromNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector((LLVMI16Vector)fromNodeValue__);
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector((LLVMI32Vector)fromNodeValue__);
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector((LLVMFloatVector)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private int executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                Object fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToI32Node.isForeignNumber((LLVMManagedPointer)(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue)), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, foreigns__, interop__);
                    return n;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doPointer((LLVMPointer)fromNodeValue_, this.pointer_toNative_);
                    return n;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_2 = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32(fromNodeValue_2);
                    return n;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_3 = ((Float)fromNodeValue).floatValue();
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32(fromNodeValue_3);
                    return n;
                }
                if (fromNodeValue instanceof LLVMI1Vector) {
                    fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI1Vector((LLVMI1Vector)fromNodeValue_);
                    return n;
                }
                if (fromNodeValue instanceof LLVMI8Vector) {
                    fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI8Vector((LLVMI8Vector)fromNodeValue_);
                    return n;
                }
                if (fromNodeValue instanceof LLVMI16Vector) {
                    fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI16Vector((LLVMI16Vector)fromNodeValue_);
                    return n;
                }
                if (fromNodeValue instanceof LLVMI32Vector) {
                    fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32Vector((LLVMI32Vector)fromNodeValue_);
                    return n;
                }
                if (fromNodeValue instanceof LLVMFloatVector) {
                    fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doFloatVector((LLVMFloatVector)fromNodeValue_);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToI32Node.LLVMBitcastToI32Node create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToI32NodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToI32Node.LLVMBitcastToI32Node.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToI32Node.LLVMUnsignedCastToI32Node.class)
    public static final class LLVMUnsignedCastToI32NodeGen
    extends LLVMToI32Node.LLVMUnsignedCastToI32Node {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;

        private LLVMUnsignedCastToI32NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFFB) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0xFF7) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0xFEF) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0xFDF) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0xE7F) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeGeneric_float4(state_0, frameValue);
            }
            if ((state_0 & 0x9FF) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeGeneric_double5(state_0, frameValue);
            }
            return this.executeGeneric_generic6(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI1(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_float4(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state_0 & 0x80) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doFloat(fromNodeValue_);
            }
            if ((state_0 & 0x100) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doFloatConversion(fromNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
        }

        private Object executeGeneric_double5(int state_0, VirtualFrame frameValue) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state_0 & 0x200) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doDouble(fromNodeValue_);
            }
            if ((state_0 & 0x400) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doDoubleConversion(fromNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private Object executeGeneric_generic6(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI32Node.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doI1(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__4);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__5);
            }
            if ((state_0 & 0x40) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_)) {
                fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_);
                return this.doIVarBit((LLVMIVarBit)fromNodeValue__);
            }
            if ((state_0 & 0x180) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__6 = ((Float)fromNodeValue_).floatValue();
                if ((state_0 & 0x80) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__6)) {
                    return this.doFloat(fromNodeValue__6);
                }
                if ((state_0 & 0x100) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__6)) {
                    return this.doFloatConversion(fromNodeValue__6);
                }
            }
            if ((state_0 & 0x600) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__7 = (Double)fromNodeValue_;
                if ((state_0 & 0x200) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__7)) {
                    return this.doDouble(fromNodeValue__7);
                }
                if ((state_0 & 0x400) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__7)) {
                    return this.doDoubleConversion(fromNodeValue__7);
                }
            }
            if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doLLVM80BitFloat((LLVM80BitFloat)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFFB) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeI32_boolean7(state_0, frameValue);
            }
            if ((state_0 & 0xFF7) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeI32_byte8(state_0, frameValue);
            }
            if ((state_0 & 0xFEF) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeI32_short9(state_0, frameValue);
            }
            if ((state_0 & 0xFDF) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeI32_int10(state_0, frameValue);
            }
            if ((state_0 & 0xE7F) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeI32_float11(state_0, frameValue);
            }
            if ((state_0 & 0x9FF) == 0 && (state_0 & 0xFFF) != 0) {
                return this.executeI32_double12(state_0, frameValue);
            }
            return this.executeI32_generic13(state_0, frameValue);
        }

        private int executeI32_boolean7(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI1(fromNodeValue_);
        }

        private int executeI32_byte8(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI8(fromNodeValue_);
        }

        private int executeI32_short9(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI16(fromNodeValue_);
        }

        private int executeI32_int10(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_float11(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state_0 & 0x80) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doFloat(fromNodeValue_);
            }
            if ((state_0 & 0x100) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doFloatConversion(fromNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
        }

        private int executeI32_double12(int state_0, VirtualFrame frameValue) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if ((state_0 & 0x200) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doDouble(fromNodeValue_);
            }
            if ((state_0 & 0x400) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_)) {
                return this.doDoubleConversion(fromNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private int executeI32_generic13(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI32Node.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doI1(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__4);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__5);
            }
            if ((state_0 & 0x40) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_)) {
                fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_);
                return this.doIVarBit((LLVMIVarBit)fromNodeValue__);
            }
            if ((state_0 & 0x180) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__6 = ((Float)fromNodeValue_).floatValue();
                if ((state_0 & 0x80) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__6)) {
                    return this.doFloat(fromNodeValue__6);
                }
                if ((state_0 & 0x100) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__6)) {
                    return this.doFloatConversion(fromNodeValue__6);
                }
            }
            if ((state_0 & 0x600) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__7 = (Double)fromNodeValue_;
                if ((state_0 & 0x200) != 0 && LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__7)) {
                    return this.doDouble(fromNodeValue__7);
                }
                if ((state_0 & 0x400) != 0 && !LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue__7)) {
                    return this.doDoubleConversion(fromNodeValue__7);
                }
            }
            if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doLLVM80BitFloat((LLVM80BitFloat)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private int executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__2;
                LLVMPointer fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToI32Node.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__2 = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__2);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, foreigns__2, interop__);
                    return n;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doPointer(fromNodeValue_, this.pointer_toNative_);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI1(fromNodeValue_2);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_3 = (Byte)fromNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI8(fromNodeValue_3);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_4 = (Short)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI16(fromNodeValue_4);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_5 = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI32(fromNodeValue_5);
                    return foreigns__2;
                }
                int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue);
                if (lLVMIVarBitCast0 != 0) {
                    LLVMIVarBit fromNodeValue_6 = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 |= lLVMIVarBitCast0 << 12;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doIVarBit(fromNodeValue_6);
                    return n;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_7 = ((Float)fromNodeValue).floatValue();
                    if (LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_7)) {
                        this.state_0_ = state_0 |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        int n = this.doFloat(fromNodeValue_7);
                        return n;
                    }
                    if (!LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_7)) {
                        this.state_0_ = state_0 |= 0x100;
                        lock.unlock();
                        hasLock = false;
                        int n = this.doFloatConversion(fromNodeValue_7);
                        return n;
                    }
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_8 = (Double)fromNodeValue;
                    if (LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_8)) {
                        this.state_0_ = state_0 |= 0x200;
                        lock.unlock();
                        hasLock = false;
                        int n = this.doDouble(fromNodeValue_8);
                        return n;
                    }
                    if (!LLVMToI32Node.LLVMUnsignedCastToI32Node.fitsIntoSignedInt(fromNodeValue_8)) {
                        this.state_0_ = state_0 |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        int n = this.doDoubleConversion(fromNodeValue_8);
                        return n;
                    }
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_9 = (LLVM80BitFloat)fromNodeValue;
                    this.state_0_ = state_0 |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doLLVM80BitFloat(fromNodeValue_9);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFFF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFFF & (state_0 & 0xFFF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToI32Node.LLVMUnsignedCastToI32Node create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToI32NodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToI32Node.LLVMUnsignedCastToI32Node.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToI32Node.LLVMSignedCastToI32Node.class)
    public static final class LLVMSignedCastToI32NodeGen
    extends LLVMToI32Node.LLVMSignedCastToI32Node {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;

        private LLVMSignedCastToI32NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FB) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x7F7) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x7EF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x7DF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x7BF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0x6FF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            if ((state_0 & 0x5FF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeGeneric_double6(state_0, frameValue);
            }
            return this.executeGeneric_generic7(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x100) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0, VirtualFrame frameValue) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x200) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI32Node.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doI32(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doI32(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doI32(fromNodeValue__4);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__5);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doI32(fromNodeValue__6);
            }
            if ((state_0 & 0x80) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x3800) >>> 11, fromNodeValue_)) {
                fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x3800) >>> 11, fromNodeValue_);
                return this.doI32((LLVMIVarBit)fromNodeValue__);
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return this.doI32(fromNodeValue__7);
            }
            if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__8 = (Double)fromNodeValue_;
                return this.doI32(fromNodeValue__8);
            }
            if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doI32((LLVM80BitFloat)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FB) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeI32_boolean8(state_0, frameValue);
            }
            if ((state_0 & 0x7F7) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeI32_byte9(state_0, frameValue);
            }
            if ((state_0 & 0x7EF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeI32_short10(state_0, frameValue);
            }
            if ((state_0 & 0x7DF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeI32_int11(state_0, frameValue);
            }
            if ((state_0 & 0x7BF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeI32_long12(state_0, frameValue);
            }
            if ((state_0 & 0x6FF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeI32_float13(state_0, frameValue);
            }
            if ((state_0 & 0x5FF) == 0 && (state_0 & 0x7FF) != 0) {
                return this.executeI32_double14(state_0, frameValue);
            }
            return this.executeI32_generic15(state_0, frameValue);
        }

        private int executeI32_boolean8(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_byte9(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_short10(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_int11(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_long12(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_float13(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x100) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_double14(int state_0, VirtualFrame frameValue) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x200) != 0);
            return this.doI32(fromNodeValue_);
        }

        private int executeI32_generic15(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI32Node.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doI32(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doI32(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doI32(fromNodeValue__4);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__5);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doI32(fromNodeValue__6);
            }
            if ((state_0 & 0x80) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x3800) >>> 11, fromNodeValue_)) {
                fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x3800) >>> 11, fromNodeValue_);
                return this.doI32((LLVMIVarBit)fromNodeValue__);
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return this.doI32(fromNodeValue__7);
            }
            if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__8 = (Double)fromNodeValue_;
                return this.doI32(fromNodeValue__8);
            }
            if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doI32((LLVM80BitFloat)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private int executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__2;
                LLVMPointer fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToI32Node.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__2 = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__2);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, foreigns__2, interop__);
                    return n;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doPointer(fromNodeValue_, this.pointer_toNative_);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI32(fromNodeValue_2);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_3 = (Byte)fromNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI32(fromNodeValue_3);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_4 = (Short)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI32(fromNodeValue_4);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_5 = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    int foreigns__2 = this.doI32(fromNodeValue_5);
                    return foreigns__2;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_6 = (Long)fromNodeValue;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32(fromNodeValue_6);
                    return n;
                }
                int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue);
                if (lLVMIVarBitCast0 != 0) {
                    LLVMIVarBit fromNodeValue_7 = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 |= lLVMIVarBitCast0 << 11;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32(fromNodeValue_7);
                    return n;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_8 = ((Float)fromNodeValue).floatValue();
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32(fromNodeValue_8);
                    return n;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_9 = (Double)fromNodeValue;
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32(fromNodeValue_9);
                    return n;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_10 = (LLVM80BitFloat)fromNodeValue;
                    this.state_0_ = state_0 |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doI32(fromNodeValue_10);
                    return n;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x7FF & (state_0 & 0x7FF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToI32Node.LLVMSignedCastToI32Node create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToI32NodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToI32Node.LLVMSignedCastToI32Node.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToI32Node.class)
    private static final class ManagedPointerData
    extends Node {
        @Node.Child
        ForeignToLLVM toLLVM_;
        @Node.Child
        LLVMAsForeignLibrary foreigns_;
        @Node.Child
        InteropLibrary interop_;

        ManagedPointerData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

