/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToFloatNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToFloatNode.class)
public final class LLVMToFloatNodeGen
extends LLVMToFloatNode {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private ManagedPointerData managedPointer_cache;
    @Node.Child
    private LLVMToNativeNode pointer_toNative_;
    @Node.Child
    private LLVMToFloatNode pointer_recursive_;

    private LLVMToFloatNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    protected float executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        LLVMPointer fromNodeValue__;
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
            ManagedPointerData s1_ = this.managedPointer_cache;
            if (s1_ != null && LLVMToFloatNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                return Float.valueOf(this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_));
            }
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return Float.valueOf(this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_));
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return Float.valueOf(this.executeAndSpecialize(fromNodeValue_));
    }

    @Override
    public float executeFloat(VirtualFrame frameValue) {
        LLVMPointer fromNodeValue__;
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
            ManagedPointerData s1_ = this.managedPointer_cache;
            if (s1_ != null && LLVMToFloatNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
            }
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private float executeAndSpecialize(Object fromNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            InteropLibrary interop__;
            LLVMAsForeignLibrary foreigns__;
            LLVMPointer fromNodeValue_;
            if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToFloatNode.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                s1_.interop_ = s1_.insertAccessor(interop__);
                this.managedPointer_cache = s1_;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                float f = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                return f;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                this.pointer_recursive_ = (LLVMToFloatNode)super.insert((Node)this.createRecursive());
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                float f = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                return f;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMToFloatNode create(LLVMExpressionNode fromNode) {
        return new LLVMToFloatNodeGen(fromNode);
    }

    @GeneratedBy(value=LLVMToFloatNode.LLVMBitcastToFloatNode.class)
    public static final class LLVMBitcastToFloatNodeGen
    extends LLVMToFloatNode.LLVMBitcastToFloatNode {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToFloatNode pointer_recursive_;

        private LLVMBitcastToFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        protected float executeWith(long fromNodeValue) {
            throw CompilerDirectives.shouldNotReachHere((String)"Delegation failed.");
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FB) == 0 && state_0 != 0) {
                return this.executeGeneric_int0(state_0, frameValue);
            }
            if ((state_0 & 0x1F7) == 0 && state_0 != 0) {
                return this.executeGeneric_float1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_int0(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 4) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_float1(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 8) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_generic2(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToFloatNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return Float.valueOf(this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_));
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return Float.valueOf(this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_));
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__2 = (Integer)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__2));
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__3 = ((Float)fromNodeValue_).floatValue();
                return Float.valueOf(this.doFloat(fromNodeValue__3));
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return Float.valueOf(this.doI1Vector((LLVMI1Vector)fromNodeValue__));
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return Float.valueOf(this.doI8Vector((LLVMI8Vector)fromNodeValue__));
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return Float.valueOf(this.doI16Vector((LLVMI16Vector)fromNodeValue__));
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return Float.valueOf(this.doI32Vector((LLVMI32Vector)fromNodeValue__));
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return Float.valueOf(this.doFloatVector((LLVMFloatVector)fromNodeValue__));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(fromNodeValue_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FB) == 0 && state_0 != 0) {
                return this.executeFloat_int3(state_0, frameValue);
            }
            if ((state_0 & 0x1F7) == 0 && state_0 != 0) {
                return this.executeFloat_float4(state_0, frameValue);
            }
            return this.executeFloat_generic5(state_0, frameValue);
        }

        private float executeFloat_int3(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_float4(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_generic5(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToFloatNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__2 = (Integer)fromNodeValue_;
                return this.doFloat(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__3 = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                return this.doI1Vector((LLVMI1Vector)fromNodeValue__);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                return this.doI8Vector((LLVMI8Vector)fromNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                return this.doI16Vector((LLVMI16Vector)fromNodeValue__);
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                return this.doI32Vector((LLVMI32Vector)fromNodeValue__);
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                return this.doFloatVector((LLVMFloatVector)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private float executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                Object fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToFloatNode.isForeignNumber((LLVMManagedPointer)(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue)), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                    return f;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToFloatNode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doPointer((LLVMPointer)fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return f;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_2 = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_2);
                    return f;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_3 = ((Float)fromNodeValue).floatValue();
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_3);
                    return f;
                }
                if (fromNodeValue instanceof LLVMI1Vector) {
                    fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doI1Vector((LLVMI1Vector)fromNodeValue_);
                    return f;
                }
                if (fromNodeValue instanceof LLVMI8Vector) {
                    fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doI8Vector((LLVMI8Vector)fromNodeValue_);
                    return f;
                }
                if (fromNodeValue instanceof LLVMI16Vector) {
                    fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doI16Vector((LLVMI16Vector)fromNodeValue_);
                    return f;
                }
                if (fromNodeValue instanceof LLVMI32Vector) {
                    fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doI32Vector((LLVMI32Vector)fromNodeValue_);
                    return f;
                }
                if (fromNodeValue instanceof LLVMFloatVector) {
                    fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloatVector((LLVMFloatVector)fromNodeValue_);
                    return f;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToFloatNode.LLVMBitcastToFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToFloatNodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToFloatNode.LLVMBitcastToFloatNode.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToFloatNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToFloatNode.LLVMUnsignedCastToFloatNode.class)
    public static final class LLVMUnsignedCastToFloatNodeGen
    extends LLVMToFloatNode.LLVMUnsignedCastToFloatNode {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToFloatNode pointer_recursive_;

        private LLVMUnsignedCastToFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        protected float executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x40) != 0) {
                return this.doFloat(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFB) == 0 && state_0 != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0xF7) == 0 && state_0 != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0xEF) == 0 && state_0 != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0xDF) == 0 && state_0 != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0xBF) == 0 && state_0 != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0x7F) == 0 && state_0 != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            return this.executeGeneric_generic6(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 4) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_byte1(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 8) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_short2(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x10) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_int3(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x20) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_long4(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x40) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_float5(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x80) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_generic6(int state_0, VirtualFrame frameValue) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToFloatNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return Float.valueOf(this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_));
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return Float.valueOf(this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_));
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__2));
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__3));
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__4));
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__5));
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__6));
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return Float.valueOf(this.doFloat(fromNodeValue__7));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(fromNodeValue_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFB) == 0 && state_0 != 0) {
                return this.executeFloat_boolean7(state_0, frameValue);
            }
            if ((state_0 & 0xF7) == 0 && state_0 != 0) {
                return this.executeFloat_byte8(state_0, frameValue);
            }
            if ((state_0 & 0xEF) == 0 && state_0 != 0) {
                return this.executeFloat_short9(state_0, frameValue);
            }
            if ((state_0 & 0xDF) == 0 && state_0 != 0) {
                return this.executeFloat_int10(state_0, frameValue);
            }
            if ((state_0 & 0xBF) == 0 && state_0 != 0) {
                return this.executeFloat_long11(state_0, frameValue);
            }
            if ((state_0 & 0x7F) == 0 && state_0 != 0) {
                return this.executeFloat_float12(state_0, frameValue);
            }
            return this.executeFloat_generic13(state_0, frameValue);
        }

        private float executeFloat_boolean7(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_byte8(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_short9(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_int10(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x20) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_long11(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x40) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_float12(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x80) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_generic13(int state_0, VirtualFrame frameValue) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToFloatNode.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doFloat(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doFloat(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doFloat(fromNodeValue__4);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doFloat(fromNodeValue__5);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doFloat(fromNodeValue__6);
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__7);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private float executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                LLVMPointer fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToFloatNode.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                    return f;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToFloatNode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return f;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_2);
                    return f;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_3 = (Byte)fromNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_3);
                    return f;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_4 = (Short)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_4);
                    return f;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_5 = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_5);
                    return f;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_6 = (Long)fromNodeValue;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_6);
                    return f;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_7 = ((Float)fromNodeValue).floatValue();
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_7);
                    return f;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToFloatNode.LLVMUnsignedCastToFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToFloatNodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToFloatNode.LLVMUnsignedCastToFloatNode.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToFloatNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToFloatNode.LLVMSignedCastToFloatNode.class)
    public static final class LLVMSignedCastToFloatNodeGen
    extends LLVMToFloatNode.LLVMSignedCastToFloatNode {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToFloatNode pointer_recursive_;

        private LLVMSignedCastToFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        protected float executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x40) != 0) {
                return this.doFloat(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FB) == 0 && state_0 != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x3F7) == 0 && state_0 != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x3EF) == 0 && state_0 != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x3DF) == 0 && state_0 != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x3BF) == 0 && state_0 != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0x37F) == 0 && state_0 != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            if ((state_0 & 0x2FF) == 0 && state_0 != 0) {
                return this.executeGeneric_double6(state_0, frameValue);
            }
            return this.executeGeneric_generic7(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 4) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_byte1(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 8) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_short2(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x10) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_int3(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x20) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_long4(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x40) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_float5(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x80) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_double6(int state_0, VirtualFrame frameValue) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            assert ((state_0 & 0x100) != 0);
            return Float.valueOf(this.doFloat(fromNodeValue_));
        }

        private Object executeGeneric_generic7(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToFloatNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return Float.valueOf(this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_));
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return Float.valueOf(this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_));
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__2));
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__3));
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__4));
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__5));
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__6));
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return Float.valueOf(this.doFloat(fromNodeValue__7));
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__8 = (Double)fromNodeValue_;
                return Float.valueOf(this.doFloat(fromNodeValue__8));
            }
            if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return Float.valueOf(this.doFloat((LLVM80BitFloat)fromNodeValue__));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(fromNodeValue_));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x3FB) == 0 && state_0 != 0) {
                return this.executeFloat_boolean8(state_0, frameValue);
            }
            if ((state_0 & 0x3F7) == 0 && state_0 != 0) {
                return this.executeFloat_byte9(state_0, frameValue);
            }
            if ((state_0 & 0x3EF) == 0 && state_0 != 0) {
                return this.executeFloat_short10(state_0, frameValue);
            }
            if ((state_0 & 0x3DF) == 0 && state_0 != 0) {
                return this.executeFloat_int11(state_0, frameValue);
            }
            if ((state_0 & 0x3BF) == 0 && state_0 != 0) {
                return this.executeFloat_long12(state_0, frameValue);
            }
            if ((state_0 & 0x37F) == 0 && state_0 != 0) {
                return this.executeFloat_float13(state_0, frameValue);
            }
            if ((state_0 & 0x2FF) == 0 && state_0 != 0) {
                return this.executeFloat_double14(state_0, frameValue);
            }
            return this.executeFloat_generic15(state_0, frameValue);
        }

        private float executeFloat_boolean8(int state_0, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_byte9(int state_0, VirtualFrame frameValue) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 8) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_short10(int state_0, VirtualFrame frameValue) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x10) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_int11(int state_0, VirtualFrame frameValue) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x20) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_long12(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x40) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_float13(int state_0, VirtualFrame frameValue) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x80) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_double14(int state_0, VirtualFrame frameValue) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 0x100) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private float executeFloat_generic15(int state_0, VirtualFrame frameValue) {
            Object fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToFloatNode.isForeignNumber((LLVMManagedPointer)fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.recursive_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer((LLVMPointer)fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__2 = (Boolean)fromNodeValue_;
                return this.doFloat(fromNodeValue__2);
            }
            if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__3 = (Byte)fromNodeValue_;
                return this.doFloat(fromNodeValue__3);
            }
            if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__4 = (Short)fromNodeValue_;
                return this.doFloat(fromNodeValue__4);
            }
            if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__5 = (Integer)fromNodeValue_;
                return this.doFloat(fromNodeValue__5);
            }
            if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__6 = (Long)fromNodeValue_;
                return this.doFloat(fromNodeValue__6);
            }
            if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__7 = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__7);
            }
            if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__8 = (Double)fromNodeValue_;
                return this.doFloat(fromNodeValue__8);
            }
            if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.doFloat((LLVM80BitFloat)fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private float executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                Object fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToFloatNode.isForeignNumber((LLVMManagedPointer)(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue)), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.recursive_ = s1_.insertAccessor(this.createRecursive());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, s1_.recursive_, foreigns__, interop__);
                    return f;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToFloatNode)super.insert((Node)this.createRecursive());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doPointer((LLVMPointer)fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return f;
                }
                if (fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_2 = (Boolean)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_2);
                    return f;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_3 = (Byte)fromNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_3);
                    return f;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_4 = (Short)fromNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_4);
                    return f;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_5 = (Integer)fromNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_5);
                    return f;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_6 = (Long)fromNodeValue;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_6);
                    return f;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_7 = ((Float)fromNodeValue).floatValue();
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_7);
                    return f;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_8 = (Double)fromNodeValue;
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat(fromNodeValue_8);
                    return f;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    float f = this.doFloat((LLVM80BitFloat)fromNodeValue_);
                    return f;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToFloatNode.LLVMSignedCastToFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToFloatNodeGen(fromNode);
        }

        @GeneratedBy(value=LLVMToFloatNode.LLVMSignedCastToFloatNode.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMToFloatNode recursive_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMToFloatNode.class)
    private static final class ManagedPointerData
    extends Node {
        @Node.Child
        ForeignToLLVM toLLVM_;
        @Node.Child
        LLVMToFloatNode recursive_;
        @Node.Child
        LLVMAsForeignLibrary foreigns_;
        @Node.Child
        InteropLibrary interop_;

        ManagedPointerData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

