/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall.posix;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

public abstract class LLVMPosixCallNode
extends LLVMNode {
    private final String name;
    private final String signature;

    public LLVMPosixCallNode(String name, String signature) {
        this.name = name;
        this.signature = signature;
    }

    protected NativeContextExtension.WellKnownNativeFunctionNode createFunctionNode() {
        LLVMContext context = (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
        NativeContextExtension nativeContextExtension = context.getContextExtension(NativeContextExtension.class);
        return nativeContextExtension.getWellKnownNativeFunction("__sulong_posix_" + this.name, this.signature);
    }

    public final Object execute(Object ... args) {
        return this.executeObject(args);
    }

    public abstract Object executeObject(Object[] var1);

    @Specialization
    protected Object doCall(Object[] args, @Cached(value="createFunctionNode()") NativeContextExtension.WellKnownNativeFunctionNode function) {
        try {
            return function.execute(args);
        }
        catch (InteropException e) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String toString() {
        return "posix " + this.name;
    }
}

