/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

@NodeChildren(value={@NodeChild(value="syscallNum"), @NodeChild(value="arg1"), @NodeChild(value="arg2"), @NodeChild(value="arg3"), @NodeChild(value="arg4"), @NodeChild(value="arg5"), @NodeChild(value="arg6")})
public abstract class LLVMSyscallNode
extends LLVMExpressionNode {
    protected static final int NUM_SYSCALLS = 332;

    protected LLVMSyscallOperationNode createNode(long syscallNum) {
        return LLVMLanguage.getLanguage().getCapability(PlatformCapability.class).createSyscallNode(syscallNum);
    }

    @Specialization(guards={"syscallNum == cachedSyscallNum"}, limit="NUM_SYSCALLS")
    protected long cachedSyscall(long syscallNum, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, @Cached(value="syscallNum") long cachedSyscallNum, @Cached(value="createNode(syscallNum)") LLVMSyscallOperationNode node, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
        if (context.syscallTraceStream() != null) {
            LLVMSyscallNode.trace(context, "[sulong] syscall: %s (%s, %s, %s, %s, %s, %s)\n", LLVMSyscallNode.getNodeName(node), arg1, arg2, arg3, arg4, arg5, arg6);
        }
        long result = node.execute(arg1, arg2, arg3, arg4, arg5, arg6);
        if (context.syscallTraceStream() != null) {
            LLVMSyscallNode.trace(context, "         result: %d\n", result);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static String getNodeName(LLVMSyscallOperationNode node) {
        return node.getName();
    }

    @Specialization(replaces={"cachedSyscall"})
    protected long doI64(long syscallNum, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        CompilerDirectives.transferToInterpreter();
        return this.createNode(syscallNum).execute(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @CompilerDirectives.TruffleBoundary
    private static void trace(LLVMContext context, String format, Object ... args) {
        context.syscallTraceStream().printf(format, args);
    }
}

