/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMStringHelper
extends LLVMNode {
    public abstract void execute(LLVMPointer var1, long var2, String var4);

    @Specialization
    void doNative(LLVMNativePointer dst, long bufLength, String src, @CachedLanguage LLVMLanguage language) {
        LLVMMemory memory = language.getLLVMMemory();
        byte[] bytes = LLVMStringHelper.getBytes(src);
        long ptr = dst.asNative();
        for (int i = 0; i < bytes.length && (long)i < bufLength - 1L; ++i) {
            memory.putI8((Node)this, ptr++, bytes[i]);
        }
        memory.putI8((Node)this, ptr++, (byte)0);
    }

    @Specialization(limit="3")
    void doManaged(LLVMManagedPointer dst, long bufLength, String src, @Bind(value="dst.getObject()") Object obj, @CachedLibrary(value="obj") LLVMManagedWriteLibrary write) {
        byte[] bytes = LLVMStringHelper.getBytes(src);
        long offset = dst.getOffset();
        for (int i = 0; i < bytes.length && (long)i < bufLength - 1L; ++i) {
            write.writeI8(obj, offset++, bytes[i]);
        }
        write.writeI8(obj, offset++, (byte)0);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] getBytes(String str) {
        return str.getBytes();
    }
}

