/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToI8Node;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI8Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64ToI8Node.class)
public final class LLVMAMD64ToI8NodeFactory {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=LLVMAMD64ToI8Node.LLVMAMD64I64ToI8Node.class)
    public static final class LLVMAMD64I64ToI8NodeGen
    extends LLVMAMD64ToI8Node.LLVMAMD64I64ToI8Node {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private ManagedPointerData managedPointer_cache;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;

        private LLVMAMD64I64ToI8NodeGen(int shift, LLVMExpressionNode fromNode) {
            super(shift);
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0 && state_0 != 0) {
                return this.executeGeneric_long0(state_0, frameValue);
            }
            return this.executeGeneric_generic1(state_0, frameValue);
        }

        private Object executeGeneric_long0(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_generic1(int state_0, VirtualFrame frameValue) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI8Node.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__2 = (Long)fromNodeValue_;
                return this.doI8(fromNodeValue__2);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0 && state_0 != 0) {
                return this.executeI8_long2(state_0, frameValue);
            }
            return this.executeI8_generic3(state_0, frameValue);
        }

        private byte executeI8_long2(int state_0, VirtualFrame frameValue) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            return this.doI8(fromNodeValue_);
        }

        private byte executeI8_generic3(int state_0, VirtualFrame frameValue) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state_0 & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s1_ = this.managedPointer_cache;
                if (s1_ != null && LLVMToI8Node.isForeignNumber(fromNodeValue__, s1_.foreigns_, s1_.interop_)) {
                    return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, s1_.toLLVM_, s1_.foreigns_, s1_.interop_);
                }
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_);
            }
            if ((state_0 & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__2 = (Long)fromNodeValue_;
                return this.doI8(fromNodeValue__2);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private byte executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                InteropLibrary interop__;
                LLVMAsForeignLibrary foreigns__;
                LLVMPointer fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && LLVMToI8Node.isForeignNumber(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue), foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)), interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3)))) {
                    ManagedPointerData s1_ = (ManagedPointerData)super.insert((Node)new ManagedPointerData());
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM());
                    s1_.foreigns_ = s1_.insertAccessor(foreigns__);
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    this.managedPointer_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    byte by = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, s1_.toLLVM_, foreigns__, interop__);
                    return by;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    byte by = this.doPointer(fromNodeValue_, this.pointer_toNative_);
                    return by;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_2 = (Long)fromNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    byte by = this.doI8(fromNodeValue_2);
                    return by;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64ToI8Node.LLVMAMD64I64ToI8Node create(int shift, LLVMExpressionNode fromNode) {
            return new LLVMAMD64I64ToI8NodeGen(shift, fromNode);
        }

        @GeneratedBy(value=LLVMAMD64ToI8Node.LLVMAMD64I64ToI8Node.class)
        private static final class ManagedPointerData
        extends Node {
            @Node.Child
            ForeignToLLVM toLLVM_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @Node.Child
            InteropLibrary interop_;

            ManagedPointerData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

