/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64FrameSlotNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteNodeGen;

public class LLVMAMD64Target {
    private final Object location;
    private final int shift;

    public LLVMAMD64Target(FrameSlot location) {
        this(location, 0);
    }

    public LLVMAMD64Target(FrameSlot location, int shift) {
        this.location = location;
        this.shift = shift;
    }

    public LLVMAMD64Target(LLVMExpressionNode src) {
        this.location = src;
        this.shift = 0;
    }

    public LLVMExpressionNode createInput() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.location instanceof LLVMExpressionNode) {
            return (LLVMExpressionNode)((Object)this.location);
        }
        if (this.location instanceof FrameSlot) {
            return LLVMAMD64FrameSlotNodeGen.create((FrameSlot)this.location);
        }
        throw new IllegalStateException();
    }

    public LLVMAMD64WriteNode createTarget() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMAMD64WriteNodeGen.create(this.shift);
    }
}

