/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToNativeNode.class)
public final class LLVMToNativeNodeGen
extends LLVMToNativeNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private Convert0Data convert0_cache;

    private LLVMToNativeNodeGen() {
    }

    @Override
    @ExplodeLoop
    public LLVMNativePointer executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0) {
                Convert0Data s1_ = this.convert0_cache;
                while (s1_ != null) {
                    if (s1_.nativeLibrary_.accepts(arg0Value)) {
                        return LLVMToNativeNode.doConvert(arg0Value, s1_.nativeLibrary_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.convert1Boundary(state_0, arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private LLVMNativePointer convert1Boundary(int state_0, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            LLVMNativeLibrary convert1_nativeLibrary__ = (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value);
            LLVMNativePointer lLVMNativePointer = LLVMToNativeNode.doConvert(arg0Value, convert1_nativeLibrary__);
            return lLVMNativePointer;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMNativePointer executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            LLVMNativePointer lLVMNativePointer;
            if (exclude == 0) {
                int count1_ = 0;
                Convert0Data s1_ = this.convert0_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null && !s1_.nativeLibrary_.accepts(arg0Value)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 5) {
                    s1_ = (Convert0Data)super.insert((Node)new Convert0Data(this.convert0_cache));
                    s1_.nativeLibrary_ = (LLVMNativeLibrary)s1_.insertAccessor(L_L_V_M_NATIVE_LIBRARY_.create(arg0Value));
                    this.convert0_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer2 = LLVMToNativeNode.doConvert(arg0Value, s1_.nativeLibrary_);
                    return lLVMNativePointer2;
                }
            }
            LLVMNativeLibrary convert1_nativeLibrary__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                convert1_nativeLibrary__ = (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value);
                this.exclude_ = exclude |= 1;
                this.convert0_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                lLVMNativePointer = LLVMToNativeNode.doConvert(arg0Value, convert1_nativeLibrary__);
            }
            catch (Throwable throwable) {
                encapsulating_.set(prev_);
                throw throwable;
            }
            encapsulating_.set(prev_);
            return lLVMNativePointer;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        Convert0Data s1_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.convert0_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMToNativeNode create() {
        return new LLVMToNativeNodeGen();
    }

    public static LLVMToNativeNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMToNativeNode.class)
    private static final class Uncached
    extends LLVMToNativeNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMNativePointer executeWithTarget(Object arg0Value) {
            return LLVMToNativeNode.doConvert(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMToNativeNode.class)
    private static final class Convert0Data
    extends Node {
        @Node.Child
        Convert0Data next_;
        @Node.Child
        LLVMNativeLibrary nativeLibrary_;

        Convert0Data(Convert0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

