/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

public abstract class LLVMInstrumentableNode
extends LLVMNode
implements InstrumentableNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;

    private LLVMInstrumentableNode unwrap() {
        return this instanceof InstrumentableNode.WrapperNode ? (LLVMInstrumentableNode)((InstrumentableNode.WrapperNode)this).getDelegateNode() : this;
    }

    public final LLVMSourceLocation getSourceLocation() {
        return this.unwrap().sourceLocation;
    }

    public final void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.unwrap().sourceLocation = sourceLocation;
    }

    public final SourceSection getSourceSection() {
        LLVMSourceLocation location = this.getSourceLocation();
        return location == null ? null : location.getSourceSection();
    }

    protected final boolean isStatement() {
        return this.unwrap().statement;
    }

    protected final void setStatement(boolean statementTag) {
        this.unwrap().statement = statementTag;
    }

    public boolean hasStatementTag() {
        return this.isStatement() && this.getSourceLocation() != null;
    }

    public void setHasStatementTag(boolean b) {
        CompilerAsserts.neverPartOfCompilation();
        this.setStatement(b);
    }

    public final boolean isInstrumentable() {
        return this.getSourceLocation() != null;
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return this.hasStatementTag();
        }
        return false;
    }
}

