/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.except.LLVMAllocationFailureException;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.except.LLVMStackOverflowError;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;

public final class LLVMStack {
    private static final String STACK_ID = "<stack>";
    private static final String BASE_POINTER_ID = "<base>";
    private static final String UNIQUES_REGION_ID = "<uniques_region>";
    private static final long MAX_ALLOCATION_SIZE = Integer.MAX_VALUE;
    public static final int NO_ALIGNMENT_REQUIREMENTS = 1;
    private final LLVMContext context;
    private final long stackSize;
    private long lowerBounds;
    private long upperBounds;
    private long stackPointer;

    public LLVMStack(long stackSize, LLVMContext context) {
        this.context = context;
        this.stackSize = stackSize;
        this.lowerBounds = 0L;
        this.upperBounds = 0L;
        this.stackPointer = 0L;
    }

    public LLVMContext getContext() {
        return this.context;
    }

    private boolean isAllocated() {
        return this.stackPointer != 0L;
    }

    public static FrameSlot getStackSlot(FrameDescriptor frameDescriptor) {
        return frameDescriptor.findOrAddFrameSlot((Object)STACK_ID, (Object)PointerType.VOID, FrameSlotKind.Object);
    }

    private static FrameSlot getBasePointerSlot(FrameDescriptor frameDescriptor, boolean create) {
        if (create) {
            return frameDescriptor.findOrAddFrameSlot((Object)BASE_POINTER_ID, (Object)PointerType.VOID, FrameSlotKind.Long);
        }
        return frameDescriptor.findFrameSlot((Object)BASE_POINTER_ID);
    }

    public static FrameSlot getUniquesRegionSlot(FrameDescriptor frameDescriptor) {
        return frameDescriptor.findOrAddFrameSlot((Object)UNIQUES_REGION_ID, (Object)PointerType.VOID, FrameSlotKind.Object);
    }

    @CompilerDirectives.TruffleBoundary
    private void allocate(Node location, LLVMMemory memory) {
        long stackAllocation;
        this.lowerBounds = stackAllocation = memory.allocateMemory(location, this.stackSize).asNative();
        this.upperBounds = stackAllocation + this.stackSize;
        this.stackPointer = this.upperBounds & 0xFFFFFFFFFFFFFFF8L;
        assert (this.stackPointer != 0L);
    }

    @CompilerDirectives.TruffleBoundary
    public void free(LLVMMemory memory) {
        if (this.isAllocated()) {
            memory.free(null, this.lowerBounds);
            this.lowerBounds = 0L;
            this.upperBounds = 0L;
            this.stackPointer = 0L;
        }
    }

    public static abstract class LLVMGetUniqueStackSpaceInstruction
    extends LLVMExpressionNode {
        private final long slotOffset;
        private final FrameSlot uniquesRegionFrameSlot;

        public LLVMGetUniqueStackSpaceInstruction(long slotOffset, FrameDescriptor desc) {
            this.slotOffset = slotOffset;
            this.uniquesRegionFrameSlot = LLVMStack.getUniquesRegionSlot(desc);
        }

        @Override
        public String toString() {
            return this.getShortString("slotOffset", "uniquesRegionFrameSlot");
        }

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame) {
            try {
                return LLVMPointer.cast(frame.getObject(this.uniquesRegionFrameSlot)).increment(this.slotOffset);
            }
            catch (FrameSlotTypeException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMAllocationFailureException((Node)this, e);
            }
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMAllocaInstruction
    extends LLVMGetStackSpaceInstruction {
        public LLVMAllocaInstruction(long size, int alignment) {
            super(size, alignment);
        }

        public abstract LLVMPointer executeWithTarget(VirtualFrame var1, long var2);

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame, int nr) {
            return this.doOp(frame, (long)nr);
        }

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame, long nr) {
            return this.ensureStackAccess().executeAllocate(frame, this.size * nr, this.alignment);
        }
    }

    public static abstract class LLVMAllocaConstInstruction
    extends LLVMGetStackSpaceInstruction {
        public LLVMAllocaConstInstruction(long size, int alignment) {
            super(size, alignment);
        }

        @Specialization
        protected LLVMPointer doOp(VirtualFrame frame) {
            return this.ensureStackAccess().executeAllocate(frame, this.size, this.alignment);
        }
    }

    public static abstract class LLVMGetStackSpaceInstruction
    extends LLVMExpressionNode {
        protected final long size;
        protected final int alignment;
        @CompilerDirectives.CompilationFinal
        private LLVMStackAccess stackAccess;

        public LLVMGetStackSpaceInstruction(long size, int alignment) {
            this.size = size;
            this.alignment = alignment;
        }

        public void setStackAccess(LLVMStackAccess stackAccess) {
            this.stackAccess = stackAccess;
        }

        protected final LLVMStackAccess ensureStackAccess() {
            if (this.stackAccess == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stackAccess = ((LLVMRootNode)this.getRootNode()).getStackAccess();
            }
            return this.stackAccess;
        }

        @Override
        public String toString() {
            return this.getShortString("size", "alignment", "stackAccess");
        }
    }

    public static final class LLVMNativeStackAccess
    extends LLVMStackAccess {
        private final LLVMMemory memory;
        private final FrameSlot stackSlot;
        private final Assumption noBasePointerAssumption;
        @CompilerDirectives.CompilationFinal
        private FrameSlot basePointerSlot;
        @CompilerDirectives.CompilationFinal
        private boolean hasAllocatedStack;

        public LLVMNativeStackAccess(FrameDescriptor frameDescriptor, LLVMMemory memory) {
            this.memory = memory;
            this.stackSlot = LLVMStack.getStackSlot(frameDescriptor);
            this.basePointerSlot = LLVMStack.getBasePointerSlot(frameDescriptor, false);
            this.noBasePointerAssumption = this.basePointerSlot == null ? frameDescriptor.getNotInFrameAssumption((Object)LLVMStack.BASE_POINTER_ID) : null;
            this.hasAllocatedStack = false;
        }

        protected FrameSlot ensureBasePointerSlot(VirtualFrame frame, LLVMStack llvmStack, boolean createSlot) {
            if (!llvmStack.isAllocated()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hasAllocatedStack = true;
                llvmStack.allocate(this, this.memory);
            }
            if (this.basePointerSlot == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.basePointerSlot = LLVMStack.getBasePointerSlot(frame.getFrameDescriptor(), createSlot);
                assert (this.basePointerSlot != null) : "base pointer slot should exist at this point";
                assert (this.noBasePointerAssumption == null || !this.noBasePointerAssumption.isValid());
            }
            return this.basePointerSlot;
        }

        @Override
        public void executeEnter(VirtualFrame frame) {
            this.executeEnter(frame, (LLVMStack)frame.getArguments()[0]);
        }

        @Override
        public void executeEnter(VirtualFrame frame, LLVMStack llvmStack) {
            frame.setObject(this.stackSlot, (Object)llvmStack);
            if (this.hasAllocatedStack && !llvmStack.isAllocated()) {
                CompilerDirectives.transferToInterpreter();
                llvmStack.allocate(this, this.memory);
            }
            if (this.noBasePointerAssumption == null || !this.noBasePointerAssumption.isValid()) {
                frame.setLong(this.ensureBasePointerSlot(frame, llvmStack, false), llvmStack.stackPointer);
            }
        }

        @Override
        public void executeExit(VirtualFrame frame) {
            if (this.noBasePointerAssumption == null || !this.noBasePointerAssumption.isValid()) {
                try {
                    LLVMStack llvmStack = (LLVMStack)frame.getObject(this.stackSlot);
                    long basePointer = frame.getLong(this.ensureBasePointerSlot(frame, llvmStack, false));
                    if (basePointer == 0L) {
                        CompilerDirectives.transferToInterpreter();
                    } else {
                        llvmStack.stackPointer = basePointer;
                    }
                }
                catch (FrameSlotTypeException e) {
                    throw new LLVMMemoryException((Node)this, e);
                }
            }
        }

        private LLVMStack getStack(VirtualFrame frame) {
            try {
                LLVMStack llvmStack = (LLVMStack)frame.getObject(this.stackSlot);
                if (!llvmStack.isAllocated()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.hasAllocatedStack = true;
                    llvmStack.allocate(this, this.memory);
                }
                return llvmStack;
            }
            catch (FrameSlotTypeException e) {
                throw new LLVMMemoryException((Node)this, e);
            }
        }

        private void initializeBasePointer(VirtualFrame frame, LLVMStack llvmStack) {
            try {
                long basePointer = frame.getLong(this.ensureBasePointerSlot(frame, llvmStack, true));
                if (basePointer != 0L) {
                    return;
                }
            }
            catch (FrameSlotTypeException frameSlotTypeException) {
                // empty catch block
            }
            CompilerDirectives.transferToInterpreter();
            frame.setLong(this.ensureBasePointerSlot(frame, llvmStack, false), llvmStack.stackPointer);
        }

        @Override
        public LLVMPointer executeGet(VirtualFrame frame) {
            return LLVMNativePointer.create(this.getStack(frame).stackPointer);
        }

        @Override
        public void executeSet(VirtualFrame frame, LLVMPointer pointer) {
            LLVMStack llvmStack = this.getStack(frame);
            this.initializeBasePointer(frame, llvmStack);
            if (!LLVMNativePointer.isInstance(pointer)) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMMemoryException((Node)this, "invalid stack pointer");
            }
            llvmStack.stackPointer = LLVMNativePointer.cast(pointer).asNative();
        }

        @Override
        public LLVMPointer executeAllocate(VirtualFrame frame, long size, int alignment) {
            LLVMStack llvmStack = this.getStack(frame);
            this.initializeBasePointer(frame, llvmStack);
            long stackPointer = llvmStack.stackPointer;
            assert (stackPointer != 0L);
            long alignedAllocation = LLVMNativeStackAccess.getAlignedAllocation(stackPointer, size, Math.max(alignment, 8));
            assert ((alignedAllocation & 7L) == 0L) : "misaligned stack";
            llvmStack.stackPointer = alignedAllocation;
            return LLVMNativePointer.create(alignedAllocation);
        }

        private static long getAlignedAllocation(long address, long size, int alignment) {
            if (Long.compareUnsigned(size, Integer.MAX_VALUE) > 0) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMStackOverflowError(String.format("Stack allocation of %s bytes exceeds limit of %s", Long.toUnsignedString(size), Long.toUnsignedString(Integer.MAX_VALUE)));
            }
            assert (alignment >= 8 && LLVMNativeStackAccess.powerOfTwo(alignment));
            long alignedAllocation = address - size & (long)(-alignment);
            assert (alignedAllocation <= address);
            return alignedAllocation;
        }

        private static boolean powerOfTwo(int value) {
            return (value & -value) == value;
        }

        @Override
        public LLVMStack executeGetStack(VirtualFrame frame) {
            try {
                return (LLVMStack)frame.getObject(this.stackSlot);
            }
            catch (FrameSlotTypeException e) {
                throw new LLVMMemoryException((Node)this, e);
            }
        }
    }

    public static abstract class LLVMStackAccess
    extends Node {
        public abstract void executeEnter(VirtualFrame var1);

        public abstract void executeEnter(VirtualFrame var1, LLVMStack var2);

        public abstract void executeExit(VirtualFrame var1);

        public abstract LLVMPointer executeGet(VirtualFrame var1);

        public abstract void executeSet(VirtualFrame var1, LLVMPointer var2);

        public abstract LLVMPointer executeAllocate(VirtualFrame var1, long var2, int var4);

        public abstract LLVMStack executeGetStack(VirtualFrame var1);
    }

    public static final class UniquesRegion {
        private long currentSlotOffset = 0L;
        private int alignment = 8;
        private boolean finished;

        public long addSlot(long slotSize, int slotAlignment) {
            CompilerAsserts.neverPartOfCompilation();
            assert (!this.finished) : "cannot add slots after size was queried";
            assert (Long.bitCount(slotAlignment) == 1) : "alignment must be a power of two";
            long slotOffset = this.currentSlotOffset + (long)slotAlignment - 1L & (long)(-slotAlignment);
            this.currentSlotOffset = slotOffset + slotSize;
            this.alignment = Integer.highestOneBit(this.alignment | slotAlignment);
            return slotOffset;
        }

        public long getSize() {
            this.finished = true;
            return this.currentSlotOffset;
        }

        public boolean isEmpty() {
            return this.getSize() == 0L;
        }

        public int getAlignment() {
            this.finished = true;
            return this.alignment;
        }
    }
}

