/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMManagedAccessDefaults.class)
final class LLVMManagedAccessDefaultsFactory {
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    LLVMManagedAccessDefaultsFactory() {
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.GetWriteIdentifierNode.class)
    static final class GetWriteIdentifierNodeGen
    extends LLVMManagedAccessDefaults.GetWriteIdentifierNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private GetWriteIdentifierNodeGen() {
        }

        @Override
        long execute(long arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    return this.doByte(arg0Value, arg1Value_);
                }
                if ((state_0 & 2) != 0 && arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    return this.doShort(arg0Value, arg1Value_);
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof Character) {
                    char arg1Value_ = ((Character)arg1Value).charValue();
                    return this.doChar(arg0Value, arg1Value_);
                }
                if ((state_0 & 8) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return this.doInt(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x10) != 0 && arg1Value instanceof Float) {
                    float arg1Value_ = ((Float)arg1Value).floatValue();
                    return this.doFloat(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x20) != 0 && GetWriteIdentifierNodeGen.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                    return this.doDouble(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(long arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (Byte)arg1Value;
                this.state_0_ = state_0 |= 1;
                return this.doByte(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (Short)arg1Value;
                this.state_0_ = state_0 |= 2;
                return this.doShort(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Character) {
                char arg1Value_ = ((Character)arg1Value).charValue();
                this.state_0_ = state_0 |= 4;
                return this.doChar(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_ = state_0 |= 8;
                return this.doInt(arg0Value, arg1Value_);
            }
            if (arg1Value instanceof Float) {
                float arg1Value_ = ((Float)arg1Value).floatValue();
                this.state_0_ = state_0 |= 0x10;
                return this.doFloat(arg0Value, arg1Value_);
            }
            this.state_0_ = state_0 |= 0x20;
            return this.doDouble(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state_0, long arg0Value, Object arg1Value) {
            if ((state_0 & 1) == 0 && arg1Value instanceof Byte) {
                return false;
            }
            if ((state_0 & 2) == 0 && arg1Value instanceof Short) {
                return false;
            }
            if ((state_0 & 4) == 0 && arg1Value instanceof Character) {
                return false;
            }
            if ((state_0 & 8) == 0 && arg1Value instanceof Integer) {
                return false;
            }
            return (state_0 & 0x10) != 0 || !(arg1Value instanceof Float);
        }

        public static LLVMManagedAccessDefaults.GetWriteIdentifierNode create() {
            return new GetWriteIdentifierNodeGen();
        }

        public static LLVMManagedAccessDefaults.GetWriteIdentifierNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.GetWriteIdentifierNode.class)
        private static final class Uncached
        extends LLVMManagedAccessDefaults.GetWriteIdentifierNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            long execute(long arg0Value, Object arg1Value) {
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    return this.doByte(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    return this.doShort(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Character) {
                    char arg1Value_ = ((Character)arg1Value).charValue();
                    return this.doChar(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return this.doInt(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Float) {
                    float arg1Value_ = ((Float)arg1Value).floatValue();
                    return this.doFloat(arg0Value, arg1Value_);
                }
                return this.doDouble(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackWriteNode.class)
    static final class FallbackWriteNodeGen
    extends LLVMManagedAccessDefaults.FallbackWriteNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private CachedTypeData cachedType_cache;

        private FallbackWriteNodeGen() {
        }

        @Override
        @ExplodeLoop
        void executeWrite(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    CachedTypeData s1_ = this.cachedType_cache;
                    while (s1_ != null) {
                        if (arg3Value == s1_.cachedType_) {
                            this.doCachedType(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedType_, s1_.dataEscape_, s1_.interop_, s1_.getWriteIdentifier_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedTypeData s1_ = this.cachedType_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null && arg3Value != s1_.cachedType_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (CachedTypeData)super.insert((Node)new CachedTypeData(this.cachedType_cache));
                        s1_.cachedType_ = arg3Value;
                        s1_.dataEscape_ = s1_.insertAccessor(LLVMDataEscapeNode.create(s1_.cachedType_));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.createDispatched(5));
                        s1_.getWriteIdentifier_ = s1_.insertAccessor(GetWriteIdentifierNodeGen.create());
                        this.cachedType_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCachedType(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedType_, s1_.dataEscape_, s1_.interop_, s1_.getWriteIdentifier_);
                        return;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cachedType_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedTypeData s1_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cachedType_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMManagedAccessDefaults.FallbackWriteNode create() {
            return new FallbackWriteNodeGen();
        }

        public static LLVMManagedAccessDefaults.FallbackWriteNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackWriteNode.class)
        private static final class Uncached
        extends LLVMManagedAccessDefaults.FallbackWriteNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void executeWrite(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
                this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackWriteNode.class)
        private static final class CachedTypeData
        extends Node {
            @Node.Child
            CachedTypeData next_;
            @CompilerDirectives.CompilationFinal
            ForeignToLLVM.ForeignToLLVMType cachedType_;
            @Node.Child
            LLVMDataEscapeNode dataEscape_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMManagedAccessDefaults.GetWriteIdentifierNode getWriteIdentifier_;

            CachedTypeData(CachedTypeData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.LLVMMemoryWriteNode.class)
    static final class LLVMMemoryWriteNodeGen
    extends LLVMManagedAccessDefaults.LLVMMemoryWriteNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMNativeLibrary writeI64_nativeLibrary_;
        @Node.Child
        private LLVMNativeLibrary writePointer_nativeLibrary_;

        private LLVMMemoryWriteNodeGen() {
        }

        @Override
        void executeWrite(long arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    LLVMLanguage writeI8_language__ = (LLVMLanguage)lLVMLanguageReference__.get();
                    this.writeI8(arg0Value, arg1Value_, writeI8_language__);
                    return;
                }
                if ((state_0 & 2) != 0 && arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1 = this.lLVMLanguageReference_;
                    LLVMLanguage writeI16_language__ = (LLVMLanguage)lLVMLanguageReference__1.get();
                    this.writeI16(arg0Value, arg1Value_, writeI16_language__);
                    return;
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                    LLVMLanguage writeI32_language__ = (LLVMLanguage)lLVMLanguageReference__2.get();
                    this.writeI32(arg0Value, arg1Value_, writeI32_language__);
                    return;
                }
                if ((state_0 & 8) != 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__3 = this.lLVMLanguageReference_;
                    LLVMLanguage writeI64_language__ = (LLVMLanguage)lLVMLanguageReference__3.get();
                    this.writeI64(arg0Value, arg1Value_, writeI64_language__, this.writeI64_nativeLibrary_);
                    return;
                }
                if ((state_0 & 0x10) != 0 && arg1Value instanceof Float) {
                    float arg1Value_ = ((Float)arg1Value).floatValue();
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__4 = this.lLVMLanguageReference_;
                    LLVMLanguage writeFloat_language__ = (LLVMLanguage)lLVMLanguageReference__4.get();
                    this.writeFloat(arg0Value, arg1Value_, writeFloat_language__);
                    return;
                }
                if ((state_0 & 0x20) != 0 && arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__5 = this.lLVMLanguageReference_;
                    LLVMLanguage writeDouble_language__ = (LLVMLanguage)lLVMLanguageReference__5.get();
                    this.writeDouble(arg0Value, arg1Value_, writeDouble_language__);
                    return;
                }
                if ((state_0 & 0x40) != 0) {
                    TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__6 = this.lLVMLanguageReference_;
                    LLVMLanguage writePointer_language__ = (LLVMLanguage)lLVMLanguageReference__6.get();
                    this.writePointer(arg0Value, arg1Value, writePointer_language__, this.writePointer_nativeLibrary_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(long arg0Value, Object arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                LLVMLanguage writeI8_language__ = null;
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__7 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__7 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__7 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    writeI8_language__ = (LLVMLanguage)lLVMLanguageReference__7.get();
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.writeI8(arg0Value, arg1Value_, writeI8_language__);
                    return;
                }
                LLVMLanguage writeI16_language__ = null;
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__8 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__8 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__8 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    writeI16_language__ = (LLVMLanguage)lLVMLanguageReference__8.get();
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    this.writeI16(arg0Value, arg1Value_, writeI16_language__);
                    return;
                }
                LLVMLanguage writeI32_language__ = null;
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__9 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__9 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__9 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    writeI32_language__ = (LLVMLanguage)lLVMLanguageReference__9.get();
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    this.writeI32(arg0Value, arg1Value_, writeI32_language__);
                    return;
                }
                LLVMLanguage writeI64_language__ = null;
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__10 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__10 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__10 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    writeI64_language__ = (LLVMLanguage)lLVMLanguageReference__10.get();
                    this.writeI64_nativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3));
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    this.writeI64(arg0Value, arg1Value_, writeI64_language__, this.writeI64_nativeLibrary_);
                    return;
                }
                LLVMLanguage writeFloat_language__ = null;
                if (arg1Value instanceof Float) {
                    float arg1Value_ = ((Float)arg1Value).floatValue();
                    TruffleLanguage.LanguageReference lLVMLanguageReference__11 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__11 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__11 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    writeFloat_language__ = (LLVMLanguage)lLVMLanguageReference__11.get();
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    this.writeFloat(arg0Value, arg1Value_, writeFloat_language__);
                    return;
                }
                LLVMLanguage writeDouble_language__ = null;
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    TruffleLanguage.LanguageReference lLVMLanguageReference__12 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__12 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__12 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    writeDouble_language__ = (LLVMLanguage)lLVMLanguageReference__12.get();
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    this.writeDouble(arg0Value, arg1Value_, writeDouble_language__);
                    return;
                }
                LLVMLanguage writePointer_language__ = null;
                TruffleLanguage.LanguageReference lLVMLanguageReference__13 = this.lLVMLanguageReference_;
                if (lLVMLanguageReference__13 == null) {
                    this.lLVMLanguageReference_ = lLVMLanguageReference__13 = super.lookupLanguageReference(LLVMLanguage.class);
                }
                writePointer_language__ = (LLVMLanguage)lLVMLanguageReference__13.get();
                this.writePointer_nativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3));
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                this.writePointer(arg0Value, arg1Value, writePointer_language__, this.writePointer_nativeLibrary_);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMManagedAccessDefaults.LLVMMemoryWriteNode create() {
            return new LLVMMemoryWriteNodeGen();
        }

        public static LLVMManagedAccessDefaults.LLVMMemoryWriteNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.LLVMMemoryWriteNode.class)
        private static final class Uncached
        extends LLVMManagedAccessDefaults.LLVMMemoryWriteNode {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void executeWrite(long arg0Value, Object arg1Value) {
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    this.writeI8(arg0Value, arg1Value_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    this.writeI16(arg0Value, arg1Value_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    this.writeI32(arg0Value, arg1Value_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.writeI64(arg0Value, arg1Value_, (LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached());
                    return;
                }
                if (arg1Value instanceof Float) {
                    float arg1Value_ = ((Float)arg1Value).floatValue();
                    this.writeFloat(arg0Value, arg1Value_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    this.writeDouble(arg0Value, arg1Value_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                this.writePointer(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached());
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.ManagedWriteNode.class)
    static final class ManagedWriteNodeGen
    extends LLVMManagedAccessDefaults.ManagedWriteNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMInteropWriteNode interopWrite;
        @Node.Child
        private LLVMManagedAccessDefaults.FallbackWriteNode fallbackWrite;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMNativeLibrary pointer_nativeLibrary_;
        @Node.Child
        private LLVMManagedAccessDefaults.LLVMMemoryWriteNode pointer_memoryWriteNode_;
        @Node.Child
        private NativeTypeLibrary typedHandle_nativeTypes_;
        @Node.Child
        private LLVMNativeLibrary typedHandle_nativeLibrary_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode typedHandle_receiverNode_;
        @Node.Child
        private LLVMAsForeignNode typedHandle_asForeignNode_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile typedHandle_typedWriteProfile_;
        @Node.Child
        private NativeTypeLibrary value_nativeTypes_;
        @Node.Child
        private LLVMNativeLibrary value_natives_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile value_typedWriteProfile_;

        private ManagedWriteNodeGen() {
        }

        @Override
        void executeWrite(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage typedHandle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage pointer_language__;
                if ((state_0 & 1) != 0 && this.pointer_nativeLibrary_.isPointer(arg0Value) && !LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(pointer_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), this.pointer_nativeLibrary_, arg0Value)) {
                    LLVMManagedAccessDefaults.ManagedWriteNode.doPointer(arg0Value, arg1Value, arg2Value, arg3Value, pointer_language__, this.pointer_nativeLibrary_, this.pointer_memoryWriteNode_);
                    return;
                }
                if ((state_0 & 2) != 0 && this.typedHandle_nativeLibrary_.isPointer(arg0Value) && LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(typedHandle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), this.typedHandle_nativeLibrary_, arg0Value)) {
                    LLVMManagedAccessDefaults.ManagedWriteNode.doTypedHandle(arg0Value, arg1Value, arg2Value, arg3Value, this.typedHandle_nativeTypes_, this.interopWrite, typedHandle_language__, this.typedHandle_nativeLibrary_, this.typedHandle_receiverNode_, this.typedHandle_asForeignNode_, this.fallbackWrite, this.typedHandle_typedWriteProfile_);
                    return;
                }
                if ((state_0 & 4) != 0 && !this.value_natives_.isPointer(arg0Value)) {
                    LLVMManagedAccessDefaults.ManagedWriteNode.doValue(arg0Value, arg1Value, arg2Value, arg3Value, this.value_nativeTypes_, this.interopWrite, this.value_natives_, this.fallbackWrite, this.value_typedWriteProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private void executeAndSpecialize(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                LLVMNativeLibrary value_natives__;
                LLVMLanguage pointer_language__ = null;
                LLVMNativeLibrary pointer_nativeLibrary__ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3));
                if (pointer_nativeLibrary__.isPointer(arg0Value)) {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__2 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__2 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(pointer_language__ = (LLVMLanguage)lLVMLanguageReference__2.get(), pointer_nativeLibrary__, arg0Value)) {
                        this.pointer_nativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)pointer_nativeLibrary__);
                        this.pointer_memoryWriteNode_ = (LLVMManagedAccessDefaults.LLVMMemoryWriteNode)super.insert((Node)LLVMMemoryWriteNodeGen.create());
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMManagedAccessDefaults.ManagedWriteNode.doPointer(arg0Value, arg1Value, arg2Value, arg3Value, pointer_language__, pointer_nativeLibrary__, this.pointer_memoryWriteNode_);
                        return;
                    }
                }
                LLVMLanguage typedHandle_language__ = null;
                LLVMNativeLibrary typedHandle_nativeLibrary__ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3));
                if (typedHandle_nativeLibrary__.isPointer(arg0Value)) {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__3 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__3 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__3 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(typedHandle_language__ = (LLVMLanguage)lLVMLanguageReference__3.get(), typedHandle_nativeLibrary__, arg0Value)) {
                        this.typedHandle_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.createDispatched(3));
                        if (this.interopWrite == null) {
                            this.interopWrite = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                        }
                        this.typedHandle_nativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)typedHandle_nativeLibrary__);
                        this.typedHandle_receiverNode_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.typedHandle_asForeignNode_ = (LLVMAsForeignNode)super.insert((Node)LLVMAsForeignNode.create());
                        if (this.fallbackWrite == null) {
                            this.fallbackWrite = (LLVMManagedAccessDefaults.FallbackWriteNode)super.insert((Node)FallbackWriteNodeGen.create());
                        }
                        this.typedHandle_typedWriteProfile_ = ConditionProfile.createBinaryProfile();
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMManagedAccessDefaults.ManagedWriteNode.doTypedHandle(arg0Value, arg1Value, arg2Value, arg3Value, this.typedHandle_nativeTypes_, this.interopWrite, typedHandle_language__, typedHandle_nativeLibrary__, this.typedHandle_receiverNode_, this.typedHandle_asForeignNode_, this.fallbackWrite, this.typedHandle_typedWriteProfile_);
                        return;
                    }
                }
                if (!(value_natives__ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3))).isPointer(arg0Value)) {
                    this.value_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.createDispatched(3));
                    if (this.interopWrite == null) {
                        this.interopWrite = (LLVMInteropWriteNode)super.insert((Node)LLVMInteropWriteNode.create());
                    }
                    this.value_natives_ = (LLVMNativeLibrary)super.insert((Node)value_natives__);
                    if (this.fallbackWrite == null) {
                        this.fallbackWrite = (LLVMManagedAccessDefaults.FallbackWriteNode)super.insert((Node)FallbackWriteNodeGen.create());
                    }
                    this.value_typedWriteProfile_ = ConditionProfile.createBinaryProfile();
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.ManagedWriteNode.doValue(arg0Value, arg1Value, arg2Value, arg3Value, this.value_nativeTypes_, this.interopWrite, value_natives__, this.fallbackWrite, this.value_typedWriteProfile_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMManagedAccessDefaults.ManagedWriteNode create() {
            return new ManagedWriteNodeGen();
        }

        public static LLVMManagedAccessDefaults.ManagedWriteNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.ManagedWriteNode.class)
        private static final class Uncached
        extends LLVMManagedAccessDefaults.ManagedWriteNode {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void executeWrite(Object arg0Value, long arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
                if (((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached()).isPointer(arg0Value) && !LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), arg0Value)) {
                    LLVMManagedAccessDefaults.ManagedWriteNode.doPointer(arg0Value, arg1Value, arg2Value, arg3Value, (LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), LLVMMemoryWriteNodeGen.getUncached());
                    return;
                }
                if (((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached()).isPointer(arg0Value) && LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), arg0Value)) {
                    LLVMManagedAccessDefaults.ManagedWriteNode.doTypedHandle(arg0Value, arg1Value, arg2Value, arg3Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(), LLVMInteropWriteNodeGen.getUncached(), (LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), LLVMDerefHandleGetReceiverNodeGen.getUncached(), LLVMAsForeignNode.getUncached(), FallbackWriteNodeGen.getUncached(), ConditionProfile.getUncached());
                    return;
                }
                if (!((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached()).isPointer(arg0Value)) {
                    LLVMManagedAccessDefaults.ManagedWriteNode.doValue(arg0Value, arg1Value, arg2Value, arg3Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(), LLVMInteropWriteNodeGen.getUncached(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), FallbackWriteNodeGen.getUncached(), ConditionProfile.getUncached());
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.ManagedReadNode.class)
    static final class ManagedReadNodeGen
    extends LLVMManagedAccessDefaults.ManagedReadNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMInteropReadNode read;
        @Node.Child
        private LLVMManagedAccessDefaults.FallbackReadNode fallbackRead;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
        @Node.Child
        private LLVMNativeLibrary pointer_nativeLibrary_;
        @CompilerDirectives.CompilationFinal
        private ValueProfile pointer_typeProfile_;
        @Node.Child
        private NativeTypeLibrary handle_nativeTypes_;
        @Node.Child
        private LLVMNativeLibrary handle_natives_;
        @Node.Child
        private LLVMDerefHandleGetReceiverNode handle_receiverNode_;
        @Node.Child
        private LLVMAsForeignNode handle_asForeignNode_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile handle_typedReadProfile_;
        @Node.Child
        private NativeTypeLibrary value_nativeTypes_;
        @Node.Child
        private LLVMNativeLibrary value_natives_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile value_typedReadProfile_;

        private ManagedReadNodeGen() {
        }

        @Override
        Object executeRead(Object arg0Value, long arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__1;
                LLVMLanguage handle_language__;
                TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference__;
                LLVMLanguage pointer_language__;
                if ((state_0 & 1) != 0 && this.pointer_nativeLibrary_.isPointer(arg0Value) && !LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(pointer_language__ = (LLVMLanguage)(lLVMLanguageReference__ = this.lLVMLanguageReference_).get(), this.pointer_nativeLibrary_, arg0Value)) {
                    return this.doPointer(arg0Value, arg1Value, arg2Value, pointer_language__, this.pointer_nativeLibrary_, this.pointer_typeProfile_);
                }
                if ((state_0 & 2) != 0 && this.handle_natives_.isPointer(arg0Value) && LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(handle_language__ = (LLVMLanguage)(lLVMLanguageReference__1 = this.lLVMLanguageReference_).get(), this.handle_natives_, arg0Value)) {
                    return LLVMManagedAccessDefaults.ManagedReadNode.doHandle(arg0Value, arg1Value, arg2Value, this.handle_nativeTypes_, this.read, handle_language__, this.handle_natives_, this.handle_receiverNode_, this.handle_asForeignNode_, this.fallbackRead, this.handle_typedReadProfile_);
                }
                if ((state_0 & 4) != 0 && !this.value_natives_.isPointer(arg0Value)) {
                    return LLVMManagedAccessDefaults.ManagedReadNode.doValue(arg0Value, arg1Value, arg2Value, this.read, this.value_nativeTypes_, this.value_natives_, this.fallbackRead, this.value_typedReadProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, long arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                LLVMNativeLibrary value_natives__;
                LLVMLanguage pointer_language__ = null;
                LLVMNativeLibrary pointer_nativeLibrary__ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3));
                if (pointer_nativeLibrary__.isPointer(arg0Value)) {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__2 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__2 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__2 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (!LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(pointer_language__ = (LLVMLanguage)lLVMLanguageReference__2.get(), pointer_nativeLibrary__, arg0Value)) {
                        this.pointer_nativeLibrary_ = (LLVMNativeLibrary)super.insert((Node)pointer_nativeLibrary__);
                        this.pointer_typeProfile_ = ValueProfile.createIdentityProfile();
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doPointer(arg0Value, arg1Value, arg2Value, pointer_language__, pointer_nativeLibrary__, this.pointer_typeProfile_);
                        return object;
                    }
                }
                LLVMLanguage handle_language__ = null;
                LLVMNativeLibrary handle_natives__ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3));
                if (handle_natives__.isPointer(arg0Value)) {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__3 = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__3 == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__3 = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    if (LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle(handle_language__ = (LLVMLanguage)lLVMLanguageReference__3.get(), handle_natives__, arg0Value)) {
                        this.handle_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.createDispatched(3));
                        if (this.read == null) {
                            this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                        }
                        this.handle_natives_ = (LLVMNativeLibrary)super.insert((Node)handle_natives__);
                        this.handle_receiverNode_ = (LLVMDerefHandleGetReceiverNode)super.insert((Node)LLVMDerefHandleGetReceiverNodeGen.create());
                        this.handle_asForeignNode_ = (LLVMAsForeignNode)super.insert((Node)LLVMAsForeignNode.create());
                        if (this.fallbackRead == null) {
                            this.fallbackRead = (LLVMManagedAccessDefaults.FallbackReadNode)super.insert((Node)LLVMManagedAccessDefaults.FallbackReadNode.create());
                        }
                        this.handle_typedReadProfile_ = ConditionProfile.createBinaryProfile();
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = LLVMManagedAccessDefaults.ManagedReadNode.doHandle(arg0Value, arg1Value, arg2Value, this.handle_nativeTypes_, this.read, handle_language__, handle_natives__, this.handle_receiverNode_, this.handle_asForeignNode_, this.fallbackRead, this.handle_typedReadProfile_);
                        return object;
                    }
                }
                if (!(value_natives__ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.createDispatched(3))).isPointer(arg0Value)) {
                    if (this.read == null) {
                        this.read = (LLVMInteropReadNode)super.insert((Node)LLVMInteropReadNode.create());
                    }
                    this.value_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.createDispatched(3));
                    this.value_natives_ = (LLVMNativeLibrary)super.insert((Node)value_natives__);
                    if (this.fallbackRead == null) {
                        this.fallbackRead = (LLVMManagedAccessDefaults.FallbackReadNode)super.insert((Node)LLVMManagedAccessDefaults.FallbackReadNode.create());
                    }
                    this.value_typedReadProfile_ = ConditionProfile.createBinaryProfile();
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMManagedAccessDefaults.ManagedReadNode.doValue(arg0Value, arg1Value, arg2Value, this.read, this.value_nativeTypes_, value_natives__, this.fallbackRead, this.value_typedReadProfile_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMManagedAccessDefaults.ManagedReadNode create() {
            return new ManagedReadNodeGen();
        }

        public static LLVMManagedAccessDefaults.ManagedReadNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.ManagedReadNode.class)
        private static final class Uncached
        extends LLVMManagedAccessDefaults.ManagedReadNode {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object executeRead(Object arg0Value, long arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
                if (((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached()).isPointer(arg0Value) && !LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), arg0Value)) {
                    return this.doPointer(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), ValueProfile.getUncached());
                }
                if (((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached()).isPointer(arg0Value) && LLVMManagedAccessDefaults.ManagedAccessNode.isWrappedAutoDerefHandle((LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), arg0Value)) {
                    return LLVMManagedAccessDefaults.ManagedReadNode.doHandle(arg0Value, arg1Value, arg2Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(), LLVMInteropReadNodeGen.getUncached(), (LLVMLanguage)this.lLVMLanguageReference_.get(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), LLVMDerefHandleGetReceiverNodeGen.getUncached(), LLVMAsForeignNode.getUncached(), LLVMManagedAccessDefaults.FallbackReadNode.createUncached(), ConditionProfile.getUncached());
                }
                if (!((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached()).isPointer(arg0Value)) {
                    return LLVMManagedAccessDefaults.ManagedReadNode.doValue(arg0Value, arg1Value, arg2Value, LLVMInteropReadNodeGen.getUncached(), (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(), LLVMManagedAccessDefaults.FallbackReadNode.createUncached(), ConditionProfile.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }
}

