/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaultsFactory;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
final class FallbackReadGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private FallbackReadGen() {
    }

    static {
        LibraryExport.register(LLVMManagedAccessDefaults.FallbackRead.class, (LibraryExport[])new LibraryExport[]{new LLVMManagedReadLibraryExports()});
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, Object.class, true);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object arg0Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.isReadable(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, LLVMToPointerNodeGen.getUncached(), LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.FallbackRead.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private LLVMManagedAccessDefaults.ManagedReadNode read;
            @Node.Child
            private LLVMToPointerNode readPointerNode__toPointer_;

            protected Cached(Object receiver) {
                this.receiverInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiver));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || this.dynamicDispatch_.dispatch(receiver) != this.dynamicDispatchTarget_) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            @Override
            public boolean isReadable(Object arg0Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                InteropLibrary isReadableNode__interop__ = this.receiverInteropLibrary_;
                return LLVMManagedAccessDefaults.FallbackRead.isReadable(arg0Value, isReadableNode__interop__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public byte readI8(Object arg0Value, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte readI8Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMManagedAccessDefaults.ManagedReadNode)super.insert((Node)LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.create());
                    }
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    byte by = LLVMManagedAccessDefaults.FallbackRead.readI8(arg0Value, arg1Value, this.read);
                    return by;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public short readI16(Object arg0Value, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private short readI16Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMManagedAccessDefaults.ManagedReadNode)super.insert((Node)LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.create());
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    short s = LLVMManagedAccessDefaults.FallbackRead.readI16(arg0Value, arg1Value, this.read);
                    return s;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int readI32(Object arg0Value, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int readI32Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMManagedAccessDefaults.ManagedReadNode)super.insert((Node)LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.create());
                    }
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = LLVMManagedAccessDefaults.FallbackRead.readI32(arg0Value, arg1Value, this.read);
                    return n;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readGenericI64(Object arg0Value, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readGenericI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readGenericI64Node_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMManagedAccessDefaults.ManagedReadNode)super.insert((Node)LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.create());
                    }
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMManagedAccessDefaults.FallbackRead.readGenericI64(arg0Value, arg1Value, this.read);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float readFloat(Object arg0Value, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private float readFloatNode_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMManagedAccessDefaults.ManagedReadNode)super.insert((Node)LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.create());
                    }
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    float f = LLVMManagedAccessDefaults.FallbackRead.readFloat(arg0Value, arg1Value, this.read);
                    return f;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double readDouble(Object arg0Value, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private double readDoubleNode_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.read == null) {
                        this.read = (LLVMManagedAccessDefaults.ManagedReadNode)super.insert((Node)LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.create());
                    }
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    double d = LLVMManagedAccessDefaults.FallbackRead.readDouble(arg0Value, arg1Value, this.read);
                    return d;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value, long arg1Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0) {
                    return LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, this.readPointerNode__toPointer_, this.read);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LLVMPointer readPointerNode_AndSpecialize(Object arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.readPointerNode__toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                    if (this.read == null) {
                        this.read = (LLVMManagedAccessDefaults.ManagedReadNode)super.insert((Node)LLVMManagedAccessDefaultsFactory.ManagedReadNodeGen.create());
                    }
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMPointer lLVMPointer = LLVMManagedAccessDefaults.FallbackRead.readPointer(arg0Value, arg1Value, this.readPointerNode__toPointer_, this.read);
                    return lLVMPointer;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

