/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
final class DefaultLibraryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private DefaultLibraryGen() {
    }

    static {
        LibraryExport.register(LLVMNativeLibraryDefaults.DefaultLibrary.class, (LibraryExport[])new LibraryExport[]{new LLVMNativeLibraryExports()});
    }

    @GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, Object.class, true);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
        private static final class Uncached
        extends LLVMNativeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doPointer(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doOther(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doPointer(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), BranchProfile.getUncached());
                }
                if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doNullCheck(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), BranchProfile.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object arg0Value) {
                assert (this.accepts(arg0Value)) : "Invalid library usage. Library does not accept given receiver.";
                if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNull(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNull(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNull(arg0Value)) {
                    return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNotNull(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), BranchProfile.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }
        }

        @GeneratedBy(value=LLVMNativeLibraryDefaults.DefaultLibrary.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            @Node.Child
            private InteropLibrary receiverInteropLibrary_;
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile exception;

            protected Cached(Object receiver) {
                this.receiverInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiver));
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                if (!this.dynamicDispatch_.accepts(receiver) || this.dynamicDispatch_.dispatch(receiver) != this.dynamicDispatchTarget_) {
                    return false;
                }
                return this.receiverInteropLibrary_.accepts(receiver);
            }

            @Override
            public boolean isPointer(Object arg0Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    InteropLibrary isPointer_other_interop__;
                    InteropLibrary isPointer_pointer_interop__;
                    if ((state_0 & 1) != 0 && (isPointer_pointer_interop__ = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doPointer(arg0Value, isPointer_pointer_interop__);
                    }
                    if ((state_0 & 2) != 0 && !(isPointer_other_interop__ = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doOther(arg0Value, isPointer_other_interop__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isPointerAndSpecialize(arg0Value);
            }

            private boolean isPointerAndSpecialize(Object arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    InteropLibrary isPointer_pointer_interop__ = null;
                    isPointer_pointer_interop__ = this.receiverInteropLibrary_;
                    if (isPointer_pointer_interop__.isPointer(arg0Value)) {
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doPointer(arg0Value, isPointer_pointer_interop__);
                        return bl;
                    }
                    InteropLibrary isPointer_other_interop__ = null;
                    isPointer_other_interop__ = this.receiverInteropLibrary_;
                    if (!isPointer_other_interop__.isPointer(arg0Value)) {
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = LLVMNativeLibraryDefaults.DefaultLibrary.IsPointer.doOther(arg0Value, isPointer_other_interop__);
                        return bl;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public long asPointer(Object arg0Value) throws UnsupportedMessageException {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    InteropLibrary asPointer_nullCheck_interop__;
                    InteropLibrary asPointer_pointer_interop__;
                    if ((state_0 & 4) != 0 && (asPointer_pointer_interop__ = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doPointer(arg0Value, asPointer_pointer_interop__, this.exception);
                    }
                    if ((state_0 & 8) != 0 && !(asPointer_nullCheck_interop__ = this.receiverInteropLibrary_).isPointer(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doNullCheck(arg0Value, asPointer_nullCheck_interop__, this.exception);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asPointerAndSpecialize(arg0Value);
            }

            private long asPointerAndSpecialize(Object arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    InteropLibrary asPointer_pointer_interop__ = null;
                    asPointer_pointer_interop__ = this.receiverInteropLibrary_;
                    if (asPointer_pointer_interop__.isPointer(arg0Value)) {
                        if (this.exception == null) {
                            this.exception = BranchProfile.create();
                        }
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        long l = LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doPointer(arg0Value, asPointer_pointer_interop__, this.exception);
                        return l;
                    }
                    InteropLibrary asPointer_nullCheck_interop__ = null;
                    asPointer_nullCheck_interop__ = this.receiverInteropLibrary_;
                    if (!asPointer_nullCheck_interop__.isPointer(arg0Value)) {
                        if (this.exception == null) {
                            this.exception = BranchProfile.create();
                        }
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        long l = LLVMNativeLibraryDefaults.DefaultLibrary.AsPointer.doNullCheck(arg0Value, asPointer_nullCheck_interop__, this.exception);
                        return l;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LLVMNativePointer toNativePointer(Object arg0Value) {
                assert (this.dynamicDispatch_.accepts(arg0Value) && this.dynamicDispatch_.dispatch(arg0Value) == this.dynamicDispatchTarget_) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                int state_0 = this.state_0_;
                if ((state_0 & 0x30) != 0) {
                    InteropLibrary toNativePointer_notNull_interop__;
                    InteropLibrary toNativePointer_null_interop__;
                    if ((state_0 & 0x10) != 0 && (toNativePointer_null_interop__ = this.receiverInteropLibrary_).isNull(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNull(arg0Value, toNativePointer_null_interop__);
                    }
                    if ((state_0 & 0x20) != 0 && !(toNativePointer_notNull_interop__ = this.receiverInteropLibrary_).isNull(arg0Value)) {
                        return LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNotNull(arg0Value, toNativePointer_notNull_interop__, this.exception);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.toNativePointerAndSpecialize(arg0Value);
            }

            private LLVMNativePointer toNativePointerAndSpecialize(Object arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    InteropLibrary toNativePointer_null_interop__ = null;
                    toNativePointer_null_interop__ = this.receiverInteropLibrary_;
                    if (toNativePointer_null_interop__.isNull(arg0Value)) {
                        this.state_0_ = state_0 |= 0x10;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNull(arg0Value, toNativePointer_null_interop__);
                        return lLVMNativePointer;
                    }
                    InteropLibrary toNativePointer_notNull_interop__ = null;
                    toNativePointer_notNull_interop__ = this.receiverInteropLibrary_;
                    if (!toNativePointer_notNull_interop__.isNull(arg0Value)) {
                        if (this.exception == null) {
                            this.exception = BranchProfile.create();
                        }
                        this.state_0_ = state_0 |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        LLVMNativePointer lLVMNativePointer = LLVMNativeLibraryDefaults.DefaultLibrary.ToNativePointer.doNotNull(arg0Value, toNativePointer_notNull_interop__, this.exception);
                        return lLVMNativePointer;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

