/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMNativeConvertNode.class)
public final class LLVMNativeConvertNodeFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=LLVMNativeConvertNode.I1FromNativeToLLVMNode.class)
    static final class I1FromNativeToLLVMNodeGen
    extends LLVMNativeConvertNode.I1FromNativeToLLVMNode {
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private I1FromNativeToLLVMNodeGen() {
        }

        @Override
        public Object executeConvert(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return this.convert(arg0Value_);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return this.convert(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_0_ = state_0 |= 1;
                return this.convert(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_0_ = state_0 |= 2;
                return this.convert(arg0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMNativeConvertNode.I1FromNativeToLLVMNode create() {
            return new I1FromNativeToLLVMNodeGen();
        }
    }

    @GeneratedBy(value=LLVMNativeConvertNode.Id.class)
    protected static final class IdNodeGen
    extends LLVMNativeConvertNode.Id {
        private IdNodeGen() {
        }

        @Override
        public Object executeConvert(Object arg0Value) {
            return this.doConvert(arg0Value);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMNativeConvertNode.Id create() {
            return new IdNodeGen();
        }
    }

    @GeneratedBy(value=LLVMNativeConvertNode.NativeToAddress.class)
    protected static final class NativeToAddressNodeGen
    extends LLVMNativeConvertNode.NativeToAddress {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private PointerData pointer_cache;
        @Node.Child
        private FunctionData function_cache;
        @Node.Child
        private Generic0Data generic0_cache;

        private NativeToAddressNodeGen() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        public Object executeConvert(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return this.doLong(arg0Value_);
            }
            if ((state_0 & 0x1E) != 0) {
                if ((state_0 & 2) != 0) {
                    PointerData s2_ = this.pointer_cache;
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arg0Value) && s2_.interop_.isPointer(arg0Value)) {
                            try {
                                return this.doPointer(arg0Value, s2_.interop_);
                            }
                            catch (UnsupportedMessageException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                Lock lock = this.getLock();
                                lock.lock();
                                try {
                                    this.exclude_ |= 1;
                                    this.state_0_ &= 0xFFFFFFFD;
                                    this.pointer_cache = null;
                                }
                                finally {
                                    lock.unlock();
                                }
                                return this.executeAndSpecialize(arg0Value);
                            }
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0) {
                    FunctionData s3_ = this.function_cache;
                    while (s3_ != null) {
                        if (s3_.interop_.accepts(arg0Value) && !s3_.interop_.isPointer(arg0Value)) {
                            return this.doFunction(arg0Value, s3_.interop_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 8) != 0) {
                    Generic0Data s4_ = this.generic0_cache;
                    while (s4_ != null) {
                        if (s4_.interop_.accepts(arg0Value)) {
                            return this.doGeneric(arg0Value, s4_.interop_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0x10) != 0) {
                    return this.generic1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object generic1Boundary(int state_0, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary generic1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                LLVMPointer lLVMPointer = this.doGeneric(arg0Value, generic1_interop__);
                return lLVMPointer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private LLVMPointer executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                LLVMPointer lLVMPointer;
                Object interop__1;
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMNativePointer lLVMNativePointer = this.doLong(arg0Value_);
                    return lLVMNativePointer;
                }
                if ((exclude & 1) == 0) {
                    Object interop__;
                    int count2_ = 0;
                    PointerData s2_ = this.pointer_cache;
                    if ((state_0 & 2) != 0) {
                        while (!(s2_ == null || s2_.interop_.accepts(arg0Value) && s2_.interop_.isPointer(arg0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg0Value))).isPointer(arg0Value) && count2_ < 3) {
                        s2_ = (PointerData)super.insert((Node)new PointerData(this.pointer_cache));
                        s2_.interop_ = s2_.insertAccessor(interop__);
                        this.pointer_cache = s2_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        try {
                            lock.unlock();
                            hasLock = false;
                            interop__ = this.doPointer(arg0Value, s2_.interop_);
                            return interop__;
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            lock.lock();
                            try {
                                this.exclude_ |= 1;
                                this.state_0_ &= 0xFFFFFFFD;
                                this.pointer_cache = null;
                            }
                            finally {
                                lock.unlock();
                            }
                            LLVMPointer lLVMPointer2 = this.executeAndSpecialize(arg0Value);
                            if (hasLock) {
                                lock.unlock();
                            }
                            return lLVMPointer2;
                        }
                    }
                }
                if ((exclude & 2) == 0) {
                    int count3_ = 0;
                    FunctionData s3_ = this.function_cache;
                    if ((state_0 & 4) != 0) {
                        while (s3_ != null && (!s3_.interop_.accepts(arg0Value) || s3_.interop_.isPointer(arg0Value))) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && !(interop__1 = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg0Value))).isPointer(arg0Value) && count3_ < 3) {
                        s3_ = (FunctionData)super.insert((Node)new FunctionData(this.function_cache));
                        s3_.interop_ = s3_.insertAccessor(interop__1);
                        this.function_cache = s3_;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        interop__1 = this.doFunction(arg0Value, s3_.interop_);
                        return interop__1;
                    }
                }
                if ((exclude & 4) == 0) {
                    int count4_ = 0;
                    Generic0Data s4_ = this.generic0_cache;
                    if ((state_0 & 8) != 0) {
                        while (s4_ != null && !s4_.interop_.accepts(arg0Value)) {
                            s4_ = s4_.next_;
                            ++count4_;
                        }
                    }
                    if (s4_ == null && count4_ < 3) {
                        s4_ = (Generic0Data)super.insert((Node)new Generic0Data(this.generic0_cache));
                        s4_.interop_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                        this.generic0_cache = s4_;
                        this.exclude_ = exclude |= 3;
                        this.pointer_cache = null;
                        this.function_cache = null;
                        state_0 &= 0xFFFFFFF9;
                        this.state_0_ = state_0 |= 8;
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        interop__1 = this.doGeneric(arg0Value, s4_.interop_);
                        return interop__1;
                    }
                }
                InteropLibrary generic1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    generic1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    this.exclude_ = exclude |= 7;
                    this.pointer_cache = null;
                    this.function_cache = null;
                    this.generic0_cache = null;
                    state_0 &= 0xFFFFFFF1;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    lLVMPointer = this.doGeneric(arg0Value, generic1_interop__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                    {
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                }
                encapsulating_.set(prev_);
                return lLVMPointer;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                PointerData s2_ = this.pointer_cache;
                FunctionData s3_ = this.function_cache;
                Generic0Data s4_ = this.generic0_cache;
                if (!(s2_ != null && s2_.next_ != null || s3_ != null && s3_.next_ != null || s4_ != null && s4_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMNativeConvertNode.NativeToAddress create() {
            return new NativeToAddressNodeGen();
        }

        @GeneratedBy(value=LLVMNativeConvertNode.NativeToAddress.class)
        private static final class Generic0Data
        extends Node {
            @Node.Child
            Generic0Data next_;
            @Node.Child
            InteropLibrary interop_;

            Generic0Data(Generic0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMNativeConvertNode.NativeToAddress.class)
        private static final class FunctionData
        extends Node {
            @Node.Child
            FunctionData next_;
            @Node.Child
            InteropLibrary interop_;

            FunctionData(FunctionData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMNativeConvertNode.NativeToAddress.class)
        private static final class PointerData
        extends Node {
            @Node.Child
            PointerData next_;
            @Node.Child
            InteropLibrary interop_;

            PointerData(PointerData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

