/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMForeignWriteNode.class)
public final class LLVMForeignWriteNodeGen
extends LLVMForeignWriteNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private ValueData value_cache;

    private LLVMForeignWriteNodeGen() {
    }

    @Override
    @ExplodeLoop
    public void execute(LLVMPointer arg0Value, LLVMInteropType arg1Value, Object arg2Value) throws UnsupportedMessageException {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            LLVMInteropType arg1Value_;
            if ((state_0 & 1) != 0 && arg1Value instanceof LLVMInteropType.Value) {
                arg1Value_ = (LLVMInteropType.Value)arg1Value;
                ValueData s1_ = this.value_cache;
                while (s1_ != null) {
                    if (arg1Value_.kind == s1_.cachedKind_) {
                        LLVMForeignWriteNode.doValue(arg0Value, arg1Value_, arg2Value, s1_.cachedKind_, s1_.store_, s1_.toLLVM_);
                        return;
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0 && arg1Value instanceof LLVMInteropType.Structured) {
                arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                LLVMForeignWriteNode.doStructured(arg0Value, (LLVMInteropType.Structured)arg1Value_, arg2Value);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private void executeAndSpecialize(LLVMPointer arg0Value, LLVMInteropType arg1Value, Object arg2Value) throws UnsupportedMessageException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            LLVMInteropType arg1Value_;
            if (arg1Value instanceof LLVMInteropType.Value) {
                arg1Value_ = (LLVMInteropType.Value)arg1Value;
                int count1_ = 0;
                ValueData s1_ = this.value_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null && arg1Value_.kind != s1_.cachedKind_) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < LLVMForeignWriteNode.VALUE_KIND_COUNT) {
                    s1_ = (ValueData)super.insert((Node)new ValueData(this.value_cache));
                    s1_.cachedKind_ = arg1Value_.kind;
                    s1_.store_ = s1_.insertAccessor(LLVMOffsetStoreNode.create(s1_.cachedKind_));
                    s1_.toLLVM_ = s1_.insertAccessor(this.createForeignToLLVM((LLVMInteropType.Value)arg1Value_));
                    this.value_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    LLVMForeignWriteNode.doValue(arg0Value, arg1Value_, arg2Value, s1_.cachedKind_, s1_.store_, s1_.toLLVM_);
                    return;
                }
            }
            if (arg1Value instanceof LLVMInteropType.Structured) {
                arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                LLVMForeignWriteNode.doStructured(arg0Value, (LLVMInteropType.Structured)arg1Value_, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ValueData s1_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.value_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMForeignWriteNode create() {
        return new LLVMForeignWriteNodeGen();
    }

    public static LLVMForeignWriteNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMForeignWriteNode.class)
    private static final class Uncached
    extends LLVMForeignWriteNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void execute(LLVMPointer arg0Value, LLVMInteropType arg1Value, Object arg2Value) throws UnsupportedMessageException {
            if (arg1Value instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value arg1Value_ = (LLVMInteropType.Value)arg1Value;
                LLVMForeignWriteNode.doValue(arg0Value, arg1Value_, arg2Value, arg1Value_.kind, LLVMOffsetStoreNode.getUncached(arg1Value_.kind), ForeignToLLVM.getUncached());
                return;
            }
            if (arg1Value instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured arg1Value_ = (LLVMInteropType.Structured)arg1Value;
                LLVMForeignWriteNode.doStructured(arg0Value, arg1Value_, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMForeignWriteNode.class)
    private static final class ValueData
    extends Node {
        @Node.Child
        ValueData next_;
        @CompilerDirectives.CompilationFinal
        LLVMInteropType.ValueKind cachedKind_;
        @Node.Child
        LLVMOffsetStoreNode store_;
        @Node.Child
        ForeignToLLVM toLLVM_;

        ValueData(ValueData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

