/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToPointer.class)
public final class ToPointerNodeGen
extends ToPointer {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);
    @Node.Child
    private ToPointer.Dummy child0_;
    @Node.Child
    private ToPointer.InteropTypeNode child1_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private NativeTypeLibrary fromTypedTruffleObjectNoAttachedType_nativeTypes_;
    @Node.Child
    private LLVMAsForeignLibrary fromTypedTruffleObjectNoAttachedType_foreigns_;
    @Node.Child
    private NativeTypeLibrary fromNonTypedTruffleObject_nativeTypes_;
    @Node.Child
    private LLVMAsForeignLibrary fromNonTypedTruffleObject_foreigns_;

    private ToPointerNodeGen(ToPointer.Dummy child0, ToPointer.InteropTypeNode child1) {
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeWithForeignToLLVMType(Object child0Value, LLVMInteropType.Structured child1Value, ForeignToLLVM.ForeignToLLVMType ftlType) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value);
            }
            if ((state_0 & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value);
            }
            if ((state_0 & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value);
            }
            if ((state_0 & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value);
            }
            if ((state_0 & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value);
            }
            if ((state_0 & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value);
            }
            if ((state_0 & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value);
            }
            if ((state_0 & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value);
            }
            if ((state_0 & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value);
            }
            if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value);
            }
            if ((state_0 & 0xC00) != 0) {
                if ((state_0 & 0x400) != 0 && this.fromTypedTruffleObjectNoAttachedType_foreigns_.isForeign(child0Value) && (this.fromTypedTruffleObjectNoAttachedType_nativeTypes_.hasNativeType(child0Value) || child1Value == null)) {
                    return this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, this.fromTypedTruffleObjectNoAttachedType_nativeTypes_, this.fromTypedTruffleObjectNoAttachedType_foreigns_);
                }
                if ((state_0 & 0x800) != 0 && this.fromNonTypedTruffleObject_foreigns_.isForeign(child0Value) && !this.fromNonTypedTruffleObject_nativeTypes_.hasNativeType(child0Value) && child1Value != null) {
                    return this.fromNonTypedTruffleObject(child0Value, child1Value, this.fromNonTypedTruffleObject_nativeTypes_, this.fromNonTypedTruffleObject_foreigns_);
                }
            }
            if ((state_0 & 0x1000) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value);
            }
            if ((state_0 & 0x2000) != 0 && child0Value instanceof LLVMInteropType) {
                LLVMInteropType child0Value_ = (LLVMInteropType)child0Value;
                return this.fromInteropType(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithType(Object child0Value, LLVMInteropType.Structured child1Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value);
            }
            if ((state_0 & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value);
            }
            if ((state_0 & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value);
            }
            if ((state_0 & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value);
            }
            if ((state_0 & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value);
            }
            if ((state_0 & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value);
            }
            if ((state_0 & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value);
            }
            if ((state_0 & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value);
            }
            if ((state_0 & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value);
            }
            if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value);
            }
            if ((state_0 & 0xC00) != 0) {
                if ((state_0 & 0x400) != 0 && this.fromTypedTruffleObjectNoAttachedType_foreigns_.isForeign(child0Value) && (this.fromTypedTruffleObjectNoAttachedType_nativeTypes_.hasNativeType(child0Value) || child1Value == null)) {
                    return this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, this.fromTypedTruffleObjectNoAttachedType_nativeTypes_, this.fromTypedTruffleObjectNoAttachedType_foreigns_);
                }
                if ((state_0 & 0x800) != 0 && this.fromNonTypedTruffleObject_foreigns_.isForeign(child0Value) && !this.fromNonTypedTruffleObject_nativeTypes_.hasNativeType(child0Value) && child1Value != null) {
                    return this.fromNonTypedTruffleObject(child0Value, child1Value, this.fromNonTypedTruffleObject_nativeTypes_, this.fromNonTypedTruffleObject_foreigns_);
                }
            }
            if ((state_0 & 0x1000) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value);
            }
            if ((state_0 & 0x2000) != 0 && child0Value instanceof LLVMInteropType) {
                LLVMInteropType child0Value_ = (LLVMInteropType)child0Value;
                return this.fromInteropType(child0Value_, child1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value);
    }

    @Override
    public Object executeWithTarget(Object child0Value) {
        int state_0 = this.state_0_;
        LLVMInteropType.Structured child1Value_ = this.child1_.execute();
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && child0Value instanceof Integer) {
                int child0Value_ = (Integer)child0Value;
                return this.fromInt(child0Value_, child1Value_);
            }
            if ((state_0 & 2) != 0 && child0Value instanceof Character) {
                char child0Value_ = ((Character)child0Value).charValue();
                return this.fromChar(child0Value_, child1Value_);
            }
            if ((state_0 & 4) != 0 && child0Value instanceof Long) {
                long child0Value_ = (Long)child0Value;
                return this.fromLong(child0Value_, child1Value_);
            }
            if ((state_0 & 8) != 0 && child0Value instanceof Byte) {
                byte child0Value_ = (Byte)child0Value;
                return this.fromByte(child0Value_, child1Value_);
            }
            if ((state_0 & 0x10) != 0 && child0Value instanceof Short) {
                short child0Value_ = (Short)child0Value;
                return this.fromShort(child0Value_, child1Value_);
            }
            if ((state_0 & 0x20) != 0 && child0Value instanceof Float) {
                float child0Value_ = ((Float)child0Value).floatValue();
                return this.fromFloat(child0Value_, child1Value_);
            }
            if ((state_0 & 0x40) != 0 && child0Value instanceof Double) {
                double child0Value_ = (Double)child0Value;
                return this.fromDouble(child0Value_, child1Value_);
            }
            if ((state_0 & 0x80) != 0 && child0Value instanceof Boolean) {
                boolean child0Value_ = (Boolean)child0Value;
                return this.fromBoolean(child0Value_, child1Value_);
            }
            if ((state_0 & 0x100) != 0 && child0Value instanceof String) {
                String child0Value_ = (String)child0Value;
                return this.fromString(child0Value_, child1Value_);
            }
            if ((state_0 & 0x200) != 0 && LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                return this.fromPointer(child0Value_, child1Value_);
            }
            if ((state_0 & 0xC00) != 0) {
                if ((state_0 & 0x400) != 0 && this.fromTypedTruffleObjectNoAttachedType_foreigns_.isForeign(child0Value) && (this.fromTypedTruffleObjectNoAttachedType_nativeTypes_.hasNativeType(child0Value) || child1Value_ == null)) {
                    return this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value_, this.fromTypedTruffleObjectNoAttachedType_nativeTypes_, this.fromTypedTruffleObjectNoAttachedType_foreigns_);
                }
                if ((state_0 & 0x800) != 0 && this.fromNonTypedTruffleObject_foreigns_.isForeign(child0Value) && !this.fromNonTypedTruffleObject_nativeTypes_.hasNativeType(child0Value) && child1Value_ != null) {
                    return this.fromNonTypedTruffleObject(child0Value, child1Value_, this.fromNonTypedTruffleObject_nativeTypes_, this.fromNonTypedTruffleObject_foreigns_);
                }
            }
            if ((state_0 & 0x1000) != 0 && child0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject child0Value_ = (LLVMInternalTruffleObject)child0Value;
                return this.fromInternal(child0Value_, child1Value_);
            }
            if ((state_0 & 0x2000) != 0 && child0Value instanceof LLVMInteropType) {
                LLVMInteropType child0Value_ = (LLVMInteropType)child0Value;
                return this.fromInteropType(child0Value_, child1Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value, child1Value_);
    }

    private Object executeAndSpecialize(Object child0Value, LLVMInteropType.Structured child1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            TruffleObject truffleObject;
            Object child0Value_;
            NativeTypeLibrary fromNonTypedTruffleObject_nativeTypes__;
            NativeTypeLibrary fromTypedTruffleObjectNoAttachedType_nativeTypes__;
            if (child0Value instanceof Integer) {
                int child0Value_2 = (Integer)child0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromInt(child0Value_2, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Character) {
                char child0Value_3 = ((Character)child0Value).charValue();
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromChar(child0Value_3, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Long) {
                long child0Value_4 = (Long)child0Value;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromLong(child0Value_4, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Byte) {
                byte child0Value_5 = (Byte)child0Value;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromByte(child0Value_5, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Short) {
                short child0Value_6 = (Short)child0Value;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromShort(child0Value_6, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Float) {
                float child0Value_7 = ((Float)child0Value).floatValue();
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromFloat(child0Value_7, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Double) {
                double child0Value_8 = (Double)child0Value;
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromDouble(child0Value_8, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof Boolean) {
                boolean child0Value_9 = (Boolean)child0Value;
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromBoolean(child0Value_9, child1Value);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof String) {
                String child0Value_10 = (String)child0Value;
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                String string = this.fromString(child0Value_10, child1Value);
                return string;
            }
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_11 = LLVMTypes.asPointer(child0Value);
                this.state_0_ = state_0 |= 0x200;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.fromPointer(child0Value_11, child1Value);
                return lLVMPointer;
            }
            LLVMAsForeignLibrary fromTypedTruffleObjectNoAttachedType_foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
            if (fromTypedTruffleObjectNoAttachedType_foreigns__.isForeign(child0Value) && ((fromTypedTruffleObjectNoAttachedType_nativeTypes__ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.createDispatched(3))).hasNativeType(child0Value) || child1Value == null)) {
                this.fromTypedTruffleObjectNoAttachedType_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)fromTypedTruffleObjectNoAttachedType_nativeTypes__);
                this.fromTypedTruffleObjectNoAttachedType_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)fromTypedTruffleObjectNoAttachedType_foreigns__);
                this.state_0_ = state_0 |= 0x400;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromTypedTruffleObjectNoAttachedType(child0Value, child1Value, fromTypedTruffleObjectNoAttachedType_nativeTypes__, fromTypedTruffleObjectNoAttachedType_foreigns__);
                return lLVMManagedPointer;
            }
            LLVMAsForeignLibrary fromNonTypedTruffleObject_foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
            if (fromNonTypedTruffleObject_foreigns__.isForeign(child0Value) && !(fromNonTypedTruffleObject_nativeTypes__ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.createDispatched(3))).hasNativeType(child0Value) && child1Value != null) {
                this.fromNonTypedTruffleObject_nativeTypes_ = (NativeTypeLibrary)super.insert((Node)fromNonTypedTruffleObject_nativeTypes__);
                this.fromNonTypedTruffleObject_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)fromNonTypedTruffleObject_foreigns__);
                this.state_0_ = state_0 |= 0x800;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromNonTypedTruffleObject(child0Value, child1Value, fromNonTypedTruffleObject_nativeTypes__, fromNonTypedTruffleObject_foreigns__);
                return lLVMManagedPointer;
            }
            if (child0Value instanceof LLVMInternalTruffleObject) {
                child0Value_ = (LLVMInternalTruffleObject)child0Value;
                this.state_0_ = state_0 |= 0x1000;
                lock.unlock();
                hasLock = false;
                truffleObject = this.fromInternal((LLVMInternalTruffleObject)child0Value_, child1Value);
                return truffleObject;
            }
            if (child0Value instanceof LLVMInteropType) {
                child0Value_ = (LLVMInteropType)child0Value;
                this.state_0_ = state_0 |= 0x2000;
                lock.unlock();
                hasLock = false;
                truffleObject = this.fromInteropType((LLVMInteropType)child0Value_, child1Value);
                return truffleObject;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToPointer create(ToPointer.Dummy child0, ToPointer.InteropTypeNode child1) {
        return new ToPointerNodeGen(child0, child1);
    }
}

