/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@NodeChildren(value={@NodeChild(type=Dummy.class), @NodeChild(type=InteropTypeNode.class)})
public abstract class ToPointer
extends ForeignToLLVM {
    public static ToPointer create() {
        return ToPointerNodeGen.create(null, new InteropTypeNode(null));
    }

    public static ToPointer create(LLVMInteropType.Structured type) {
        return ToPointerNodeGen.create(null, new InteropTypeNode(type));
    }

    @Specialization
    protected LLVMManagedPointer fromInt(int value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromChar(char value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(Character.valueOf(value));
    }

    @Specialization
    protected LLVMManagedPointer fromLong(long value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromByte(byte value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromShort(short value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromFloat(float value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(Float.valueOf(value));
    }

    @Specialization
    protected LLVMManagedPointer fromDouble(double value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromBoolean(boolean value, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected String fromString(String obj, LLVMInteropType.Structured typeFromMethodSignature) {
        return obj;
    }

    @Specialization
    protected LLVMPointer fromPointer(LLVMPointer pointer, LLVMInteropType.Structured typeFromMethodSignature) {
        return pointer;
    }

    @Specialization(guards={"foreigns.isForeign(obj)", "nativeTypes.hasNativeType(obj) || typeFromMethodSignature == null"})
    protected LLVMManagedPointer fromTypedTruffleObjectNoAttachedType(Object obj, LLVMInteropType.Structured typeFromMethodSignature, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return LLVMManagedPointer.create(obj);
    }

    @Specialization(guards={"foreigns.isForeign(obj)", "!nativeTypes.hasNativeType(obj)", "typeFromMethodSignature != null"})
    protected LLVMManagedPointer fromNonTypedTruffleObject(Object obj, LLVMInteropType.Structured typeFromMethodSignature, @CachedLibrary(limit="3") NativeTypeLibrary nativeTypes, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreigns) {
        return LLVMManagedPointer.create(LLVMTypedForeignObject.create(obj, typeFromMethodSignature));
    }

    @Specialization
    protected LLVMManagedPointer fromInternal(LLVMInternalTruffleObject object, LLVMInteropType.Structured typeFromMethodSignature) {
        return LLVMManagedPointer.create(object);
    }

    @Specialization
    protected LLVMInteropType fromInteropType(LLVMInteropType object, LLVMInteropType.Structured typeFromMethodSignature) {
        return object;
    }

    @CompilerDirectives.TruffleBoundary
    static Object slowPathPrimitiveConvert(Object value, LLVMInteropType.Structured typeFromMethodSignature) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return LLVMManagedPointer.create(value);
        }
        if (value instanceof Boolean) {
            return LLVMManagedPointer.create(value);
        }
        if (value instanceof Character) {
            return LLVMManagedPointer.create(value);
        }
        if (value instanceof String) {
            return value;
        }
        if (LLVMPointer.isInstance(value)) {
            return value;
        }
        if (value instanceof LLVMInternalTruffleObject) {
            return LLVMManagedPointer.create(value);
        }
        if (((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).isForeign(value)) {
            if (typeFromMethodSignature == null || ((NativeTypeLibrary)NativeTypeLibrary.getFactory().getUncached()).hasNativeType(value)) {
                return LLVMManagedPointer.create(value);
            }
            return LLVMManagedPointer.create(LLVMTypedForeignObject.create(value, typeFromMethodSignature));
        }
        if (value instanceof LLVMInteropType) {
            return value;
        }
        throw UnsupportedTypeException.create((Object[])new Object[]{value});
    }

    static final class InteropTypeNode
    extends LLVMNode {
        private final LLVMInteropType.Structured type;

        private InteropTypeNode(LLVMInteropType.Structured type) {
            this.type = type;
        }

        public LLVMInteropType.Structured execute() {
            return this.type;
        }
    }

    static abstract class Dummy
    extends LLVMNode {
        Dummy() {
        }

        protected abstract Object execute();
    }
}

