/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;

public abstract class ToDouble
extends ForeignToLLVM {
    @Specialization
    protected double fromInt(int value) {
        return value;
    }

    @Specialization
    protected double fromChar(char value) {
        return value;
    }

    @Specialization
    protected double fromLong(long value) {
        return value;
    }

    @Specialization
    protected double fromByte(byte value) {
        return value;
    }

    @Specialization
    protected double fromShort(short value) {
        return value;
    }

    @Specialization
    protected double fromFloat(float value) {
        return value;
    }

    @Specialization
    protected double fromDouble(double value) {
        return value;
    }

    @Specialization
    protected double fromBoolean(boolean value) {
        return value ? 1.0 : 0.0;
    }

    @Specialization
    protected double fromString(String value) {
        return this.getSingleStringCharacter(value);
    }

    @Specialization(limit="5", guards={"foreigns.isForeign(obj)", "interop.isNumber(foreigns.asForeign(obj))"})
    protected double fromForeign(Object obj, @CachedLibrary(value="obj") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        try {
            return interop.asDouble(foreigns.asForeign(obj));
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Polyglot number can't be converted to double.");
        }
    }

    @CompilerDirectives.TruffleBoundary
    static double slowPathPrimitiveConvert(ForeignToLLVM thiz, Object value) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            return thiz.getSingleStringCharacter((String)value);
        }
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asDouble(value);
        }
        catch (UnsupportedMessageException ex) {
            throw UnsupportedTypeException.create((Object[])new Object[]{value});
        }
    }
}

