/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMInteropAccessNode.class)
final class LLVMInteropAccessNodeGen
extends LLVMInteropAccessNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private LLVMInteropAccessNode.MakeAccessLocation array_makeAccessLocation_;
    @Node.Child
    private StructMemberData structMember_cache;
    @Node.Child
    private LLVMInteropAccessNode.MakeAccessLocation struct_makeAccessLocation_;

    private LLVMInteropAccessNodeGen() {
    }

    @Override
    @ExplodeLoop
    protected LLVMInteropAccessNode.AccessLocation execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && arg0Value instanceof LLVMInteropType.Array) {
                LLVMInteropType.Array arg0Value_ = (LLVMInteropType.Array)arg0Value;
                return this.doArray(arg0Value_, arg1Value, arg2Value, this.array_makeAccessLocation_);
            }
            if ((state_0 & 6) != 0 && arg0Value instanceof LLVMInteropType.Struct) {
                LLVMInteropType.Struct arg0Value_ = (LLVMInteropType.Struct)arg0Value;
                if ((state_0 & 2) != 0) {
                    StructMemberData s2_ = this.structMember_cache;
                    while (s2_ != null) {
                        if (LLVMInteropAccessNode.checkMember(arg0Value_, s2_.cachedMember_, arg2Value)) {
                            return this.doStructMember(arg0Value_, arg1Value, arg2Value, s2_.cachedMember_, s2_.makeAccessLocation_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0) {
                    return this.doStruct(arg0Value_, arg1Value, arg2Value, this.struct_makeAccessLocation_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private LLVMInteropAccessNode.AccessLocation executeAndSpecialize(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof LLVMInteropType.Array) {
                LLVMInteropType.Array arg0Value_ = (LLVMInteropType.Array)arg0Value;
                this.array_makeAccessLocation_ = (LLVMInteropAccessNode.MakeAccessLocation)super.insert((Node)MakeAccessLocationNodeGen.create());
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                LLVMInteropAccessNode.AccessLocation accessLocation = this.doArray(arg0Value_, arg1Value, arg2Value, this.array_makeAccessLocation_);
                return accessLocation;
            }
            if (arg0Value instanceof LLVMInteropType.Struct) {
                LLVMInteropType.Struct arg0Value_ = (LLVMInteropType.Struct)arg0Value;
                if (exclude == 0) {
                    LLVMInteropType.StructMember cachedMember__;
                    int count2_ = 0;
                    StructMemberData s2_ = this.structMember_cache;
                    if ((state_0 & 2) != 0) {
                        while (s2_ != null && !LLVMInteropAccessNode.checkMember(arg0Value_, s2_.cachedMember_, arg2Value)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && LLVMInteropAccessNode.checkMember(arg0Value_, cachedMember__ = LLVMInteropAccessNode.findMember(arg0Value_, arg2Value), arg2Value) && count2_ < 3) {
                        s2_ = (StructMemberData)super.insert((Node)new StructMemberData(this.structMember_cache));
                        s2_.cachedMember_ = cachedMember__;
                        s2_.makeAccessLocation_ = s2_.insertAccessor(MakeAccessLocationNodeGen.create());
                        this.structMember_cache = s2_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        LLVMInteropAccessNode.AccessLocation accessLocation = this.doStructMember(arg0Value_, arg1Value, arg2Value, s2_.cachedMember_, s2_.makeAccessLocation_);
                        return accessLocation;
                    }
                }
                this.struct_makeAccessLocation_ = (LLVMInteropAccessNode.MakeAccessLocation)super.insert((Node)MakeAccessLocationNodeGen.create());
                this.exclude_ = exclude |= 1;
                this.structMember_cache = null;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                LLVMInteropAccessNode.AccessLocation accessLocation = this.doStruct(arg0Value_, arg1Value, arg2Value, this.struct_makeAccessLocation_);
                return accessLocation;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        StructMemberData s2_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s2_ = this.structMember_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMInteropAccessNode create() {
        return new LLVMInteropAccessNodeGen();
    }

    public static LLVMInteropAccessNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMInteropAccessNode.MakeAccessLocation.class)
    static final class MakeAccessLocationNodeGen
    extends LLVMInteropAccessNode.MakeAccessLocation {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private RecursiveObject0Data recursiveObject0_cache;
        @Node.Child
        private LLVMInteropAccessNode recursiveObject1_recursive_;
        @Node.Child
        private RecursiveArray0Data recursiveArray0_cache;
        @Node.Child
        private LLVMInteropAccessNode recursiveArray1_recursive_;

        private MakeAccessLocationNodeGen() {
        }

        @Override
        @ExplodeLoop
        protected LLVMInteropAccessNode.AccessLocation execute(Object arg0Value, Object arg1Value, LLVMInteropType arg2Value, long arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg2Value instanceof LLVMInteropType.Value) {
                    LLVMInteropType.Value arg2Value_ = (LLVMInteropType.Value)arg2Value;
                    return this.doValue(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if ((state_0 & 0x1E) != 0 && arg2Value instanceof LLVMInteropType.Structured) {
                    LLVMInteropType.Structured arg2Value_ = (LLVMInteropType.Structured)arg2Value;
                    if ((state_0 & 6) != 0 && arg1Value instanceof String) {
                        String arg1Value_ = (String)arg1Value;
                        if ((state_0 & 2) != 0) {
                            RecursiveObject0Data s2_ = this.recursiveObject0_cache;
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg0Value)) {
                                    return this.doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, s2_.interop_, s2_.recursive_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 4) != 0) {
                            return this.recursiveObject1Boundary(state_0, arg0Value, arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 0x18) != 0 && arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        if ((state_0 & 8) != 0) {
                            RecursiveArray0Data s4_ = this.recursiveArray0_cache;
                            while (s4_ != null) {
                                if (s4_.interop_.accepts(arg0Value)) {
                                    return this.doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, s4_.interop_, s4_.recursive_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0x10) != 0) {
                            return this.recursiveArray1Boundary(state_0, arg0Value, arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMInteropAccessNode.AccessLocation recursiveObject1Boundary(int state_0, Object arg0Value, String arg1Value_, LLVMInteropType.Structured arg2Value_, long arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary recursiveObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                LLVMInteropAccessNode.AccessLocation accessLocation = this.doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, recursiveObject1_interop__, this.recursiveObject1_recursive_);
                return accessLocation;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private LLVMInteropAccessNode.AccessLocation recursiveArray1Boundary(int state_0, Object arg0Value, long arg1Value_, LLVMInteropType.Structured arg2Value_, long arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary recursiveArray1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                LLVMInteropAccessNode.AccessLocation accessLocation = this.doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, recursiveArray1_interop__, this.recursiveArray1_recursive_);
                return accessLocation;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LLVMInteropAccessNode.AccessLocation executeAndSpecialize(Object arg0Value, Object arg1Value, LLVMInteropType arg2Value, long arg3Value) {
            long arg1Value_;
            LLVMInteropType.Structured arg2Value_;
            boolean hasLock;
            Lock lock;
            block27: {
                RecursiveArray0Data s4_;
                int count4_;
                block28: {
                    block29: {
                        String arg1Value_2;
                        block24: {
                            RecursiveObject0Data s2_;
                            int count2_;
                            block25: {
                                block26: {
                                    block22: {
                                        int exclude;
                                        int state_0;
                                        block23: {
                                            lock = this.getLock();
                                            hasLock = true;
                                            lock.lock();
                                            state_0 = this.state_0_;
                                            exclude = this.exclude_;
                                            if (arg2Value instanceof LLVMInteropType.Value) {
                                                LLVMInteropType.Value arg2Value_2 = (LLVMInteropType.Value)arg2Value;
                                                this.state_0_ = state_0 |= 1;
                                                lock.unlock();
                                                hasLock = false;
                                                LLVMInteropAccessNode.AccessLocation accessLocation = this.doValue(arg0Value, arg1Value, arg2Value_2, arg3Value);
                                                return accessLocation;
                                            }
                                            if (!(arg2Value instanceof LLVMInteropType.Structured)) break block22;
                                            arg2Value_ = (LLVMInteropType.Structured)arg2Value;
                                            if (!(arg1Value instanceof String)) break block23;
                                            arg1Value_2 = (String)arg1Value;
                                            if ((exclude & 1) != 0) break block24;
                                            count2_ = 0;
                                            s2_ = this.recursiveObject0_cache;
                                            if ((state_0 & 2) == 0) break block25;
                                            break block26;
                                        }
                                        if (!(arg1Value instanceof Long)) break block22;
                                        arg1Value_ = (Long)arg1Value;
                                        if ((exclude & 2) != 0) break block27;
                                        count4_ = 0;
                                        s4_ = this.recursiveArray0_cache;
                                        if ((state_0 & 8) == 0) break block28;
                                        break block29;
                                    }
                                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
                                    finally {
                                        if (hasLock) {
                                            lock.unlock();
                                        }
                                    }
                                }
                                while (s2_ != null && !s2_.interop_.accepts(arg0Value)) {
                                    s2_ = s2_.next_;
                                    ++count2_;
                                }
                            }
                            if (s2_ == null && count2_ < 3) {
                                s2_ = (RecursiveObject0Data)super.insert((Node)new RecursiveObject0Data(this.recursiveObject0_cache));
                                s2_.interop_ = (InteropLibrary)s2_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                                s2_.recursive_ = s2_.insertAccessor(LLVMInteropAccessNode.create());
                                this.recursiveObject0_cache = s2_;
                                this.state_0_ = state_0 |= 2;
                            }
                            if (s2_ != null) {
                                lock.unlock();
                                hasLock = false;
                                LLVMInteropAccessNode.AccessLocation accessLocation = this.doRecursiveObject(arg0Value, arg1Value_2, arg2Value_, arg3Value, s2_.interop_, s2_.recursive_);
                                return accessLocation;
                            }
                        }
                        InteropLibrary recursiveObject1_interop__ = null;
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            recursiveObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                            this.recursiveObject1_recursive_ = (LLVMInteropAccessNode)super.insert((Node)LLVMInteropAccessNode.create());
                            this.exclude_ = exclude |= 1;
                            this.recursiveObject0_cache = null;
                            state_0 &= 0xFFFFFFFD;
                            this.state_0_ = state_0 |= 4;
                            lock.unlock();
                            hasLock = false;
                            LLVMInteropAccessNode.AccessLocation accessLocation = this.doRecursiveObject(arg0Value, arg1Value_2, arg2Value_, arg3Value, recursiveObject1_interop__, this.recursiveObject1_recursive_);
                            return accessLocation;
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    while (s4_ != null && !s4_.interop_.accepts(arg0Value)) {
                        s4_ = s4_.next_;
                        ++count4_;
                    }
                }
                if (s4_ == null && count4_ < 3) {
                    s4_ = (RecursiveArray0Data)super.insert((Node)new RecursiveArray0Data(this.recursiveArray0_cache));
                    s4_.interop_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    s4_.recursive_ = s4_.insertAccessor(LLVMInteropAccessNode.create());
                    this.recursiveArray0_cache = s4_;
                    this.state_0_ = state_0 |= 8;
                }
                if (s4_ != null) {
                    lock.unlock();
                    hasLock = false;
                    LLVMInteropAccessNode.AccessLocation accessLocation = this.doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, s4_.interop_, s4_.recursive_);
                    return accessLocation;
                }
            }
            InteropLibrary recursiveArray1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                recursiveArray1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                this.recursiveArray1_recursive_ = (LLVMInteropAccessNode)super.insert((Node)LLVMInteropAccessNode.create());
                this.exclude_ = exclude |= 2;
                this.recursiveArray0_cache = null;
                state_0 &= 0xFFFFFFF7;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                LLVMInteropAccessNode.AccessLocation accessLocation = this.doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, recursiveArray1_interop__, this.recursiveArray1_recursive_);
                return accessLocation;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                RecursiveObject0Data s2_ = this.recursiveObject0_cache;
                RecursiveArray0Data s4_ = this.recursiveArray0_cache;
                if (!(s2_ != null && s2_.next_ != null || s4_ != null && s4_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMInteropAccessNode.MakeAccessLocation create() {
            return new MakeAccessLocationNodeGen();
        }

        public static LLVMInteropAccessNode.MakeAccessLocation getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMInteropAccessNode.MakeAccessLocation.class)
        private static final class Uncached
        extends LLVMInteropAccessNode.MakeAccessLocation {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected LLVMInteropAccessNode.AccessLocation execute(Object arg0Value, Object arg1Value, LLVMInteropType arg2Value, long arg3Value) {
                if (arg2Value instanceof LLVMInteropType.Value) {
                    LLVMInteropType.Value arg2Value_ = (LLVMInteropType.Value)arg2Value;
                    return this.doValue(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof LLVMInteropType.Structured) {
                    LLVMInteropType.Structured arg2Value_ = (LLVMInteropType.Structured)arg2Value;
                    if (arg1Value instanceof String) {
                        String arg1Value_ = (String)arg1Value;
                        return this.doRecursiveObject(arg0Value, arg1Value_, arg2Value_, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), LLVMInteropAccessNodeGen.getUncached());
                    }
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        return this.doRecursiveArray(arg0Value, arg1Value_, arg2Value_, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), LLVMInteropAccessNodeGen.getUncached());
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMInteropAccessNode.MakeAccessLocation.class)
        private static final class RecursiveArray0Data
        extends Node {
            @Node.Child
            RecursiveArray0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMInteropAccessNode recursive_;

            RecursiveArray0Data(RecursiveArray0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropAccessNode.MakeAccessLocation.class)
        private static final class RecursiveObject0Data
        extends Node {
            @Node.Child
            RecursiveObject0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMInteropAccessNode recursive_;

            RecursiveObject0Data(RecursiveObject0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMInteropAccessNode.class)
    private static final class Uncached
    extends LLVMInteropAccessNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected LLVMInteropAccessNode.AccessLocation execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value) {
            if (arg0Value instanceof LLVMInteropType.Array) {
                LLVMInteropType.Array arg0Value_ = (LLVMInteropType.Array)arg0Value;
                return this.doArray(arg0Value_, arg1Value, arg2Value, MakeAccessLocationNodeGen.getUncached());
            }
            if (arg0Value instanceof LLVMInteropType.Struct) {
                LLVMInteropType.Struct arg0Value_ = (LLVMInteropType.Struct)arg0Value;
                return this.doStruct(arg0Value_, arg1Value, arg2Value, MakeAccessLocationNodeGen.getUncached());
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMInteropAccessNode.class)
    private static final class StructMemberData
    extends Node {
        @Node.Child
        StructMemberData next_;
        @CompilerDirectives.CompilationFinal
        LLVMInteropType.StructMember cachedMember_;
        @Node.Child
        LLVMInteropAccessNode.MakeAccessLocation makeAccessLocation_;

        StructMemberData(StructMemberData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

