/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObjectGen;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@GeneratedBy(value=LLVMTypedForeignObject.class)
final class LLVMTypedForeignObjectGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMTypedForeignObjectGen() {
    }

    static {
        LibraryExport.register(LLVMTypedForeignObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new NativeTypeLibraryExports(), new LLVMAsForeignLibraryExports()});
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends LLVMInternalTruffleObjectGen.LLVMAsForeignLibraryExports.Uncached {
            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isForeign();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object asForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).asForeign();
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends LLVMInternalTruffleObjectGen.LLVMAsForeignLibraryExports.Cached {
            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isForeign();
            }

            @Override
            public Object asForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).asForeign();
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class NativeTypeLibraryExports
    extends LibraryExport<NativeTypeLibrary> {
        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private NativeTypeLibraryExports() {
            super(NativeTypeLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected NativeTypeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected NativeTypeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return CACHE;
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends NativeTypeLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).hasNativeType();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).getNativeType();
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends NativeTypeLibrary {
            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public boolean hasNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).hasNativeType();
            }

            public Object getNativeType(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).getNativeType();
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet((LibraryFactory)LLVMTypedForeignObjectGen.access$300(), (String[])new String[]{"hasLanguage", "getLanguage", "toDisplayString"});
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)UNCACHED);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((LLVMTypedForeignObject)receiver_).foreign;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverForeignInteropLibrary_;

            protected Cached(Object receiver) {
                LLVMTypedForeignObject castReceiver = (LLVMTypedForeignObject)receiver;
                this.receiverForeignInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(castReceiver.foreign));
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((LLVMTypedForeignObject)receiver_).foreign;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverForeignInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                }
                return this.receiverForeignInteropLibrary_.accepts(((LLVMTypedForeignObject)receiver).foreign);
            }

            public boolean hasLanguage(Object receiver) {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).toDisplayString(allowSideEffects);
            }
        }
    }
}

