/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@CompilerDirectives.ValueType
@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, delegateTo="foreign"), @ExportLibrary(value=NativeTypeLibrary.class), @ExportLibrary(value=LLVMAsForeignLibrary.class)})
public final class LLVMTypedForeignObject
extends LLVMInternalTruffleObject {
    final Object foreign;
    final LLVMInteropType.Structured type;

    public static LLVMTypedForeignObject create(Object foreign, LLVMInteropType.Structured type) {
        assert (type != null);
        return new LLVMTypedForeignObject(foreign, type);
    }

    private LLVMTypedForeignObject(Object foreign, LLVMInteropType.Structured type) {
        this.foreign = foreign;
        this.type = type;
    }

    public Object getForeign() {
        return this.foreign;
    }

    public LLVMInteropType.Structured getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LLVMTypedForeignObject) {
            LLVMTypedForeignObject other = (LLVMTypedForeignObject)obj;
            return this.foreign.equals(other.foreign);
        }
        return this.foreign == obj;
    }

    public int hashCode() {
        return this.foreign.hashCode();
    }

    @ExportMessage
    boolean hasNativeType() {
        return true;
    }

    @ExportMessage
    LLVMInteropType.Structured getNativeType() {
        return this.type;
    }

    @ExportMessage
    public boolean isForeign() {
        return true;
    }

    @ExportMessage
    public Object asForeign() {
        return this.foreign;
    }
}

