/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.types.Type;

public class LLVMForeignConstructorCallNode
extends LLVMForeignCallNode {
    private final TruffleLanguage.LanguageReference<LLVMLanguage> languageReference = this.lookupLanguageReference(LLVMLanguage.class);

    public static LLVMForeignConstructorCallNode create(LLVMLanguage language, LLVMFunctionDescriptor function, LLVMInteropType interopType, LLVMSourceFunctionType sourceType, LLVMInteropType.Structured structuredType) {
        Type escapeType = function.getLLVMFunction().getType().getArgumentType(0);
        return new LLVMForeignConstructorCallNode(language, function, interopType, sourceType, structuredType, escapeType);
    }

    protected LLVMForeignConstructorCallNode(LLVMLanguage language, LLVMFunctionDescriptor function, LLVMInteropType interopType, LLVMSourceFunctionType sourceType, LLVMInteropType.Structured structuredType, Type escapeType) {
        super(language, function, interopType, sourceType, structuredType, escapeType);
    }

    @Override
    protected Object doCall(VirtualFrame frame, LLVMStack stack) throws ArityException, Type.TypeOverflowException {
        Object[] rawArguments = frame.getArguments();
        rawArguments[0] = ((LLVMLanguage)this.languageReference.get()).getLLVMMemory().allocateMemory((Node)this, this.returnBaseType.getSize());
        if (this.packArguments.toLLVM.length != rawArguments.length) {
            throw ArityException.create((int)(this.packArguments.toLLVM.length - 1), (int)(rawArguments.length - 1));
        }
        Object[] arguments = this.packArguments.execute(rawArguments, stack);
        this.callNode.call(arguments);
        return arguments[1];
    }
}

