/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMDataEscapeNode.class)
public final class LLVMDataEscapeNodeFactory {
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMVoidDataEscapeNode.class)
    public static final class LLVMVoidDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMVoidDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMVoidDataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return this.doVoid(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.state_0_ = state_0 |= 1;
                return this.doVoid(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMVoidDataEscapeNode create() {
            return new LLVMVoidDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMVoidDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMVoidDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMVoidDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    return this.doVoid(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMPointerDataEscapeNode.class)
    public static final class LLVMPointerDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMPointerDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private EscapingForeignNonPointer0Data escapingForeignNonPointer0_cache;
        @Node.Child
        private EscapingManaged0Data escapingManaged0_cache;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile escapingManaged1_typedProfile_;

        private LLVMPointerDataEscapeNodeGen() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingString(arg0Value_, arg1Value);
                }
                if ((state_0 & 2) != 0 && arg0Value instanceof LLVMInteropType) {
                    LLVMInteropType arg0Value_ = (LLVMInteropType)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingType(arg0Value_, arg1Value);
                }
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0) {
                        EscapingForeignNonPointer0Data s3_ = this.escapingForeignNonPointer0_cache;
                        while (s3_ != null) {
                            if (s3_.foreigns_.accepts(arg0Value) && !LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isPrimitiveValue(arg0Value) && s3_.foreigns_.isForeign(arg0Value)) {
                                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeignNonPointer(arg0Value, arg1Value, s3_.foreigns_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            LLVMAsForeignLibrary escapingForeignNonPointer1_foreigns__;
                            if (!LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isPrimitiveValue(arg0Value) && (escapingForeignNonPointer1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(arg0Value)) {
                                Object object = this.escapingForeignNonPointer1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0x30) != 0 && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if ((state_0 & 0x10) != 0) {
                        EscapingManaged0Data s5_ = this.escapingManaged0_cache;
                        while (s5_ != null) {
                            if (s5_.foreigns_.accepts(arg0Value_) && !s5_.foreigns_.isForeign(arg0Value_)) {
                                return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value, s5_.foreigns_, s5_.typedProfile_);
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state_0 & 0x20) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            LLVMAsForeignLibrary escapingManaged1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached();
                            if (!escapingManaged1_foreigns__.isForeign(arg0Value_)) {
                                Object object = this.escapingManaged1Boundary(state_0, arg0Value_, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                if ((state_0 & 0x40) != 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 0x80) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object escapingForeignNonPointer1Boundary(int state_0, Object arg0Value, LLVMInteropType.Structured arg1Value) {
            LLVMAsForeignLibrary escapingForeignNonPointer1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached();
            return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeignNonPointer(arg0Value, arg1Value, escapingForeignNonPointer1_foreigns__);
        }

        @CompilerDirectives.TruffleBoundary
        private Object escapingManaged1Boundary(int state_0, LLVMPointer arg0Value_, LLVMInteropType.Structured arg1Value) {
            LLVMAsForeignLibrary escapingManaged1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached();
            return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value, escapingManaged1_foreigns__, this.escapingManaged1_typedProfile_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            int oldState_0 = state_0;
            int oldExclude = exclude;
            int oldCacheCount = this.countCaches();
            try {
                LLVMPointer lLVMPointer;
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingString(arg0Value_, arg1Value);
                    return string;
                }
                if (arg0Value instanceof LLVMInteropType) {
                    LLVMInteropType arg0Value_ = (LLVMInteropType)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingType(arg0Value_, arg1Value);
                    return object;
                }
                if ((exclude & 1) == 0) {
                    Object foreigns__;
                    int count3_ = 0;
                    EscapingForeignNonPointer0Data s3_ = this.escapingForeignNonPointer0_cache;
                    if ((state_0 & 4) != 0) {
                        while (!(s3_ == null || s3_.foreigns_.accepts(arg0Value) && !LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isPrimitiveValue(arg0Value) && s3_.foreigns_.isForeign(arg0Value))) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && !LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isPrimitiveValue(arg0Value) && (foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.create(arg0Value))).isForeign(arg0Value) && count3_ < 3) {
                        s3_ = (EscapingForeignNonPointer0Data)super.insert((Node)new EscapingForeignNonPointer0Data(this.escapingForeignNonPointer0_cache));
                        s3_.foreigns_ = s3_.insertAccessor(foreigns__);
                        this.escapingForeignNonPointer0_cache = s3_;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        foreigns__ = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeignNonPointer(arg0Value, arg1Value, s3_.foreigns_);
                        return foreigns__;
                    }
                }
                LLVMAsForeignLibrary escapingForeignNonPointer1_foreigns__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (!LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isPrimitiveValue(arg0Value) && (escapingForeignNonPointer1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached()).isForeign(arg0Value)) {
                        this.exclude_ = exclude |= 1;
                        this.escapingForeignNonPointer0_cache = null;
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        Object object = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeignNonPointer(arg0Value, arg1Value, escapingForeignNonPointer1_foreigns__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if ((exclude & 2) == 0) {
                        Object foreigns__1;
                        int count5_ = 0;
                        EscapingManaged0Data s5_ = this.escapingManaged0_cache;
                        if ((state_0 & 0x10) != 0) {
                            while (s5_ != null && (!s5_.foreigns_.accepts(arg0Value_) || s5_.foreigns_.isForeign(arg0Value_))) {
                                s5_ = s5_.next_;
                                ++count5_;
                            }
                        }
                        if (s5_ == null && !(foreigns__1 = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.create((Object)arg0Value_))).isForeign(arg0Value_) && count5_ < 3) {
                            s5_ = (EscapingManaged0Data)super.insert((Node)new EscapingManaged0Data(this.escapingManaged0_cache));
                            s5_.foreigns_ = s5_.insertAccessor(foreigns__1);
                            s5_.typedProfile_ = ConditionProfile.create();
                            this.escapingManaged0_cache = s5_;
                            this.state_0_ = state_0 |= 0x10;
                        }
                        if (s5_ != null) {
                            lock.unlock();
                            hasLock = false;
                            foreigns__1 = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value, s5_.foreigns_, s5_.typedProfile_);
                            return foreigns__1;
                        }
                    }
                    LLVMAsForeignLibrary escapingManaged1_foreigns__ = null;
                    EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                    Node prev_2 = encapsulating_2.set((Node)this);
                    try {
                        escapingManaged1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached();
                        if (!escapingManaged1_foreigns__.isForeign(arg0Value_)) {
                            this.escapingManaged1_typedProfile_ = ConditionProfile.create();
                            this.exclude_ = exclude |= 2;
                            this.escapingManaged0_cache = null;
                            state_0 &= 0xFFFFFFEF;
                            this.state_0_ = state_0 |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            Object object = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value, escapingManaged1_foreigns__, this.escapingManaged1_typedProfile_);
                            return object;
                        }
                    }
                    finally {
                        encapsulating_2.set(prev_2);
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    lLVMPointer = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return lLVMPointer;
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    lLVMPointer = LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return lLVMPointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (oldState_0 != 0 || oldExclude != 0) {
                    this.checkForPolymorphicSpecialize(oldState_0, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState_0, int oldExclude, int oldCacheCount) {
            int newState_0 = this.state_0_;
            int newExclude = this.exclude_;
            if ((oldState_0 ^ newState_0) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            EscapingForeignNonPointer0Data s3_ = this.escapingForeignNonPointer0_cache;
            while (s3_ != null) {
                ++cacheCount;
                s3_ = s3_.next_;
            }
            EscapingManaged0Data s5_ = this.escapingManaged0_cache;
            while (s5_ != null) {
                ++cacheCount;
                s5_ = s5_.next_;
            }
            return cacheCount;
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                EscapingForeignNonPointer0Data s3_ = this.escapingForeignNonPointer0_cache;
                EscapingManaged0Data s5_ = this.escapingManaged0_cache;
                if (!(s3_ != null && s3_.next_ != null || s5_ != null && s5_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMPointerDataEscapeNode create() {
            return new LLVMPointerDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMPointerDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMPointerDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMPointerDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingString(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof LLVMInteropType) {
                    LLVMInteropType arg0Value_ = (LLVMInteropType)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingType(arg0Value_, arg1Value);
                }
                if (!LLVMDataEscapeNode.LLVMPointerDataEscapeNode.isPrimitiveValue(arg0Value) && ((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value)).isForeign(arg0Value)) {
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingForeignNonPointer(arg0Value, arg1Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value));
                }
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if (!((LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached((Object)arg0Value_)).isForeign(arg0Value_)) {
                        return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingManaged(arg0Value_, arg1Value, (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached((Object)arg0Value_), ConditionProfile.getUncached());
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMPointerDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMPointerDataEscapeNode.class)
        private static final class EscapingManaged0Data
        extends Node {
            @Node.Child
            EscapingManaged0Data next_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile typedProfile_;

            EscapingManaged0Data(EscapingManaged0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMPointerDataEscapeNode.class)
        private static final class EscapingForeignNonPointer0Data
        extends Node {
            @Node.Child
            EscapingForeignNonPointer0Data next_;
            @Node.Child
            LLVMAsForeignLibrary foreigns_;

            EscapingForeignNonPointer0Data(EscapingForeignNonPointer0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.class)
    public static final class LLVMDoubleDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMDoubleDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private EscapingPointer0Data escapingPointer0_cache;

        private LLVMDoubleDataEscapeNodeGen() {
        }

        @Override
        @ExplodeLoop
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 2) != 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingLong(arg0Value_, arg1Value);
                }
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0) {
                        EscapingPointer0Data s3_ = this.escapingPointer0_cache;
                        while (s3_ != null) {
                            if (s3_.library_.accepts(arg0Value)) {
                                return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, s3_.library_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        return this.escapingPointer1Boundary(state_0, arg0Value, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object escapingPointer1Boundary(int state_0, Object arg0Value, LLVMInteropType.Structured arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                LLVMNativeLibrary escapingPointer1_library__ = (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value);
                Double d = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, escapingPointer1_library__);
                return d;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                double d;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    double d2 = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return d2;
                }
                if ((exclude & 1) == 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    double d3 = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingLong(arg0Value_, arg1Value);
                    return d3;
                }
                if ((exclude & 2) == 0) {
                    int count3_ = 0;
                    EscapingPointer0Data s3_ = this.escapingPointer0_cache;
                    if ((state_0 & 4) != 0) {
                        while (s3_ != null && !s3_.library_.accepts(arg0Value)) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && count3_ < 3) {
                        s3_ = (EscapingPointer0Data)super.insert((Node)new EscapingPointer0Data(this.escapingPointer0_cache));
                        s3_.library_ = (LLVMNativeLibrary)s3_.insertAccessor(L_L_V_M_NATIVE_LIBRARY_.create(arg0Value));
                        this.escapingPointer0_cache = s3_;
                        this.exclude_ = exclude |= 1;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        double d4 = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, s3_.library_);
                        return d4;
                    }
                }
                LLVMNativeLibrary escapingPointer1_library__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    escapingPointer1_library__ = (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value);
                    this.exclude_ = exclude |= 3;
                    this.escapingPointer0_cache = null;
                    state_0 &= 0xFFFFFFF9;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    d = LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, escapingPointer1_library__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return d;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            EscapingPointer0Data s3_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s3_ = this.escapingPointer0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMDoubleDataEscapeNode create() {
            return new LLVMDoubleDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMDoubleDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMDoubleDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                return LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.escapingPointer(arg0Value, arg1Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMDoubleDataEscapeNode.class)
        private static final class EscapingPointer0Data
        extends Node {
            @Node.Child
            EscapingPointer0Data next_;
            @Node.Child
            LLVMNativeLibrary library_;

            EscapingPointer0Data(EscapingPointer0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMFloatDataEscapeNode.class)
    public static final class LLVMFloatDataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMFloatDataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFloatDataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
                if ((state_0 & 2) != 0 && arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        private float executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_0_ = state_0 |= 1;
                return LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_0_ = state_0 |= 2;
                return LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMFloatDataEscapeNode create() {
            return new LLVMFloatDataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMFloatDataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMFloatDataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMFloatDataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return Float.valueOf(LLVMDataEscapeNode.LLVMFloatDataEscapeNode.escapingPrimitive(arg0Value_, arg1Value));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI64DataEscapeNode.class)
    public static final class LLVMI64DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI64DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private LLVMDataEscapeNode.LLVMPointerDataEscapeNode escapingPointer_pointerDataEscapeNode_;

        private LLVMI64DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 2) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingNativePointer(arg0Value_, arg1Value);
                }
                if ((state_0 & 8) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value_, arg1Value, this.escapingPointer_pointerDataEscapeNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public long executeWithTypeI64(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 8) != 0) {
                return (Long)this.executeWithType(arg0Value, arg1Value);
            }
            if ((state_0 & 7) != 0) {
                if ((state_0 & 1) != 0 && arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 2) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingNativePointer(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return (Long)this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Long l = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return l;
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Long l = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                    return l;
                }
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Long l = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingNativePointer(arg0Value_, arg1Value);
                    return l;
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    this.escapingPointer_pointerDataEscapeNode_ = (LLVMDataEscapeNode.LLVMPointerDataEscapeNode)super.insert((Node)LLVMPointerDataEscapeNodeGen.create());
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value_, arg1Value, this.escapingPointer_pointerDataEscapeNode_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI64DataEscapeNode create() {
            return new LLVMI64DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI64DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI64DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI64DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingNativePointer(arg0Value_, arg1Value);
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value_, arg1Value, LLVMPointerDataEscapeNodeGen.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long executeWithTypeI64(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    return LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingNativePointer(arg0Value_, arg1Value);
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return (Long)LLVMDataEscapeNode.LLVMI64DataEscapeNode.escapingPointer(arg0Value_, arg1Value, LLVMPointerDataEscapeNodeGen.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI32DataEscapeNode.class)
    public static final class LLVMI32DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI32DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI32DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 2) != 0 && arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public int executeWithTypeI32(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if ((state_0 & 2) != 0 && arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_0_ = state_0 |= 1;
                return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_0_ = state_0 |= 2;
                return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI32DataEscapeNode create() {
            return new LLVMI32DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI32DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI32DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI32DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int executeWithTypeI32(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof Float) {
                    float arg0Value_ = ((Float)arg0Value).floatValue();
                    return LLVMDataEscapeNode.LLVMI32DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI16DataEscapeNode.class)
    public static final class LLVMI16DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI16DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI16DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public short executeWithTypeI16(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private short executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                this.state_0_ = state_0 |= 1;
                return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI16DataEscapeNode create() {
            return new LLVMI16DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI16DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI16DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI16DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Short) {
                    short arg0Value_ = (Short)arg0Value;
                    return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short executeWithTypeI16(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Short) {
                    short arg0Value_ = (Short)arg0Value;
                    return LLVMDataEscapeNode.LLVMI16DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI8DataEscapeNode.class)
    public static final class LLVMI8DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI8DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI8DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return LLVMDataEscapeNode.LLVMI8DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private byte executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_0_ = state_0 |= 1;
                return LLVMDataEscapeNode.LLVMI8DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI8DataEscapeNode create() {
            return new LLVMI8DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI8DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI8DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI8DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Byte) {
                    byte arg0Value_ = (Byte)arg0Value;
                    return LLVMDataEscapeNode.LLVMI8DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMDataEscapeNode.LLVMI1DataEscapeNode.class)
    public static final class LLVMI1DataEscapeNodeGen
    extends LLVMDataEscapeNode.LLVMI1DataEscapeNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMI1DataEscapeNodeGen() {
        }

        @Override
        public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return LLVMDataEscapeNode.LLVMI1DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state_0 = this.state_0_;
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_0_ = state_0 |= 1;
                return LLVMDataEscapeNode.LLVMI1DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMDataEscapeNode.LLVMI1DataEscapeNode create() {
            return new LLVMI1DataEscapeNodeGen();
        }

        public static LLVMDataEscapeNode.LLVMI1DataEscapeNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMDataEscapeNode.LLVMI1DataEscapeNode.class)
        private static final class Uncached
        extends LLVMDataEscapeNode.LLVMI1DataEscapeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object executeWithType(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    return LLVMDataEscapeNode.LLVMI1DataEscapeNode.escapingPrimitive(arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }
}

