/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.instruments.trace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.Arrays;

final class LLVMTraceNodeFactory
implements ExecutionEventNodeFactory {
    private final PrintStream traceTarget;
    private final TraceContext traceContext;

    LLVMTraceNodeFactory(PrintStream target) {
        this.traceTarget = target;
        this.traceContext = new TraceContext();
    }

    public ExecutionEventNode create(EventContext eventContext) {
        if (eventContext.hasTag(StandardTags.RootTag.class)) {
            assert (eventContext.getInstrumentedNode() != null);
            RootNode rootNode = eventContext.getInstrumentedNode().getRootNode();
            assert (rootNode != null);
            SourceSection sourceSection = rootNode.getSourceSection();
            return new RootTrace(this.traceContext, this.traceTarget, rootNode.getName(), LLVMTraceNodeFactory.toTraceLine(sourceSection, false));
        }
        if (eventContext.hasTag(StandardTags.StatementTag.class)) {
            return new StatementTrace(this.traceContext, this.traceTarget, LLVMTraceNodeFactory.toTraceLine(eventContext.getInstrumentedSourceSection(), true));
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException("Unknown node for tracing: " + eventContext.getInstrumentedNode());
    }

    @CompilerDirectives.TruffleBoundary
    private static String toTraceLine(SourceSection sourceSection, boolean includeText) {
        StringBuilder builder = new StringBuilder();
        builder.append(sourceSection.getSource().getName());
        if (sourceSection.getStartLine() > 0) {
            builder.append(':');
            builder.append(sourceSection.getStartLine());
            if (sourceSection.getStartColumn() > 0) {
                builder.append(':');
                builder.append(sourceSection.getStartColumn());
            }
        }
        if (includeText && sourceSection.getCharLength() > 0) {
            builder.append(" -> ");
            builder.append(sourceSection.getCharacters());
        }
        return builder.toString();
    }

    private static final class RootTrace
    extends TraceNode {
        private final String enterPrefix;
        private final String exitPrefix;
        private final String exceptionPrefix;

        @CompilerDirectives.TruffleBoundary
        RootTrace(TraceContext context, PrintStream out, String functionName, String sourceSection) {
            super(context, out);
            this.enterPrefix = String.format("Entering function %s at %s with arguments:", functionName, sourceSection);
            this.exitPrefix = "Leaving " + functionName;
            this.exceptionPrefix = "Exceptionally leaving " + functionName;
        }

        @CompilerDirectives.TruffleBoundary
        private void traceFunctionArgs(Object[] arguments) {
            this.trace(this.enterPrefix + Arrays.toString(arguments));
        }

        protected void onEnter(VirtualFrame frame) {
            this.getTraceContext().enterFunction();
            this.traceFunctionArgs(frame.getArguments());
            this.flushTraceBuffer();
        }

        protected void onReturnValue(VirtualFrame frame, Object result) {
            this.trace(this.exitPrefix);
            this.getTraceContext().exitFunction();
            this.flushTraceBuffer();
        }

        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            this.trace(this.exceptionPrefix);
            this.getTraceContext().exitFunction();
            this.flushTraceBuffer();
        }
    }

    private static final class StatementTrace
    extends TraceNode {
        private final String location;

        private StatementTrace(TraceContext context, PrintStream out, String location) {
            super(context, out);
            this.location = location;
        }

        protected void onEnter(VirtualFrame frame) {
            this.trace(this.location);
        }
    }

    private static abstract class TraceNode
    extends ExecutionEventNode {
        private final TraceContext context;
        private final PrintStream out;

        TraceNode(TraceContext context, PrintStream out) {
            this.context = context;
            this.out = out;
        }

        @CompilerDirectives.TruffleBoundary
        void trace(String message) {
            this.out.print("[lli] ");
            for (int i = 0; i < this.context.getStackDepth(); ++i) {
                this.out.print(">>");
            }
            this.out.print(' ');
            this.out.println(message);
        }

        @CompilerDirectives.TruffleBoundary
        void flushTraceBuffer() {
            this.out.flush();
        }

        TraceContext getTraceContext() {
            return this.context;
        }
    }

    private static final class TraceContext {
        static final String STACK_DEPTH_INDENT = ">>";
        private int stackDepth = 0;

        private TraceContext() {
        }

        private void enterFunction() {
            ++this.stackDepth;
        }

        private void exitFunction() {
            --this.stackDepth;
        }

        private int getStackDepth() {
            return this.stackDepth;
        }
    }
}

