/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.global;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMManagedReadLibrary.class), @ExportLibrary(value=LLVMManagedWriteLibrary.class)})
public final class LLVMGlobalContainer
extends LLVMInternalTruffleObject {
    private static final int MAX_CACHED_WRITES = 3;
    private long address;
    @CompilerDirectives.CompilationFinal
    private State contents = new State(0L, 0);
    private Object fallbackContents;

    public Object get() {
        while (true) {
            State c = this.contents;
            if (c.assumption.isValid()) {
                return c.value;
            }
            if (c.writeCount == 3) {
                return this.fallbackContents;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
    }

    public void set(Object value, BranchProfile needsInitialize, BranchProfile needsInvalidation) {
        State c = this.contents;
        if (c.writeCount < 3) {
            needsInitialize.enter();
            this.contents = new State(value, c.writeCount + 1);
            c.assumption.invalidate();
        } else {
            if (c.assumption.isValid()) {
                needsInvalidation.enter();
                c.assumption.invalidate();
            }
            this.fallbackContents = value;
        }
    }

    @ExportMessage
    public boolean isPointer() {
        return this.address != 0L;
    }

    @ExportMessage
    public long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.address;
        }
        throw UnsupportedMessageException.create();
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return 1;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public void toNative(@Cached LLVMToNativeNode toNative) {
        if (this.address == 0L) {
            LLVMMemory memory = LLVMLanguage.getLanguage().getLLVMMemory();
            LLVMNativePointer pointer = memory.allocateMemory(toNative, 8L);
            this.address = pointer.asNative();
            Object global = this.get();
            long value = global instanceof Number ? ((Number)global).longValue() : toNative.executeWithTarget(global).asNative();
            memory.putI64((Node)toNative, pointer, value);
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    public void dispose() {
        if (this.address != 0L) {
            LLVMMemory memory = LLVMLanguage.getLanguage().getLLVMMemory();
            memory.free(null, this.address);
            this.address = 0L;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("LLVMGlobalContainer (address = 0x%x, contents = %s)", this.address, this.contents);
    }

    @ExportMessage
    static class WriteGenericI64 {
        WriteGenericI64() {
        }

        @Specialization(limit="3", guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, Object value, @CachedLibrary(value="value") LLVMNativeLibrary toNative, @CachedLanguage LLVMLanguage language) {
            long ptr = toNative.toNativePointer(value).asNative();
            language.getLLVMMemory().putI64((Node)toNative, self.getAddress() + offset, ptr);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"})
        static void writeManaged(LLVMGlobalContainer self, long offset, Object value, @Cached.Shared(value="p1") @Cached BranchProfile needsInitialize, @Cached.Shared(value="p2") @Cached BranchProfile needsInvalidation) {
            assert (offset == 0L);
            self.set(value, needsInitialize, needsInvalidation);
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        static void writeFallback(LLVMGlobalContainer self, long offset, Object value, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedWriteLibrary write) {
            interop.toNative((Object)self);
            write.writeGenericI64(self, offset, value);
        }
    }

    @ExportMessage
    static class WriteI64 {
        WriteI64() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, long value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI64((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"})
        static void writeManaged(LLVMGlobalContainer self, long offset, long value, @Cached.Shared(value="p1") @Cached BranchProfile needsInitialize, @Cached.Shared(value="p2") @Cached BranchProfile needsInvalidation) {
            assert (offset == 0L);
            self.set(value, needsInitialize, needsInvalidation);
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        static void writeFallback(LLVMGlobalContainer self, long offset, long value, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedWriteLibrary write) {
            interop.toNative((Object)self);
            write.writeI64(self, offset, value);
        }
    }

    @ExportMessage
    static class WriteDouble {
        WriteDouble() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, double value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putDouble((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        static void writeManaged(LLVMGlobalContainer self, long offset, double value, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedWriteLibrary write) {
            interop.toNative((Object)self);
            write.writeDouble(self, offset, value);
        }
    }

    @ExportMessage
    static class WriteFloat {
        WriteFloat() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, float value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putFloat((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        static void writeManaged(LLVMGlobalContainer self, long offset, float value, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedWriteLibrary write) {
            interop.toNative((Object)self);
            write.writeFloat(self, offset, value);
        }
    }

    @ExportMessage
    static class WriteI32 {
        WriteI32() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, int value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI32((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        static void writeManaged(LLVMGlobalContainer self, long offset, int value, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedWriteLibrary write) {
            interop.toNative((Object)self);
            write.writeI32(self, offset, value);
        }
    }

    @ExportMessage
    static class WriteI16 {
        WriteI16() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, short value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI16((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        static void writeManaged(LLVMGlobalContainer self, long offset, short value, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedWriteLibrary write) {
            interop.toNative((Object)self);
            write.writeI16(self, offset, value);
        }
    }

    @ExportMessage
    static class WriteI8 {
        WriteI8() {
        }

        @Specialization(guards={"self.isPointer()"})
        static void writeNative(LLVMGlobalContainer self, long offset, byte value, @CachedLibrary(value="self") LLVMManagedWriteLibrary location, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI8((Node)location, self.getAddress() + offset, value);
        }

        @Specialization(guards={"!self.isPointer()"})
        static void writeManaged(LLVMGlobalContainer self, long offset, byte value, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedWriteLibrary write) {
            interop.toNative((Object)self);
            write.writeI8(self, offset, value);
        }
    }

    @ExportMessage
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"self.isPointer()"})
        static LLVMPointer readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getPointer((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"})
        static LLVMPointer readManaged(LLVMGlobalContainer self, long offset, @Cached LLVMToPointerNode toPointer) {
            assert (offset == 0L);
            return toPointer.executeWithTarget(self.get());
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        static LLVMPointer readFallback(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedReadLibrary read) {
            interop.toNative((Object)self);
            return read.readPointer(self, offset);
        }
    }

    @ExportMessage
    static class ReadGenericI64 {
        ReadGenericI64() {
        }

        @Specialization(guards={"self.isPointer()"})
        static long readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getI64((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()", "offset == 0"})
        static Object readManaged(LLVMGlobalContainer self, long offset) {
            assert (offset == 0L);
            return self.get();
        }

        @Specialization(guards={"!self.isPointer()", "offset != 0"})
        static Object readFallback(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedReadLibrary read) {
            interop.toNative((Object)self);
            return read.readGenericI64(self, offset);
        }
    }

    @ExportMessage
    static class ReadDouble {
        ReadDouble() {
        }

        @Specialization(guards={"self.isPointer()"})
        static double readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getDouble((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        static double readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedReadLibrary read) {
            interop.toNative((Object)self);
            return read.readDouble(self, offset);
        }
    }

    @ExportMessage
    static class ReadFloat {
        ReadFloat() {
        }

        @Specialization(guards={"self.isPointer()"})
        static float readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getFloat((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        static float readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedReadLibrary read) {
            interop.toNative((Object)self);
            return read.readFloat(self, offset);
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"self.isPointer()"})
        static int readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getI32((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        static int readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedReadLibrary read) {
            interop.toNative((Object)self);
            return read.readI32(self, offset);
        }
    }

    @ExportMessage
    static class ReadI16 {
        ReadI16() {
        }

        @Specialization(guards={"self.isPointer()"})
        static short readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getI16((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        static short readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedReadLibrary read) {
            interop.toNative((Object)self);
            return read.readI16(self, offset);
        }
    }

    @ExportMessage
    static class ReadI8 {
        ReadI8() {
        }

        @Specialization(guards={"self.isPointer()"})
        static byte readNative(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") LLVMManagedReadLibrary location, @CachedLanguage LLVMLanguage language) {
            return language.getLLVMMemory().getI8((Node)location, self.getAddress() + offset);
        }

        @Specialization(guards={"!self.isPointer()"})
        static byte readManaged(LLVMGlobalContainer self, long offset, @CachedLibrary(value="self") InteropLibrary interop, @CachedLibrary(value="self") LLVMManagedReadLibrary read) {
            interop.toNative((Object)self);
            return read.readI8(self, offset);
        }
    }

    private static final class State {
        final Object value;
        final Assumption assumption;
        final int writeCount;

        State(Object value, int writeCount) {
            assert (writeCount <= 3);
            this.value = value;
            this.writeCount = writeCount;
            this.assumption = Truffle.getRuntime().createAssumption();
        }
    }
}

