/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.floating;

import com.oracle.truffle.llvm.runtime.floating.BinaryHelper;

final class DoubleHelper {
    static final int DOUBLE_EXPONENT_BIAS = 1023;
    static final long DOUBLE_FRACTION_BIT_WIDTH = 52L;
    static final int DOUBLE_SIGN_POS = 63;
    static final double POSITIVE_ZERO = 0.0;
    static final double NEGATIVE_ZERO = -0.0;
    static final double NaN = Double.NaN;
    static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    static final long FRACTION_MASK = BinaryHelper.getBitMask(52L);

    DoubleHelper() {
    }

    static boolean isPositiveZero(double val) {
        return Double.doubleToLongBits(0.0) == Double.doubleToLongBits(val);
    }

    static boolean isNegativeZero(double val) {
        return Double.doubleToLongBits(-0.0) == Double.doubleToLongBits(val);
    }

    static boolean isPositiveInfinty(double val) {
        return val == Double.POSITIVE_INFINITY;
    }

    static boolean isNegativeInfinity(double val) {
        return val == Double.NEGATIVE_INFINITY;
    }

    static boolean isNaN(double val) {
        return Double.isNaN(val);
    }

    static int getUnbiasedExponent(double val) {
        return Math.getExponent(val);
    }
}

